/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class Quilling {
    public List<Chime> chimes = new ArrayList<Chime>();
    public double maxPull;

    public Quilling(JsonArray jsonElement) {
        for (JsonElement quill : jsonElement) {
            Chime chime = new Chime(quill.getAsJsonObject());
            this.chimes.add(chime);
            this.maxPull = Math.max(this.maxPull, chime.pull_end);
        }
    }

    public Quilling(ResourceLocation sample) {
        double pitchUp = 0.14;
        this.chimes.add(new Chime(0.15, 0.45, 0.75 + pitchUp, 0.85 + pitchUp, sample));
        this.chimes.add(new Chime(0.4, 0.55, 0.95 + pitchUp, 1.0 + pitchUp, sample));
        this.maxPull = 0.55;
    }

    public class Chime {
        public final double pull_start;
        public final double pull_end;
        public final double pitch_start;
        public final double pitch_end;
        public final ResourceLocation sample;

        public Chime(JsonObject data) {
            this.pull_start = data.get("pull_start").getAsDouble();
            this.pull_end = data.get("pull_end").getAsDouble();
            this.pitch_start = data.get("pitch_start").getAsDouble();
            this.pitch_end = data.get("pitch_end").getAsDouble();
            this.sample = new ResourceLocation("immersiverailroading", data.get("sample").getAsString());
        }

        public Chime(double pull_start, double pull_end, double pitch_start, double pitch_end, ResourceLocation sample) {
            this.pull_start = pull_start;
            this.pull_end = pull_end;
            this.pitch_start = pitch_start;
            this.pitch_end = pitch_end;
            this.sample = sample;
        }
    }
}

