/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.registry.CarTankDefinition;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TenderDefinition
extends CarTankDefinition {
    private int numSlots;
    private int width;
    private boolean showCurrentLoadOnly;

    public TenderDefinition(String defID, JsonObject data) throws Exception {
        super(defID, data);
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject tender = data.get("tender").getAsJsonObject();
        this.numSlots = (int)Math.ceil((double)tender.get("slots").getAsInt() * this.internal_inv_scale);
        this.width = (int)Math.ceil((double)tender.get("width").getAsInt() * this.internal_inv_scale);
        this.showCurrentLoadOnly = false;
        if (tender.has("show_current_load_only")) {
            this.showCurrentLoadOnly = tender.get("show_current_load_only").getAsBoolean();
        }
    }

    @Override
    public List<String> getTooltip(Gauge gauge) {
        List<String> tips = super.getTooltip(gauge);
        tips.add(GuiText.FREIGHT_CAPACITY_TOOLTIP.toString(this.getInventorySize(gauge)));
        return tips;
    }

    @Override
    public EntityRollingStock instance(World world) {
        return new Tender(world, this.defID);
    }

    public int getInventorySize(Gauge gauge) {
        return MathHelper.func_76143_f((double)((double)this.numSlots * gauge.scale()));
    }

    public int getInventoryWidth(Gauge gauge) {
        return MathHelper.func_76143_f((double)((double)this.width * gauge.scale()));
    }

    @Override
    public boolean shouldShowCurrentLoadOnly() {
        return this.showCurrentLoadOnly;
    }
}

