/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.model.obj.Material;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import cam72cam.immersiverailroading.render.OBJTextureSheet;
import cam72cam.immersiverailroading.render.VBA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class OBJRender {
    public OBJModel model;
    public Map<String, OBJTextureSheet> textures = new HashMap<String, OBJTextureSheet>();
    private int prevTexture = -1;
    private VBA vba;

    public OBJRender(OBJModel model) {
        this(model, null);
    }

    public OBJRender(OBJModel model, Collection<String> textureNames) {
        this.model = model;
        if (textureNames != null && textureNames.size() > 1) {
            for (String name : textureNames) {
                this.textures.put(name, new OBJTextureSheet(model, name));
            }
        } else {
            this.textures.put(null, new OBJTextureSheet(model));
        }
    }

    public boolean hasTexture() {
        return true;
    }

    public void bindTexture() {
        this.bindTexture(null);
    }

    public void bindTexture(String texName) {
        if (this.hasTexture()) {
            int currentTexture = GL11.glGetInteger((int)32873);
            if (this.textures.get(texName) == null) {
                texName = null;
            }
            if (currentTexture != this.textures.get((Object)texName).textureID) {
                this.prevTexture = currentTexture;
                GL11.glBindTexture((int)3553, (int)this.textures.get((Object)texName).textureID);
            }
        }
    }

    public void restoreTexture() {
        if (this.hasTexture() && this.prevTexture != -1) {
            GL11.glBindTexture((int)3553, (int)this.prevTexture);
            this.prevTexture = -1;
        }
    }

    public void draw() {
        this.createVBA().draw();
    }

    public void drawGroups(Iterable<String> groups) {
        this.createVBA().draw(groups);
    }

    public VBA createVBA() {
        if (this.vba != null) {
            return this.vba;
        }
        ArrayList<Integer> tris = new ArrayList<Integer>();
        LinkedHashMap<String, Pair<Integer, Integer>> groupIdx = new LinkedHashMap<String, Pair<Integer, Integer>>();
        for (String group : this.model.groups.keySet()) {
            if (group.matches(".*EXHAUST_\\d.*") || group.matches(".*CHIMNEY_\\d.*") || group.matches(".*PRESSURE_VALVE_\\d.*") || group.matches(".*CHIMINEY_\\d.*")) continue;
            groupIdx.put(group, (Pair<Integer, Integer>)Pair.of((Object)tris.size(), (Object)this.model.groups.get(group).length));
            for (int face : this.model.groups.get(group)) {
                tris.add(face);
            }
        }
        this.vba = new VBA(tris.size(), groupIdx);
        Iterator<String> iterator = tris.iterator();
        while (iterator.hasNext()) {
            int face = (Integer)((Object)iterator.next());
            String mtlName = this.model.faceMTLs[face];
            Material currentMTL = this.model.materials.get(mtlName);
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            float a = 1.0f;
            OBJTextureSheet texture = this.textures.get(null);
            if (currentMTL != null) {
                if (currentMTL.Kd != null) {
                    float mult = 1.0f - this.model.darken * 5.0f;
                    if (texture.isFlatMaterial(mtlName)) {
                        r = 1.0f;
                        g = 1.0f;
                        b = 1.0f;
                    } else {
                        r = currentMTL.Kd.get(0);
                        g = currentMTL.Kd.get(1);
                        b = currentMTL.Kd.get(2);
                    }
                    r = Math.max(0.0f, r * mult);
                    g = Math.max(0.0f, g * mult);
                    b = Math.max(0.0f, b * mult);
                    a = currentMTL.Kd.get(3);
                }
            } else {
                ImmersiveRailroading.warn("Missing group %s", mtlName);
            }
            for (int[] point : this.model.points(face)) {
                Vec3d v = this.model.vertices(point[0]);
                Vec2f vt = point[1] != -1 ? this.model.vertexTextures(point[1]) : null;
                Vec3d vn = point[2] != -1 ? this.model.vertexNormals(point[2]) : null;
                vt = vt != null ? new Vec2f(texture.convertU(mtlName, vt.x - (float)this.model.offsetU[face]), texture.convertV(mtlName, -vt.y - (float)this.model.offsetV[face])) : new Vec2f(texture.convertU(mtlName, 0.0f), texture.convertV(mtlName, 0.0f));
                this.vba.addPoint(v, vn, vt, r, g, b, a);
            }
        }
        this.model.vertexNormals = null;
        this.model.vertexTextures = null;
        this.model.offsetU = null;
        this.model.offsetV = null;
        this.model.faceMTLs = null;
        this.model.vertices = null;
        return this.vba;
    }

    public void freeGL() {
        if (this.hasTexture()) {
            for (OBJTextureSheet texture : this.textures.values()) {
                texture.freeGL();
            }
        }
        if (this.vba != null) {
            this.vba.free();
        }
    }
}

