/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.ItemTextureVariant;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemLayerModel;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class StockItemModel
implements IBakedModel {
    private OBJRender model;
    private double scale;
    private String defID;
    private static Map<String, ImmutableList<BakedQuad>> iconQuads = new HashMap<String, ImmutableList<BakedQuad>>();
    private String texture;

    public StockItemModel() {
    }

    public StockItemModel(ItemStack stack) {
        this.scale = ItemGauge.get(stack).scale();
        this.defID = ItemDefinition.getID(stack);
        this.model = StockRenderCache.getRender(this.defID);
        if (this.model == null) {
            stack.func_190920_e(0);
        }
        this.texture = ItemTextureVariant.get(stack);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (ConfigGraphics.enableFlatIcons && iconQuads.get(this.defID) != null) {
            return iconQuads.get(this.defID).asList();
        }
        if (this.model != null) {
            GLBoolTracker tex = new GLBoolTracker(3553, this.model.hasTexture());
            GLBoolTracker cull = new GLBoolTracker(2884, false);
            GL11.glPushMatrix();
            double scale = 0.2 * Math.sqrt(this.scale);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            this.model.bindTexture(this.texture);
            this.model.draw();
            this.model.restoreTexture();
            GL11.glPopMatrix();
            tex.restore();
            cull.restore();
            this.model = null;
        }
        return new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideListHack();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair defaultVal = ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)cameraTransformType);
        if (ConfigGraphics.enableFlatIcons && this.defID != null) {
            TextureMap map;
            TextureAtlasSprite sprite;
            if (iconQuads.get(this.defID) == null && !(sprite = (map = Minecraft.func_71410_x().func_147117_R()).func_110572_b(new ResourceLocation("immersiverailroading", this.defID).toString())).equals(map.func_174944_f())) {
                iconQuads.put(this.defID, (ImmutableList<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.empty()));
            }
            if (iconQuads != null) {
                return defaultVal;
            }
        }
        switch (cameraTransformType) {
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(60.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(10.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case GROUND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(-0.5, 0.25, 0.5).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case FIXED: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.5, 0.25, 0.5).toMatrix4f());
            }
            case GUI: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.5, 0.0, 0.0).rotate(Math.toRadians(95.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case HEAD: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().scale(2.0, 2.0, 2.0).translate(-0.5, 0.6, 0.5).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case NONE: {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public class ItemOverrideListHack
    extends ItemOverrideList {
        public ItemOverrideListHack() {
            super(new ArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            return new StockItemModel(stack);
        }
    }
}

