/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.multiblock;

import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.multiblock.BoilerRollerMultiblock;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.multiblock.IMultiblockRender;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BoilerRollerRender
implements IMultiblockRender {
    private OBJRender renderer;
    private List<String> segments;
    private List<String> product;
    private List<String> rest;

    public BoilerRollerRender() {
        try {
            this.renderer = new OBJRender(new OBJModel(new ResourceLocation("immersiverailroading:models/multiblocks/boiler_rolling_machine.obj"), 0.1f));
            this.segments = new ArrayList<String>();
            this.product = new ArrayList<String>();
            this.rest = new ArrayList<String>();
            for (String name : this.renderer.model.groups.keySet()) {
                if (name.contains("SEGMENT_")) {
                    this.segments.add(name);
                    continue;
                }
                if (name.contains("FINISHED_PREVIEW")) {
                    this.product.add(name);
                    continue;
                }
                this.rest.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(TileMultiblock te, double x, double y, double z, float partialTicks) {
        GLBoolTracker tex = new GLBoolTracker(3553, this.renderer.hasTexture());
        this.renderer.bindTexture();
        BoilerRollerMultiblock.BoilerRollerInstance tmb = (BoilerRollerMultiblock.BoilerRollerInstance)te.getMultiblock();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        GL11.glRotated((double)(te.getRotation() - 90.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-3.35, (double)0.0, (double)-2.5);
        if (tmb.hasOutput()) {
            this.renderer.drawGroups(this.product);
        } else if (tmb.hasInput()) {
            this.renderer.drawGroups(this.segments);
        }
        this.renderer.drawGroups(this.rest);
        GL11.glPopMatrix();
        this.renderer.restoreTexture();
        tex.restore();
    }
}

