/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.render.DisplayListCache;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import cam72cam.immersiverailroading.util.RailInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.opengl.GL11;

public class RailBaseOverlayRender {
    private static DisplayListCache cache = new DisplayListCache(){

        @Override
        public int lifespan() {
            return 1;
        }

        @Override
        public boolean sliding() {
            return false;
        }
    };

    private static void doDraw(RailInfo info) {
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BlockPos placePos = new BlockPos(info.placementInfo.placementPosition);
        for (TrackBase base : info.getBuilder(placePos).getTracksForRender()) {
            boolean canPlace = base.canPlaceTrack();
            if (canPlace) continue;
            GL11.glPushMatrix();
            BlockPos pos = base.getPos();
            pos = pos.func_177973_b((Vec3i)placePos);
            GL11.glTranslated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 1));
            GL11.glScaled((double)1.0, (double)(base.getBedHeight() + 0.2f), (double)1.0);
            GL11.glBegin((int)7);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)-1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)-1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }

    public static void draw(RailInfo info) {
        String key = info.uniqueID + new BlockPos(info.placementInfo.placementPosition);
        Integer displayList = (Integer)cache.get(key);
        if (displayList == null) {
            displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayList, (int)4864);
            GLBoolTracker tex = new GLBoolTracker(3553, false);
            GLBoolTracker color = new GLBoolTracker(2903, true);
            GL11.glPushMatrix();
            RailBaseOverlayRender.doDraw(info);
            GL11.glPopMatrix();
            tex.restore();
            color.restore();
            GL11.glEndList();
            cache.put(key, displayList);
        } else {
            GL11.glCallList((int)displayList);
        }
    }
}

