/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.render.BakedModelCache;
import cam72cam.immersiverailroading.render.BakedScaledModel;
import cam72cam.immersiverailroading.render.DisplayListCache;
import cam72cam.immersiverailroading.render.rail.RailRenderUtil;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.RailInfo;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RailBaseRender {
    private static BlockRendererDispatcher blockRenderer;
    private static BakedModelCache scaled;
    private static DisplayListCache displayLists;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferBuilder getBaseBuffer(RailInfo info) {
        if (blockRenderer == null) {
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        if (info.settings.railBed.func_77973_b() == Items.field_190931_a) {
            return null;
        }
        IBlockState gravelState = BlockUtil.itemToBlockState(info.settings.railBed);
        BufferBuilder worldRenderer = new BufferBuilder(2048);
        try {
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            worldRenderer.func_181669_b(255, 255, 255, 255);
            for (TrackBase base : info.getBuilder().getTracksForRender()) {
                String key = gravelState.toString() + base.getBedHeight() + ":" + info.settings.gauge.scale();
                IBakedModel model = (IBakedModel)scaled.get(key);
                if (model == null) {
                    IBakedModel gravelModel = blockRenderer.func_175023_a().func_178125_b(gravelState);
                    model = new BakedScaledModel(gravelModel, base.getBedHeight() + 0.1f * (float)info.settings.gauge.scale());
                    scaled.put(key, model);
                }
                blockRenderer.func_175019_b().func_178267_a((IBlockAccess)info.world, model, gravelState, base.getPos(), worldRenderer, false);
            }
        }
        finally {
            worldRenderer.func_178977_d();
        }
        return worldRenderer;
    }

    private static synchronized void drawSync(RailInfo info) {
        try {
            RailRenderUtil.draw(RailBaseRender.getBaseBuffer(info));
        }
        catch (Exception ex) {
            ImmersiveRailroading.catching(ex);
        }
    }

    public static void draw(RailInfo info) {
        Integer displayList = (Integer)displayLists.get(info.uniqueID);
        if (displayList == null) {
            if (!ClientProxy.renderCacheLimiter.canRender()) {
                return;
            }
            displayList = ClientProxy.renderCacheLimiter.newList(() -> RailBaseRender.drawSync(info));
            displayLists.put(info.uniqueID, displayList);
        }
        GL11.glCallList((int)displayList);
    }

    static {
        scaled = new BakedModelCache();
        displayLists = new DisplayListCache();
    }
}

