/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.sound;

import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.proxy.ClientProxy;
import cam72cam.immersiverailroading.sound.ISound;
import io.netty.util.internal.ThreadLocalRandom;
import java.net.URL;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import paulscode.sound.CommandObject;
import paulscode.sound.SoundSystem;

public class ClientSound
implements ISound {
    private static final float dopplerScale = 0.05f;
    private String id;
    private Supplier<SoundSystem> sndSystem;
    private URL resource;
    private boolean repeats;
    private ResourceLocation oggLocation;
    private float attenuationDistance;
    private Vec3d currentPos;
    private Vec3d velocity;
    private float currentPitch = 1.0f;
    private float currentVolume = 1.0f;
    private float baseSoundMultiplier;
    private Gauge gauge;
    private boolean disposable = false;

    public ClientSound(Supplier<SoundSystem> soundSystem, ResourceLocation oggLocation, URL resource, float baseSoundMultiplier, boolean repeats, float attenuationDistance, Gauge gauge) {
        this.sndSystem = soundSystem;
        this.resource = resource;
        this.baseSoundMultiplier = baseSoundMultiplier;
        this.repeats = repeats;
        this.oggLocation = oggLocation;
        this.attenuationDistance = attenuationDistance * (float)gauge.scale() * (float)ConfigSound.soundDistanceScale;
        this.gauge = gauge;
    }

    public void init() {
        this.id = MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString();
        this.sndSystem.get().newSource(false, this.id, this.resource, this.oggLocation.toString(), this.repeats, 0.0f, 0.0f, 0.0f, ISound.AttenuationType.LINEAR.func_148586_a(), this.attenuationDistance);
    }

    @Override
    public void play(Vec3d pos) {
        this.setPosition(pos);
        this.update();
        if (this.repeats || this.currentPos == null || Minecraft.func_71410_x().field_71439_g == null) {
            this.sndSystem.get().play(this.id);
        } else if (Minecraft.func_71410_x().field_71439_g.func_174791_d().func_72438_d(this.currentPos) < (double)this.attenuationDistance * 1.1) {
            this.sndSystem.get().play(this.id);
        }
    }

    @Override
    public void stop() {
        if (this.isPlaying()) {
            this.sndSystem.get().stop(this.id);
        }
    }

    @Override
    public void terminate() {
        if (this.id == null) {
            return;
        }
        this.sndSystem.get().removeSource(this.id);
    }

    @Override
    public void update() {
        if (this.id == null) {
            this.init();
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("irSound");
        SoundSystem snd = this.sndSystem.get();
        float rootedScale = (float)Math.sqrt(Math.sqrt(this.gauge.scale()));
        float vol = this.currentVolume * ClientProxy.getDampeningAmount() * this.baseSoundMultiplier * rootedScale;
        snd.CommandQueue(new CommandObject(14, this.id, vol));
        if (this.currentPos != null) {
            snd.CommandQueue(new CommandObject(13, this.id, (float)this.currentPos.field_72450_a, (float)this.currentPos.field_72448_b, (float)this.currentPos.field_72449_c));
        }
        if (this.currentPos == null || this.velocity == null) {
            snd.CommandQueue(new CommandObject(15, this.id, this.currentPitch / rootedScale));
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Vec3d ppos = player.func_174791_d();
            Vec3d nextPpos = ppos.func_72441_c(player.field_70159_w, player.field_70181_x, player.field_70179_y);
            Vec3d nextPos = this.currentPos.func_178787_e(this.velocity);
            double origDist = ppos.func_178788_d(this.currentPos).func_72433_c();
            double newDist = nextPpos.func_178788_d(nextPos).func_72433_c();
            float appliedPitch = this.currentPitch;
            appliedPitch = origDist > newDist ? (float)((double)appliedPitch * (1.0 + (origDist - newDist) * (double)0.05f)) : (float)((double)appliedPitch * (1.0 - (newDist - origDist) * (double)0.05f));
            this.sndSystem.get().setPitch(this.id, appliedPitch / rootedScale);
            snd.CommandQueue(new CommandObject(15, this.id, appliedPitch / rootedScale));
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        snd.interruptCommandThread();
    }

    @Override
    public void setPosition(Vec3d pos) {
        this.currentPos = pos;
    }

    @Override
    public void setPitch(float f) {
        this.currentPitch = f;
    }

    @Override
    public void setVelocity(Vec3d vel) {
        this.velocity = vel;
    }

    @Override
    public void setVolume(float f) {
        this.currentVolume = f;
    }

    @Override
    public void updateBaseSoundLevel(float baseSoundMultiplier) {
        this.baseSoundMultiplier = baseSoundMultiplier;
    }

    @Override
    public boolean isPlaying() {
        if (this.id == null) {
            return false;
        }
        return this.sndSystem.get().playing(this.id);
    }

    @Override
    public void reload() {
        this.id = null;
    }

    @Override
    public void disposable() {
        this.disposable = true;
    }

    @Override
    public boolean isDisposable() {
        return this.disposable;
    }
}

