/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty.opencomputers;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.thirdparty.CommonAPI;
import cam72cam.immersiverailroading.tile.TileRailBase;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AugmentDriver
implements DriverBlock {
    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        TileRailBase te = TileRailBase.get((IBlockAccess)world, pos);
        if (te == null) {
            return null;
        }
        Augment augment = te.getAugment();
        if (augment == null) {
            return null;
        }
        switch (augment) {
            case DETECTOR: {
                return new DetectorAugment(world, pos);
            }
            case LOCO_CONTROL: {
                return new LocoControlAugment(world, pos);
            }
        }
        return null;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing facing) {
        TileRailBase te = TileRailBase.get((IBlockAccess)world, pos);
        if (te == null) {
            return false;
        }
        Augment augment = te.getAugment();
        if (augment == null) {
            return false;
        }
        switch (augment) {
            case DETECTOR: 
            case LOCO_CONTROL: {
                return true;
            }
        }
        return false;
    }

    public class LocoControlAugment
    extends AugmentManagerBase {
        public LocoControlAugment(World world, BlockPos pos) {
            super(world, pos);
            this.typeFilter = Locomotive.class;
        }

        public String preferredName() {
            return "ir_augment_control";
        }

        @Callback(doc="function(double) -- sets the locomotive throttle")
        public Object[] setThrottle(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setThrottle(arguments.checkDouble(0));
            }
            return null;
        }

        @Callback(doc="function(double) -- sets the locomotive brake")
        public Object[] setBrake(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setAirBrake(arguments.checkDouble(0));
            }
            return null;
        }

        @Callback(doc="function() -- fires the locomotive horn")
        public Object[] horn(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setHorn(arguments.optInteger(0, 40));
            }
            return null;
        }

        @Callback(doc="function() -- sets the locomotive bell")
        public Object[] bell(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setBell(arguments.optInteger(0, 40));
            }
            return null;
        }

        @Callback(doc="function():string -- returns the current augment type")
        public Object[] getAugmentType(Context context, Arguments args) {
            Augment augment = TileRailBase.get((IBlockAccess)this.world, this.pos).getAugment();
            if (augment != null) {
                return new Object[]{augment.toString()};
            }
            return null;
        }

        @Callback(doc="function():array -- returns the position of the augment")
        public Object[] getPos(Context context, Arguments args) {
            return new Object[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()};
        }
    }

    public class DetectorAugment
    extends AugmentManagerBase {
        public DetectorAugment(World world, BlockPos pos) {
            super(world, pos);
        }

        public String preferredName() {
            return "ir_augment_detector";
        }

        @Callback(doc="function():table -- returns an info dump about the current car")
        public Object[] info(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                return new Object[]{api.info()};
            }
            return null;
        }

        @Callback(doc="function():table -- returns an info dump about the current consist")
        public Object[] consist(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                return new Object[]{api.consist(true)};
            }
            return null;
        }

        @Callback(doc="function():table -- gets the stock's tag")
        public Object[] getTag(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                return new Object[]{api.getTag()};
            }
            return null;
        }

        @Callback(doc="function():table -- sets the stock's tag")
        public Object[] setTag(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                api.setTag(arguments.checkString(0));
            }
            return null;
        }

        @Callback(doc="function():string -- returns the current augment type")
        public Object[] getAugmentType(Context context, Arguments args) {
            Augment augment = TileRailBase.get((IBlockAccess)this.world, this.pos).getAugment();
            if (augment != null) {
                return new Object[]{augment.toString()};
            }
            return null;
        }

        @Callback(doc="function():array -- returns the position of the augment")
        public Object[] getPos(Context context, Arguments args) {
            return new Object[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()};
        }
    }

    public abstract class AugmentManagerBase
    extends AbstractManagedEnvironment
    implements NamedBlock {
        protected final World world;
        protected final BlockPos pos;
        private int ticksAlive;
        private UUID wasOverhead;
        protected Class<? extends EntityRollingStock> typeFilter = EntityRollingStock.class;

        public AugmentManagerBase(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.preferredName(), Visibility.Network).create());
        }

        public boolean canUpdate() {
            return true;
        }

        public void update() {
            EntityRollingStock nearby;
            TileRailBase te;
            Node node = this.node();
            if (this.ticksAlive == 0) {
                te = TileRailBase.get((IBlockAccess)this.world, this.pos);
                nearby = te.getStockNearBy(this.typeFilter, null);
                UUID uUID = this.wasOverhead = nearby != null ? nearby.getPersistentID() : null;
            }
            if (node != null && this.ticksAlive % Math.max(Config.ConfigDebug.ocPollDelayTicks, 1) == 0) {
                UUID isOverhead;
                te = TileRailBase.get((IBlockAccess)this.world, this.pos);
                nearby = te.getStockNearBy(this.typeFilter, null);
                UUID uUID = isOverhead = nearby != null ? nearby.getPersistentID() : null;
                if (isOverhead != this.wasOverhead) {
                    Node neighbor = (Node)node.neighbors().iterator().next();
                    neighbor.sendToReachable("computer.signal", new Object[]{"ir_train_overhead", te.getAugment().toString(), isOverhead == null ? null : isOverhead.toString()});
                }
                this.wasOverhead = isOverhead;
            }
            ++this.ticksAlive;
        }

        public int priority() {
            return 3;
        }
    }
}

