/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.CraftingMachineMode;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockRegistry;
import cam72cam.immersiverailroading.net.MultiblockSelectCraftPacket;
import cam72cam.immersiverailroading.tile.SyncdTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileMultiblock
extends SyncdTileEntity
implements ITickable {
    private IBlockState replaced;
    private BlockPos offset;
    private Rotation rotation;
    private String name;
    private CraftingMachineMode craftMode = CraftingMachineMode.STOPPED;
    private long ticks;
    private Multiblock.MultiblockInstance mb;
    private int craftProgress = 0;
    private ItemStack craftItem = ItemStack.field_190927_a;
    private ItemStackHandler container = new ItemStackHandler(0){

        protected void onContentsChanged(int slot) {
            TileMultiblock.this.func_70296_d();
        }

        public int getSlotLimit(int slot) {
            if (TileMultiblock.this.isLoaded()) {
                return Math.min(super.getSlotLimit(slot), TileMultiblock.this.getMultiblock().getSlotLimit(TileMultiblock.this.offset, slot));
            }
            return 0;
        }
    };
    private EnergyStorage energy = new EnergyStorage(1000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int val = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && val != 0 && TileMultiblock.this.isLoaded()) {
                TileMultiblock.this.func_70296_d();
            }
            return val;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int val = super.extractEnergy(maxExtract, simulate);
            if (!simulate && val != 0 && TileMultiblock.this.isLoaded()) {
                TileMultiblock.this.func_70296_d();
            }
            return val;
        }
    };

    public static TileMultiblock get(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileMultiblock ? (TileMultiblock)te : null;
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() && this.name != null;
    }

    public void configure(String name, Rotation rot, BlockPos offset, IBlockState replaced) {
        this.name = name;
        this.rotation = rot;
        this.offset = offset;
        this.replaced = replaced;
        this.container.setSize(this.getMultiblock().getInvSize(offset));
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.name == null) {
            return nbt;
        }
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("rotation", this.rotation.ordinal());
        nbt.func_74782_a("offset", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.offset));
        nbt.func_74782_a("replaced", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.replaced));
        nbt.func_74782_a("inventory", (NBTBase)this.container.serializeNBT());
        nbt.func_74782_a("craftItem", (NBTBase)this.craftItem.serializeNBT());
        nbt.func_74768_a("craftProgress", this.craftProgress);
        nbt.func_74768_a("craftMode", this.craftMode.ordinal());
        nbt.func_74768_a("energy", this.energy.getEnergyStored());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.name = nbt.func_74779_i("name");
        this.rotation = Rotation.values()[nbt.func_74762_e("rotation")];
        this.offset = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("offset"));
        this.replaced = NBTUtil.func_190008_d((NBTTagCompound)nbt.func_74775_l("replaced"));
        this.container.deserializeNBT(nbt.func_74775_l("inventory"));
        this.craftItem = new ItemStack(nbt.func_74775_l("craftItem"));
        this.craftProgress = nbt.func_74762_e("craftProgress");
        this.craftMode = CraftingMachineMode.STOPPED;
        if (nbt.func_74764_b("craftMode")) {
            this.craftMode = CraftingMachineMode.values()[nbt.func_74762_e("craftMode")];
        }
        this.energy.extractEnergy(this.energy.getEnergyStored(), false);
        this.energy.receiveEnergy(nbt.func_74762_e("energy"), false);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.pow(ImmersiveRailroading.proxy.getRenderDistance() * 16, 2.0);
    }

    public void func_73660_a() {
        if (this.offset == null) {
            return;
        }
        ++this.ticks;
        this.getMultiblock().tick(this.offset);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public BlockPos getOrigin() {
        return this.field_174879_c.func_177973_b((Vec3i)this.offset.func_190942_a(this.rotation));
    }

    public Multiblock.MultiblockInstance getMultiblock() {
        if (this.mb == null && this.isLoaded()) {
            this.mb = MultiblockRegistry.get(this.name).instance(this.field_145850_b, this.getOrigin(), this.rotation);
        }
        return this.mb;
    }

    public String getName() {
        return this.name;
    }

    public long getRenderTicks() {
        return this.ticks;
    }

    public ItemStackHandler getContainer() {
        return this.container;
    }

    public void breakBlock() {
        if (this.getMultiblock() != null) {
            this.getMultiblock().onBreak();
        }
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand) {
        return this.getMultiblock().onBlockActivated(player, hand, this.offset);
    }

    public void onBreak() {
        for (int slot = 0; slot < this.container.getSlots(); ++slot) {
            ItemStack item = this.container.extractItem(slot, Integer.MAX_VALUE, false);
            if (item.func_190926_b()) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), item));
        }
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_180501_a(this.field_174879_c, this.replaced, 3);
    }

    public boolean isRender() {
        return this.getMultiblock().isRender(this.offset);
    }

    public double getRotation() {
        return 180.0f - this.rotation.func_185831_a(EnumFacing.EAST).func_185119_l();
    }

    public int getCraftProgress() {
        return this.craftProgress;
    }

    public void setCraftProgress(int progress) {
        if (this.craftProgress != progress) {
            this.craftProgress = progress;
            this.func_70296_d();
        }
    }

    public CraftingMachineMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftingMachineMode mode) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.craftMode != mode) {
                this.craftMode = mode;
                this.func_70296_d();
            }
        } else {
            ImmersiveRailroading.net.sendToServer((IMessage)new MultiblockSelectCraftPacket(this.func_174877_v(), this.craftItem, mode));
        }
    }

    public ItemStack getCraftItem() {
        return this.craftItem;
    }

    public void setCraftItem(ItemStack selected) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.craftItem == null || selected == null || !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)selected, (ItemStack)this.craftItem)) {
                this.craftItem = selected.func_77946_l();
                this.craftProgress = 0;
                this.func_70296_d();
            }
        } else {
            ImmersiveRailroading.net.sendToServer((IMessage)new MultiblockSelectCraftPacket(this.func_174877_v(), selected, this.craftMode));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.isLoaded()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.getMultiblock().getInvSize(this.offset) != 0;
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.getMultiblock().canRecievePower(this.offset);
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.isLoaded()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getMultiblock().getInvSize(this.offset) != 0) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new IItemHandlerModifiable(){

                    public int getSlots() {
                        return TileMultiblock.this.container.getSlots();
                    }

                    public ItemStack getStackInSlot(int slot) {
                        return TileMultiblock.this.container.getStackInSlot(slot);
                    }

                    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                        if (TileMultiblock.this.getMultiblock().canInsertItem(TileMultiblock.this.offset, slot, stack)) {
                            return TileMultiblock.this.container.insertItem(slot, stack, simulate);
                        }
                        return stack;
                    }

                    public ItemStack extractItem(int slot, int amount, boolean simulate) {
                        if (TileMultiblock.this.getMultiblock().isOutputSlot(TileMultiblock.this.offset, slot)) {
                            return TileMultiblock.this.container.extractItem(slot, amount, simulate);
                        }
                        return ItemStack.field_190927_a;
                    }

                    public int getSlotLimit(int slot) {
                        return TileMultiblock.this.container.getSlotLimit(slot);
                    }

                    public void setStackInSlot(int slot, ItemStack stack) {
                        TileMultiblock.this.container.setStackInSlot(slot, stack);
                    }
                });
            }
            if (capability == CapabilityEnergy.ENERGY && this.getMultiblock().canRecievePower(this.offset)) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

