/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRail
extends TileRailBase {
    public RailInfo info;
    private List<ItemStack> drops;

    public static TileRail get(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileRail ? (TileRail)te : null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.info == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        int length = this.info.settings.length;
        if (this.info.settings.type == TrackItems.CUSTOM && !this.info.customInfo.placementPosition.equals((Object)this.info.placementInfo.placementPosition)) {
            length = (int)this.info.customInfo.placementPosition.func_72438_d(this.info.placementInfo.placementPosition);
        }
        return new AxisAlignedBB((double)(-length), (double)(-length), (double)(-length), (double)length, (double)length, (double)length).func_186670_a(this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.pow(256.0, 2.0);
    }

    public void setSwitchState(SwitchState state) {
        if (state != this.info.switchState) {
            this.info = new RailInfo(this.info.world, this.info.settings, this.info.placementInfo, this.info.customInfo, state, this.info.switchForced, this.info.tablePos);
            this.func_70296_d();
        }
    }

    public void nextTablePos(boolean back) {
        double tablePos = (this.info.tablePos + 1.0 / (double)this.info.settings.length * (double)(back ? 1 : -1)) % 8.0;
        this.info = new RailInfo(this.info.world, this.info.settings, this.info.placementInfo, this.info.customInfo, this.info.switchState, this.info.switchForced, tablePos);
        this.func_70296_d();
        List ents = this.field_145850_b.func_72872_a(EntityCoupleableRollingStock.class, new AxisAlignedBB((double)(-this.info.settings.length), 0.0, (double)(-this.info.settings.length), (double)this.info.settings.length, 5.0, (double)this.info.settings.length).func_186670_a(this.func_174877_v()));
        for (EntityCoupleableRollingStock stock : ents) {
            stock.triggerResimulate();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.drops = new ArrayList<ItemStack>();
        if (nbt.func_74764_b("drops")) {
            NBTTagCompound dropNBT = nbt.func_74775_l("drops");
            int count = dropNBT.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                this.drops.add(new ItemStack(dropNBT.func_74775_l("drop_" + i)));
            }
        }
        if (nbt.func_74764_b("info")) {
            this.info = new RailInfo(this.field_145850_b, this.field_174879_c, nbt.func_74775_l("info"));
        } else {
            TrackItems type = TrackItems.valueOf(nbt.func_74779_i("type"));
            int length = nbt.func_74762_e("length");
            int quarters = nbt.func_74762_e("turnQuarters");
            ItemStack railBed = new ItemStack(nbt.func_74775_l("railBed"));
            Gauge gauge = Gauge.from(nbt.func_74769_h("gauge"));
            if (type == TrackItems.SWITCH) {
                quarters = 4;
            }
            NBTTagCompound newPositionFormat = new NBTTagCompound();
            newPositionFormat.func_74780_a("x", nbt.func_74769_h("placementPositionX"));
            newPositionFormat.func_74780_a("y", nbt.func_74769_h("placementPositionY"));
            newPositionFormat.func_74780_a("z", nbt.func_74769_h("placementPositionZ"));
            nbt.func_74782_a("placementPosition", (NBTBase)newPositionFormat);
            PlacementInfo placementInfo = new PlacementInfo(nbt, this.field_174879_c);
            placementInfo = new PlacementInfo(placementInfo.placementPosition, placementInfo.direction, placementInfo.yaw, null);
            SwitchState switchState = SwitchState.values()[nbt.func_74762_e("switchState")];
            SwitchState switchForced = SwitchState.values()[nbt.func_74762_e("switchForced")];
            double tablePos = nbt.func_74769_h("tablePos");
            RailSettings settings = new RailSettings(gauge, "default", type, length, quarters, TrackPositionType.FIXED, TrackDirection.NONE, railBed, ItemStack.field_190927_a, false, false);
            this.info = new RailInfo(this.field_145850_b, settings, placementInfo, null, switchState, switchForced, tablePos);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("info", (NBTBase)this.info.toNBT(this.field_174879_c));
        if (this.drops != null && this.drops.size() != 0) {
            NBTTagCompound dropNBT = new NBTTagCompound();
            dropNBT.func_74768_a("count", this.drops.size());
            for (int i = 0; i < this.drops.size(); ++i) {
                dropNBT.func_74782_a("drop_" + i, (NBTBase)this.drops.get(i).serializeNBT());
            }
            nbt.func_74782_a("drops", (NBTBase)dropNBT);
        }
        return super.func_189515_b(nbt);
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
    }

    public void spawnDrops() {
        if (!this.field_145850_b.field_72995_K && this.drops != null && this.drops.size() != 0) {
            for (ItemStack drop : this.drops) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), drop));
            }
            this.drops = new ArrayList<ItemStack>();
        }
    }

    public double percentFloating() {
        int floating = 0;
        int total = 0;
        if (this.info.world == null) {
            return 0.0;
        }
        for (TrackBase track : this.info.getBuilder(new BlockPos(this.info.placementInfo.placementPosition)).getTracksForRender()) {
            BlockPos tpos = track.getPos();
            ++total;
            if (!this.field_145850_b.func_175667_e(tpos)) {
                return 0.0;
            }
            if (track.isDownSolid()) continue;
            ++floating;
        }
        return (double)floating / (double)total;
    }

    @Override
    public double getTrackGauge() {
        if (this.info == null) {
            return 0.0;
        }
        return this.info.settings.gauge.value();
    }
}

