/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.IRItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreHelper {
    public static final OreAbstract IR_CASTING_CASING = new OreAbstract("irCastingCasing", new ItemStack(Blocks.field_150385_bj));
    public static final OreAbstract IR_LIGHT_ENG = new OreAbstract("irLightEngineering", new ItemStack(Blocks.field_150339_S));
    public static final OreAbstract IR_HEAVY_ENG = new OreAbstract("irHeavyEngineering", new ItemStack(Blocks.field_150339_S));
    public static final OreAbstract IR_SCAFFOLDING = new OreAbstract("irScaffolding", "scaffoldingSteel", new ItemStack(Blocks.field_150411_aY));
    public static final OreAbstract IR_STEEL_BLOCK = new OreAbstract("blockSteel", new ItemStack(Blocks.field_150339_S));
    public static final OreAbstract IR_STEEL_INGOT = new OreAbstract("ingotSteel", new ItemStack(Items.field_151042_j));
    public static final OreAbstract IR_TIE = new OreAbstract("irTie", "plankTreatedWood", new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
    public static final OreAbstract IR_RAIL = new OreAbstract("irRail", new ItemStack((Item)IRItems.ITEM_RAIL));
    public static final OreAbstract IR_RAIL_BED = new OreAbstract("railBed", new ItemStack(Blocks.field_150351_n));

    public static boolean oreDictionaryContainsMatch(boolean strict, NonNullList<ItemStack> ores, ItemStack playerStack) {
        for (ItemStack target : ores) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)playerStack, (boolean)strict)) continue;
            return true;
        }
        return false;
    }

    public static class OreAbstract {
        private ItemStack fallback;
        public final String def;
        public final String name;

        public OreAbstract(String name, ItemStack fallback) {
            this.name = name;
            this.def = null;
            this.fallback = fallback;
        }

        public OreAbstract(String name, String def, ItemStack fallback) {
            this.name = name;
            this.def = def;
            this.fallback = fallback;
        }

        public NonNullList<ItemStack> getOres() {
            NonNullList ores = OreDictionary.getOres((String)this.name);
            if (ores.size() != 0) {
                return ores;
            }
            if (this.def != null && (ores = OreDictionary.getOres((String)this.def)).size() != 0) {
                return ores;
            }
            ores = NonNullList.func_191196_a();
            ores.add((Object)this.fallback);
            return ores;
        }

        public void add(ItemStack stack) {
            OreDictionary.registerOre((String)this.name, (ItemStack)stack);
        }

        public void add(Block block) {
            OreDictionary.registerOre((String)this.name, (Block)block);
        }

        public void add(Item item) {
            OreDictionary.registerOre((String)this.name, (Item)item);
        }

        public boolean matches(ItemStack stack, boolean strict) {
            return OreHelper.oreDictionaryContainsMatch(strict, this.getOres(), stack);
        }

        public ItemStack example() {
            return (ItemStack)this.getOres().get(0);
        }
    }
}

