/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.util.NBTUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class PlacementInfo {
    public final Vec3d placementPosition;
    public final TrackDirection direction;
    public final float yaw;
    public final Vec3d control;

    public PlacementInfo(Vec3d placementPosition, TrackDirection direction, float yaw, Vec3d control) {
        this.placementPosition = placementPosition;
        this.direction = direction;
        this.yaw = yaw;
        this.control = control;
    }

    public PlacementInfo(ItemStack stack, float yawHead, BlockPos pos, float hitX, float hitY, float hitZ) {
        yawHead = (-yawHead % 360.0f + 360.0f) % 360.0f;
        this.yaw = (float)((int)((yawHead + 11.25f) * 4.0f) / 90 * 90) / 4.0f;
        RailSettings settings = ItemTrackBlueprint.settings(stack);
        TrackDirection direction = settings.direction;
        if (direction == TrackDirection.NONE) {
            direction = yawHead % 90.0f < 45.0f ? TrackDirection.RIGHT : TrackDirection.LEFT;
        }
        int quarter = this.rotationQuarter();
        block0 : switch (settings.posType) {
            case FIXED: {
                hitX = 0.5f;
                hitZ = 0.5f;
                break;
            }
            case PIXELS: {
                hitX = (float)((int)(hitX * 16.0f)) / 16.0f;
                hitZ = (float)((int)(hitZ * 16.0f)) / 16.0f;
                break;
            }
            case PIXELS_LOCKED: {
                hitX = (float)((int)(hitX * 16.0f)) / 16.0f;
                hitZ = (float)((int)(hitZ * 16.0f)) / 16.0f;
                if (quarter != 0) break;
                switch (this.facing()) {
                    case EAST: 
                    case WEST: {
                        hitZ = 0.5f;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        hitX = 0.5f;
                        break block0;
                    }
                }
                break;
            }
            case SMOOTH: {
                break;
            }
            case SMOOTH_LOCKED: {
                if (quarter != 0) break;
                switch (this.facing()) {
                    case EAST: 
                    case WEST: {
                        hitZ = 0.5f;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        hitX = 0.5f;
                        break block0;
                    }
                }
            }
        }
        this.placementPosition = new Vec3d((Vec3i)pos).func_72441_c((double)hitX, 0.0, (double)hitZ);
        this.direction = direction;
        this.control = null;
    }

    public PlacementInfo(NBTTagCompound nbt) {
        this(nbt, BlockPos.field_177992_a);
    }

    public PlacementInfo(NBTTagCompound nbt, BlockPos offset) {
        this.placementPosition = NBTUtil.nbtToVec3d(nbt.func_74775_l("placementPosition")).func_72441_c((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
        this.direction = TrackDirection.values()[nbt.func_74762_e("direction")];
        if (nbt.func_74764_b("yaw")) {
            this.yaw = nbt.func_74760_g("yaw");
        } else {
            int rotationQuarter = nbt.func_74762_e("rotationQuarter");
            EnumFacing facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("facing"));
            float facingAngle = 180.0f - facing.func_185119_l();
            float rotAngle = (float)rotationQuarter / 4.0f * 90.0f;
            if (this.direction != TrackDirection.RIGHT) {
                rotAngle = -rotAngle;
            }
            this.yaw = facingAngle + rotAngle;
        }
        this.control = nbt.func_74764_b("magnitude") ? this.placementPosition.func_178787_e(VecUtil.fromYaw(nbt.func_74769_h("magnitude"), this.yaw)) : (nbt.func_74764_b("control") ? NBTUtil.nbtToVec3d(nbt.func_74775_l("control")).func_72441_c((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p()) : null);
    }

    public NBTTagCompound toNBT() {
        return this.toNBT(BlockPos.field_177992_a);
    }

    public NBTTagCompound toNBT(BlockPos offset) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("placementPosition", (NBTBase)NBTUtil.vec3dToNBT(this.placementPosition.func_178786_a((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p())));
        nbt.func_74776_a("yaw", this.yaw);
        nbt.func_74768_a("direction", this.direction.ordinal());
        if (this.control != null) {
            nbt.func_74782_a("control", (NBTBase)NBTUtil.vec3dToNBT(this.control.func_178786_a((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p())));
        }
        return nbt;
    }

    public EnumFacing facing() {
        return EnumFacing.func_176733_a((double)(180.0f - this.yaw));
    }

    public int rotationQuarter() {
        return (int)(this.yaw % 90.0f * 4.0f / 90.0f);
    }

    public float partialAngle() {
        return this.yaw % 90.0f;
    }
}

