/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.core.config.Config;
import forestry.core.render.ForestryResource;
import forestry.core.utils.SoundUtil;
import forestry.mail.POBoxInfo;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiMailboxInfo
extends Gui {
    public static final GuiMailboxInfo instance = new GuiMailboxInfo();
    private static final int WIDTH = 98;
    private static final int HEIGHT = 17;
    private final FontRenderer fontRenderer;
    @Nullable
    private POBoxInfo poInfo;
    private final ResourceLocation textureAlert = new ForestryResource("textures/gui/mailalert.png");

    private GuiMailboxInfo() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public void render() {
        if (this.poInfo == null || !Config.mailAlertEnabled || !this.poInfo.hasMail()) {
            return;
        }
        int x = 0;
        int y = 0;
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(minecraft);
        if (Config.mailAlertXPosition == XPosition.RIGHT) {
            x = scaledresolution.func_78326_a() - 98;
        }
        if (Config.mailAlertYPosition == YPosition.BOTTOM) {
            y = scaledresolution.func_78328_b() - 17;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(this.textureAlert);
        this.func_73729_b(x, y, 0, 0, 98, 17);
        this.fontRenderer.func_78276_b(Integer.toString(this.poInfo.playerLetters), x + 27 + this.getCenteredOffset(Integer.toString(this.poInfo.playerLetters), 22), y + 5, 0xFFFFFF);
        this.fontRenderer.func_78276_b(Integer.toString(this.poInfo.tradeLetters), x + 75 + this.getCenteredOffset(Integer.toString(this.poInfo.tradeLetters), 22), y + 5, 0xFFFFFF);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRenderer.func_78256_a(string)) / 2;
    }

    public boolean hasPOBoxInfo() {
        return this.poInfo != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPOBoxInfo(EntityPlayer player, POBoxInfo info) {
        boolean playJingle = false;
        if (info.hasMail()) {
            if (this.poInfo == null) {
                playJingle = true;
            } else if (this.poInfo.playerLetters != info.playerLetters || this.poInfo.tradeLetters != info.tradeLetters) {
                playJingle = true;
            }
        }
        if (playJingle) {
            SoundUtil.playSoundEvent(SoundEvents.field_187802_ec);
        }
        this.poInfo = info;
    }

    public static enum YPosition {
        TOP,
        BOTTOM;

    }

    public static enum XPosition {
        LEFT,
        RIGHT;

    }
}

