/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import javax.annotation.Nonnull;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import sonar.core.integration.SonarLoader;
import sonar.core.network.sync.SyncEnergyStorage;

public class SyncItemEnergyStorage
extends SyncEnergyStorage
implements ICapabilityProvider {
    public ItemStack stack;

    public SyncItemEnergyStorage(ItemStack stack, int capacity) {
        super(capacity);
        this.stack = stack;
    }

    public SyncItemEnergyStorage(ItemStack stack, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.stack = stack;
    }

    public SyncItemEnergyStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.stack = stack;
    }

    public SyncItemEnergyStorage setItemStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.stack = stack;
            if (stack.func_77942_o()) {
                this.readFromNBT(stack.func_77978_p());
            }
        }
        return this;
    }

    @Override
    public void markChanged() {
        super.markChanged();
        if (!this.stack.func_190926_b()) {
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
            this.stack.func_77982_d(this.writeToNBT(this.stack.func_77978_p()));
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (SonarLoader.teslaLoaded) {
            return capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER;
        }
        return false;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.getInternalWrapper();
        }
        if (SonarLoader.teslaLoaded && (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this.getInternalWrapper();
        }
        return null;
    }
}

