/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.tile;

import com.builtbroken.jlib.data.network.IByteBufWriter;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import icbm.classic.ICBMClassic;
import icbm.classic.api.IWorldPosition;
import icbm.classic.config.ConfigIC2;
import icbm.classic.lib.IGuiTile;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.mods.ic2.IC2Proxy;
import icbm.classic.prefab.gui.IPlayerUsing;
import icbm.classic.prefab.tile.BlockICBM;
import icbm.classic.prefab.tile.EnumTier;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.tile.IEnergyStorage", modid="ic2")})
public class TileMachine
extends TileEntity
implements IPacketIDReceiver,
IWorldPosition,
IPlayerUsing,
ITickable,
IByteBufWriter,
IGuiTile,
IEnergySink {
    public static final int DESC_PACKET_ID = -1;
    protected boolean updateClient = false;
    protected int ticks = -1;
    public EnumTier _tier = EnumTier.ONE;
    List<EntityPlayer> playersWithGUI = new ArrayList<EntityPlayer>();

    public void func_73660_a() {
        if (this.ticks == -1) {
            this.onFirstTick();
        }
        ++this.ticks;
        if (this.ticks >= 0x7FFFFFFE) {
            this.ticks = 0;
        }
        if (this.isServer()) {
            PacketTile packet;
            if (this.updateClient) {
                this.updateClient = false;
                this.sendDescPacket();
            }
            if (this.ticks % 3 == 0 && this.getPlayersUsing().size() > 0 && (packet = this.getGUIPacket()) != null) {
                this.sendPacketToGuiUsers(packet);
            }
        }
    }

    protected void onFirstTick() {
        if (this.getBlockState().func_177228_b().containsKey((Object)BlockICBM.TIER_PROP)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)BlockICBM.TIER_PROP, (Comparable)((Object)this.getTier())));
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void sendDescPacket() {
        PacketTile packetTile = this.getDescPacket();
        if (packetTile != null) {
            ICBMClassic.packetHandler.sendToAllAround((IPacket)packetTile, this);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this._tier = EnumTier.get(compound.func_74762_e("tier"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tier", this._tier.ordinal());
        return super.func_189515_b(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public PacketTile getDescPacket() {
        PacketTile packetTile = new PacketTile("desc", -1, this);
        packetTile.addData(new Object[]{this});
        return packetTile;
    }

    public void sendPacketToGuiUsers(IPacket packet) {
        if (packet != null) {
            Iterator it = this.getPlayersUsing().iterator();
            while (it.hasNext()) {
                EntityPlayer player = (EntityPlayer)it.next();
                if (player instanceof EntityPlayerMP && this.isValidGuiUser(player)) {
                    ICBMClassic.packetHandler.sendToPlayer(packet, (EntityPlayerMP)player);
                    continue;
                }
                it.remove();
            }
        }
    }

    protected boolean isValidGuiUser(EntityPlayer player) {
        return player.field_71070_bA != null;
    }

    public final List<EntityPlayer> getPlayersUsing() {
        return this.playersWithGUI;
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket type) {
        if (this.isClient() && id == -1) {
            this.readDescPacket(buf);
            return true;
        }
        return false;
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf var1) {
        this.writeDescPacket(var1);
        return var1;
    }

    public void writeDescPacket(ByteBuf buf) {
        buf.writeInt(this._tier.ordinal());
    }

    public void readDescPacket(ByteBuf buf) {
        this._tier = EnumTier.get(buf.readInt());
    }

    protected PacketTile getGUIPacket() {
        return this.getDescPacket();
    }

    @Override
    public boolean isServer() {
        return this.field_145850_b != null && !this.field_145850_b.field_72995_K;
    }

    @Override
    public boolean isClient() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K;
    }

    public EnumFacing getRotation() {
        IBlockState state = this.getBlockState();
        if (state.func_177228_b().containsKey((Object)BlockICBM.ROTATION_PROP)) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockICBM.ROTATION_PROP);
        }
        return EnumFacing.NORTH;
    }

    public void setRotation(EnumFacing facingDirection) {
        IBlockState state;
        if (facingDirection != this.getRotation() && (state = this.getBlockState()).func_177228_b().containsKey((Object)BlockICBM.ROTATION_PROP)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)BlockICBM.ROTATION_PROP, (Comparable)facingDirection));
        }
    }

    public EnumTier getTier() {
        return this._tier;
    }

    public void setTier(EnumTier tier) {
        if (tier != this.getTier()) {
            IBlockState state;
            this._tier = tier;
            if (this.isServer() && (state = this.getBlockState()).func_177228_b().containsKey((Object)BlockICBM.TIER_PROP)) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockICBM.TIER_PROP, (Comparable)((Object)tier)));
            }
        }
    }

    public IBlockState getBlockState() {
        return this.field_145850_b.func_180495_p(this.func_174877_v());
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public double z() {
        return this.func_174877_v().func_177952_p();
    }

    @Override
    public double x() {
        return this.func_174877_v().func_177958_n();
    }

    @Override
    public double y() {
        return this.func_174877_v().func_177956_o();
    }

    @Override
    public boolean openGui(EntityPlayer player, int requestedID) {
        player.openGui((Object)ICBMClassic.INSTANCE, requestedID, this.field_145850_b, this.xi(), this.yi(), this.zi());
        return true;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        IEnergyStorage energyStorage;
        if (!ConfigIC2.DISABLED && this.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            int need = energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored();
            return (double)need / ConfigIC2.FROM_IC2;
        }
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return !ConfigIC2.DISABLED ? 4 : 0;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        IEnergyStorage energyStorage;
        if (!ConfigIC2.DISABLED && this.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            int energy = (int)Math.floor(amount * ConfigIC2.FROM_IC2);
            int received = energyStorage.receiveEnergy(energy, false);
            return amount - (double)received / ConfigIC2.FROM_IC2;
        }
        return amount;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return !ConfigIC2.DISABLED && this.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        IC2Proxy.INSTANCE.onTileInvalidate(this);
    }

    public void func_145829_t() {
        super.func_145829_t();
        IC2Proxy.INSTANCE.onTileValidate(this);
    }
}

