/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.method.wrapper;

import dan200.computercraft.api.lua.LuaException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ArgumentType<T> {
    public String name();

    @Nonnull
    public T get(@Nonnull Object[] var1, int var2) throws LuaException;

    @Nullable
    default public T opt(@Nonnull Object[] args, int index) throws LuaException {
        return index < args.length && args[index] != null ? (T)this.get(args, index) : null;
    }

    default public <U> ArgumentType<U> map(final ArgumentFunction<T, U> func) {
        Objects.requireNonNull(func);
        final ArgumentType original = this;
        return new ArgumentType<U>(){

            @Override
            public String name() {
                return original.name();
            }

            @Override
            @Nonnull
            public U get(@Nonnull Object[] args, int index) throws LuaException {
                return func.apply(original.get(args, index));
            }

            @Override
            @Nullable
            public U opt(@Nonnull Object[] args, int index) throws LuaException {
                Object result = original.opt(args, index);
                return result == null ? null : (Object)func.apply(result);
            }

            @Override
            public <V> ArgumentType<V> map(ArgumentFunction<U, V> func2) {
                Objects.requireNonNull(func2);
                return original.map((T x) -> func2.apply(func.apply(x)));
            }
        };
    }

    @FunctionalInterface
    public static interface ArgumentFunction<T, U> {
        @Nonnull
        public U apply(@Nonnull T var1) throws LuaException;
    }
}

