/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import dan200.computercraft.api.lua.LuaException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.PlethoraCore;

public final class DefaultCostHandler
implements ICostHandler {
    public static final DefaultCostHandler EMPTY = new DefaultCostHandler(0.0, 0.0, 0.0, false, false);
    private static final Map<Object, DefaultCostHandler> handlers = new MapMaker().weakKeys().makeMap();
    private double value;
    private final double regenRate;
    private final double limit;
    private final boolean allowNegative;
    private final boolean allowAwait;

    public DefaultCostHandler(double initial, double regenRate, double limit, boolean allowNegative, boolean allowAwait) {
        Preconditions.checkArgument((initial >= 0.0 ? 1 : 0) != 0, (Object)"initial must be >= 0");
        Preconditions.checkArgument((regenRate >= 0.0 ? 1 : 0) != 0, (Object)"regenRate must be > 0");
        Preconditions.checkArgument((limit >= 0.0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        this.regenRate = regenRate;
        this.limit = limit;
        this.allowNegative = allowNegative;
        this.allowAwait = allowAwait;
    }

    public DefaultCostHandler() {
        this(ConfigCore.CostSystem.initial, ConfigCore.CostSystem.regen, ConfigCore.CostSystem.limit, ConfigCore.CostSystem.allowNegative, ConfigCore.CostSystem.awaitRegen);
    }

    @Override
    public synchronized double get() {
        return this.value;
    }

    @Override
    public synchronized boolean consume(double amount) {
        Preconditions.checkArgument((amount >= 0.0 ? 1 : 0) != 0, (Object)"amount must be >= 0");
        if (this.allowNegative ? this.value <= 0.0 : amount > this.value) {
            return false;
        }
        this.value -= amount;
        return true;
    }

    @Override
    public MethodResult await(double amount, MethodResult next) throws LuaException {
        if (this.consume(amount)) {
            return next;
        }
        if (!this.allowNegative && amount > this.limit || !this.allowAwait) {
            throw new LuaException("Insufficient energy (requires " + amount + ", has " + this.value + ".");
        }
        return MethodResult.awaiting(() -> this.consume(amount), () -> next);
    }

    @Override
    public MethodResult await(double amount, Callable<MethodResult> next) throws LuaException {
        if (this.consume(amount)) {
            try {
                return next.call();
            }
            catch (LuaException e) {
                throw e;
            }
            catch (Exception | LinkageError | VirtualMachineError e) {
                PlethoraCore.LOG.error("Unexpected error", e);
                throw new LuaException("Java Exception Thrown: " + e);
            }
        }
        if (!this.allowNegative && amount > this.limit || !this.allowAwait) {
            throw new LuaException("Insufficient energy (requires " + amount + ", has " + this.value + ".");
        }
        return MethodResult.awaiting(() -> this.consume(amount), next);
    }

    private synchronized void regen() {
        if (this.value < this.limit) {
            this.value = Math.min(this.limit, this.value + this.regenRate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICostHandler get(Object owner) {
        Map<Object, DefaultCostHandler> map = handlers;
        synchronized (map) {
            DefaultCostHandler handler = handlers.get(owner);
            if (handler == null) {
                handler = new DefaultCostHandler();
                handlers.put(owner, handler);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        Map<Object, DefaultCostHandler> map = handlers;
        synchronized (map) {
            for (DefaultCostHandler handler : handlers.values()) {
                handler.regen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Map<Object, DefaultCostHandler> map = handlers;
        synchronized (map) {
            handlers.clear();
        }
    }
}

