/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;
import org.squiddev.plethora.utils.PlayerHelpers;
import org.squiddev.plethora.utils.WorldPosition;

public final class EntityLaser
extends Entity
implements IProjectile,
IPlayerOwnable {
    private static final Random random = new Random();
    @Nullable
    private Entity shooter;
    @Nullable
    private EntityPlayer shooterPlayer;
    @Nullable
    private GameProfile shooterOwner;
    @Nullable
    private WorldPosition shooterPos;
    private float potency = 0.0f;

    public EntityLaser(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityLaser(World world, @Nonnull Entity shooter, float inaccuracy, float potency) {
        this(world);
        this.potency = potency;
        this.setShooter(shooter, PlayerHelpers.getProfile(shooter));
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, inaccuracy);
    }

    public EntityLaser(World world, Vec3d shooter) {
        this(world);
        this.shooterPos = new WorldPosition(world, shooter);
    }

    public void setShooter(@Nullable Entity shooter, @Nullable GameProfile profile) {
        this.shooter = shooter;
        this.shooterOwner = profile;
    }

    protected void func_70088_a() {
    }

    public void setPotency(float potency) {
        this.potency = potency;
    }

    public void func_70186_c(double vx, double vy, double vz, float velocity, float inaccuracy) {
        float magnitude = MathHelper.func_76133_a((double)(vx * vx + vy * vy + vz * vz));
        vx /= (double)magnitude;
        vy /= (double)magnitude;
        vz /= (double)magnitude;
        vx += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        vy += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        vz += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = vx *= (double)velocity;
        this.field_70181_x = vy *= (double)velocity;
        this.field_70179_y = vz *= (double)velocity;
        float newMagnitude = MathHelper.func_76133_a((double)(vx * vx + vz * vz));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)vx, (double)vz) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)vy, (double)newMagnitude) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float magnitude = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)magnitude) * 180.0 / Math.PI);
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound tag) {
        PlayerHelpers.writeProfile(tag, this.shooterOwner);
        if (this.shooterPos != null) {
            tag.func_74782_a("shooterPos", (NBTBase)this.shooterPos.serializeNBT());
        }
        tag.func_74776_a("potency", this.potency);
    }

    public void func_70037_a(@Nonnull NBTTagCompound tag) {
        this.shooter = null;
        this.shooterPlayer = null;
        this.shooterOwner = PlayerHelpers.readProfile(tag);
        if (tag.func_150297_b("shooterPos", 10)) {
            this.shooterPos = WorldPosition.deserializeNBT(tag.func_74775_l("shooterPos"));
        }
        this.potency = tag.func_74760_g("potency");
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        World worldObj = this.func_130014_f_();
        if (!worldObj.field_72995_K) {
            Vec3d nextPosition;
            Vec3d position;
            int ticks = 5;
            for (double remaining = 1.0; remaining >= 0.01 && this.potency > 0.0f && --ticks >= 0; remaining -= position.func_72438_d(nextPosition) / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) {
                position = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                nextPosition = new Vec3d(this.field_70165_t + this.field_70159_w * remaining, this.field_70163_u + this.field_70181_x * remaining, this.field_70161_v + this.field_70179_y * remaining);
                RayTraceResult collision = worldObj.func_72933_a(position, nextPosition);
                if (collision != null) {
                    nextPosition = collision.field_72307_f;
                }
                List collisions = worldObj.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w * remaining, this.field_70181_x * remaining, this.field_70179_y * remaining).func_72314_b(1.0, 1.0, 1.0));
                Entity shooter = this.getShooter();
                double closestDistance = nextPosition.func_72436_e(position);
                EntityLivingBase closestEntity = null;
                for (Entity other : collisions) {
                    double distanceSq;
                    if (!other.func_70067_L() || other == shooter && this.field_70173_aa < 5 || !(other instanceof EntityLivingBase) || other instanceof EntityPlayer && shooter instanceof EntityPlayer && !((EntityPlayer)shooter).func_96122_a((EntityPlayer)other)) continue;
                    float size = 0.3f;
                    AxisAlignedBB singleCollision = other.func_174813_aQ().func_72314_b((double)size, (double)size, (double)size);
                    RayTraceResult hit = singleCollision.func_72327_a(position, nextPosition);
                    if (hit == null || !((distanceSq = position.func_72436_e(hit.field_72307_f)) < closestDistance)) continue;
                    closestEntity = (EntityLivingBase)other;
                    closestDistance = distanceSq;
                    nextPosition = hit.field_72307_f;
                }
                if (closestEntity != null) {
                    collision = new RayTraceResult(closestEntity);
                }
                this.func_70107_b(nextPosition.field_72450_a, nextPosition.field_72448_b, nextPosition.field_72449_c);
                this.syncPositions(false);
                if (collision == null) continue;
                if (collision.field_72313_a == RayTraceResult.Type.BLOCK && worldObj.func_180495_p(collision.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                    this.func_181015_d(collision.func_178782_a());
                    continue;
                }
                this.onImpact(collision);
            }
        } else {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!worldObj.field_72995_K && (this.potency <= 0.0f || this.field_70173_aa > ConfigGameplay.Laser.lifetime)) {
            this.func_70106_y();
        }
    }

    private void onImpact(RayTraceResult collision) {
        World world = this.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        switch (collision.field_72313_a) {
            case BLOCK: {
                BlockPos position = collision.func_178782_a();
                IBlockState blockState = world.func_180495_p(position);
                Block block = blockState.func_177230_c();
                if (block.isAir(blockState, (IBlockAccess)world, position) || blockState.func_185904_a().func_76224_d()) break;
                float hardness = blockState.func_185887_b(world, position);
                EntityPlayer player = this.getShooterPlayer();
                if (player == null) {
                    return;
                }
                this.syncPositions(true);
                if (!world.func_175660_a(player, position)) {
                    this.potency = -1.0f;
                    return;
                }
                if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, position, blockState, player))) {
                    this.potency = -1.0f;
                    return;
                }
                if (block == Blocks.field_150335_W) {
                    this.potency -= hardness;
                    Entity shooter = this.getShooter();
                    ((BlockTNT)block).func_180692_a(world, position, blockState.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.TRUE), (EntityLivingBase)(shooter instanceof EntityLivingBase ? (EntityLivingBase)shooter : this.getShooterPlayer()));
                    world.func_175698_g(position);
                    break;
                }
                if (block == Blocks.field_150343_Z) {
                    this.potency -= hardness;
                    BlockPos offset = position.func_177972_a(collision.field_178784_b);
                    IBlockState offsetState = world.func_180495_p(offset);
                    if (!offsetState.func_177230_c().isAir(offsetState, (IBlockAccess)world, offset)) {
                        return;
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.PlaceEvent(new BlockSnapshot(world, position, offsetState), blockState, player, EnumHand.MAIN_HAND))) {
                        return;
                    }
                    world.func_184133_a(null, offset, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 0.8f);
                    world.func_175656_a(offset, Blocks.field_150480_ab.func_176223_P());
                    break;
                }
                if (hardness > -1.0f && hardness <= this.potency) {
                    this.potency -= hardness;
                    TileEntity te = world.func_175625_s(position);
                    if (!block.removedByPlayer(blockState, world, position, player, true)) break;
                    block.func_176206_d(world, position, blockState);
                    block.func_180657_a(world, player, position, blockState, te, ItemStack.field_190927_a);
                    break;
                }
                this.potency = -1.0f;
                break;
            }
            case ENTITY: {
                Entity entity = collision.field_72308_g;
                if (!(entity instanceof EntityLivingBase)) break;
                this.syncPositions(true);
                Entity shooter = this.getShooter();
                EntityDamageSource source = shooter == null ? new EntityDamageSource("laser", (Entity)this) : new EntityDamageSourceIndirect("laser", (Entity)this, shooter);
                source.func_76349_b();
                entity.func_70015_d(5);
                entity.func_70097_a((DamageSource)source, (float)((double)this.potency * ConfigGameplay.Laser.damage));
                this.potency = -1.0f;
                break;
            }
        }
    }

    @Nullable
    private Entity getShooter() {
        if (this.shooter != null) {
            return this.shooter;
        }
        World worldObj = this.func_130014_f_();
        if (!(worldObj instanceof WorldServer)) {
            return null;
        }
        WorldServer world = (WorldServer)worldObj;
        this.shooterPlayer = new PlethoraFakePlayer(world, null, this.shooterOwner);
        this.shooter = this.shooterPlayer;
        return this.shooterPlayer;
    }

    @Nullable
    private EntityPlayer getShooterPlayer() {
        if (this.shooterPlayer != null) {
            return this.shooterPlayer;
        }
        Entity shooter = this.getShooter();
        if (shooter instanceof EntityPlayer) {
            this.shooterPlayer = (EntityPlayer)shooter;
            return this.shooterPlayer;
        }
        World worldObj = this.func_130014_f_();
        if (!(worldObj instanceof WorldServer)) {
            return null;
        }
        WorldServer world = (WorldServer)worldObj;
        this.shooterPlayer = new PlethoraFakePlayer(world, shooter, this.shooterOwner);
        return this.shooterPlayer;
    }

    private void syncPositions(boolean force) {
        EntityPlayer fakePlayer = this.shooterPlayer;
        Entity shooter = this.shooter;
        if (!(fakePlayer instanceof PlethoraFakePlayer)) {
            return;
        }
        if (shooter != null && shooter != fakePlayer) {
            EntityLaser.syncFromEntity(fakePlayer, shooter);
        } else if (this.shooterPos != null) {
            World current = fakePlayer.func_130014_f_();
            if (current == null || current.field_73011_w.getDimension() != this.shooterPos.getDimension()) {
                World replace;
                World world = replace = force ? this.shooterPos.getWorld(this.func_130014_f_().func_73046_m()) : this.shooterPos.getWorld();
                if (replace == null) {
                    EntityLaser.syncFromEntity(fakePlayer, this);
                } else {
                    EntityLaser.syncFromPos(fakePlayer, replace, this.shooterPos.getPos(), this.field_70177_z, this.field_70125_A);
                }
            } else {
                EntityLaser.syncFromPos(fakePlayer, current, this.shooterPos.getPos(), this.field_70177_z, this.field_70125_A);
            }
        } else {
            EntityLaser.syncFromEntity(fakePlayer, this);
        }
    }

    private static void syncFromEntity(EntityPlayer player, Entity from) {
        player.func_70029_a(from.func_130014_f_());
        player.func_70080_a(from.field_70165_t, from.field_70163_u, from.field_70161_v, from.field_70177_z, from.field_70125_A);
    }

    private static void syncFromPos(EntityPlayer player, @Nonnull World world, Vec3d pos, float yaw, float pitch) {
        player.func_70029_a(world);
        player.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, yaw, pitch);
    }

    @Override
    @Nullable
    public GameProfile getOwningProfile() {
        return this.shooterOwner;
    }
}

