/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.refinedstorage;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import dan200.computercraft.api.lua.LuaException;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.vanilla.NullableItemStack;

public final class MethodCraftItem {
    private MethodCraftItem() {
    }

    @PlethoraMethod(modId="refinedstorage", doc="function(count:int):boolean, table -- Craft this item, returning if the item could be crafted and a reference to the crafting task.")
    public static MethodResult craft(IContext<NullableItemStack> baked, @FromContext INetworkNode node, int quantity) throws LuaException {
        ItemStack stack = ((NullableItemStack)baked.getTarget()).getFilledStack();
        INetwork network = node.getNetwork();
        if (network == null) {
            throw new LuaException("Cannot find network");
        }
        ICraftingManager manager = network.getCraftingManager();
        ICraftingTask task = manager.create(stack, quantity);
        if (task == null) {
            throw new LuaException("No matching patterns");
        }
        ICraftingTaskError error = task.calculate();
        if (error != null) {
            String errorMessage;
            switch (error.getType()) {
                case RECURSIVE: {
                    errorMessage = "Encountered a recursive pattern";
                    break;
                }
                case TOO_COMPLEX: {
                    errorMessage = "Recipe is too complex";
                    break;
                }
                default: {
                    errorMessage = null;
                }
            }
            return MethodResult.result(false, errorMessage);
        }
        if (task.hasMissing()) {
            return MethodResult.result(false, "Missing requirements");
        }
        manager.add(task);
        return MethodResult.result(true, baked.makeChildId(task).getObject());
    }
}

