/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.tconstruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.ItemStackContextMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;

@Injects(value="tconstruct")
public final class MetaToolCore
extends ItemStackContextMetaProvider<ToolCore> {
    public MetaToolCore() {
        super("tool", ToolCore.class);
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, ToolCore tool) {
        ItemStack stack = context.getTarget();
        HashMap<String, Serializable> out = new HashMap<String, Serializable>();
        if (tool.hasCategory(Category.HARVEST)) {
            out.put("miningSpeed", Float.valueOf(ToolHelper.getActualMiningSpeed((ItemStack)stack)));
        }
        out.put("attack", Float.valueOf(ToolHelper.getActualAttack((ItemStack)stack)));
        out.put("freeModifiers", Integer.valueOf(ToolHelper.getFreeModifiers((ItemStack)stack)));
        out.put("maxDurability", Integer.valueOf(ToolHelper.getDurabilityStat((ItemStack)stack)));
        out.put("durability", Integer.valueOf(ToolHelper.getCurrentDurability((ItemStack)stack)));
        HashMap modifiers = new HashMap();
        int modIndex = 0;
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)stack);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)tag);
            IModifier modifier = TinkerRegistry.getModifier((String)data.identifier);
            if (modifier == null || modifier.isHidden()) continue;
            HashMap<String, String> modifierData = new HashMap<String, String>();
            modifierData.put("id", modifier.getIdentifier());
            modifierData.put("name", modifier.getLocalizedName());
            modifiers.put(++modIndex, modifierData);
        }
        out.put("modifiers", modifiers);
        HashMap parts = new HashMap();
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)stack));
        List component = tool.getRequiredComponents();
        if (materials.size() >= component.size()) {
            int partIdx = 0;
            for (int i = 0; i < component.size(); ++i) {
                IToolPart part;
                ItemStack partStack;
                PartMaterialType pmt = (PartMaterialType)component.get(i);
                Material material = (Material)materials.get(i);
                Iterator partIter = pmt.getPossibleParts().iterator();
                if (!partIter.hasNext() || (partStack = (part = (IToolPart)partIter.next()).getItemstackWithMaterial(material)) == null) continue;
                parts.put(++partIdx, context.makePartialChild(pmt).makePartialChild(partStack).getMeta());
            }
        }
        out.put("parts", parts);
        return out;
    }

    @Override
    @Nullable
    public ItemStack getExample() {
        ToolCore tool = TinkerHarvestTools.pickaxe;
        int required = tool.getRequiredComponents().size();
        ArrayList<Material> mats = new ArrayList<Material>(required);
        Collection materials = TinkerRegistry.getAllMaterials();
        for (Material material : materials) {
            mats.clear();
            for (int i = 0; i < required; ++i) {
                mats.add(material);
            }
            ItemStack stack = tool.buildItem(mats);
            if (!tool.hasValidMaterials(stack)) continue;
            return stack;
        }
        return null;
    }
}

