/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.tesla;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.converter.Converters;
import org.squiddev.plethora.api.converter.DynamicConverter;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.SimpleMetaProvider;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;

@Injects(value="tesla")
public final class IntegrationTesla {
    public static final DynamicConverter<ICapabilityProvider, ITeslaHolder> TESLA_HOLDER_CAP = Converters.ofCapability(() -> TeslaCapabilities.CAPABILITY_HOLDER);
    public static final SimpleMetaProvider<ITeslaHolder> META_TESLA_HOLDER = new BasicMetaProvider<ITeslaHolder>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ITeslaHolder handler) {
            HashMap<String, Long> out = new HashMap<String, Long>();
            out.put("stored", handler.getStoredPower());
            out.put("capacity", handler.getCapacity());
            return Collections.singletonMap("tesla", out);
        }

        @Override
        @Nonnull
        public ITeslaHolder getExample() {
            return new BaseTeslaContainer(100L, 50000L, 0L, 0L);
        }
    };

    private IntegrationTesla() {
    }

    @PlethoraMethod(modId="tesla", doc="-- The amount of Tesla currently stored")
    public static long getTeslaStored(@FromTarget ITeslaHolder holder) {
        return holder.getStoredPower();
    }

    @PlethoraMethod(modId="tesla", doc="-- The maximum amount of Tesla that can be stored")
    public static long getTeslaCapacity(@FromTarget ITeslaHolder holder) {
        return holder.getCapacity();
    }
}

