/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.item;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.item.ItemStackUnknown;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class IngredientOr
implements IIngredient {
    private final IIngredient[] elements;
    private final String mark;
    private final IItemCondition[] conditions;
    private final IItemTransformerNew[] transformerNews;
    private final IItemTransformer[] transformer;

    public IngredientOr(IIngredient[] elements) {
        this.elements = elements;
        this.mark = null;
        this.conditions = ArrayUtil.EMPTY_CONDITIONS;
        this.transformerNews = ArrayUtil.EMPTY_TRANSFORMERS;
        this.transformer = ArrayUtil.EMPTY_TRANSFORMERS_NEW;
    }

    public IngredientOr(IIngredient a, IIngredient b) {
        this(new IIngredient[]{a, b});
    }

    private IngredientOr(IIngredient[] elements, String mark, IItemCondition[] conditions, IItemTransformerNew[] transformerNews, IItemTransformer[] transformers) {
        this.elements = elements;
        this.mark = mark;
        this.conditions = conditions;
        this.transformerNews = transformerNews;
        this.transformer = transformers;
    }

    @Override
    public String getMark() {
        return this.mark;
    }

    @Override
    public int getAmount() {
        return this.elements[0].getAmount();
    }

    @Override
    public List<IItemStack> getItems() {
        ArrayList<IItemStack> result = new ArrayList<IItemStack>();
        for (IIngredient element : this.elements) {
            if (element != null) {
                result.addAll(element.getItems());
                continue;
            }
            if (!result.contains(null)) continue;
            result.add(null);
        }
        return result;
    }

    @Override
    public IItemStack[] getItemArray() {
        List<IItemStack> items = this.getItems();
        return items.toArray(new IItemStack[0]);
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        ArrayList<ILiquidStack> result = new ArrayList<ILiquidStack>();
        for (IIngredient element : this.elements) {
            if (element == null) continue;
            result.addAll(element.getLiquids());
        }
        return result;
    }

    @Override
    public IIngredient amount(int amount) {
        IIngredient[] result = new IIngredient[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            result[i] = this.elements[i].amount(amount);
        }
        return new IngredientOr(result);
    }

    @Override
    public IIngredient transformNew(IItemTransformerNew transformer) {
        return new IngredientOr(this.elements, this.mark, this.conditions, ArrayUtil.append(this.transformerNews, transformer), this.transformer);
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientOr(this.elements, this.mark, ArrayUtil.append(this.conditions, condition), this.transformerNews, this.transformer);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientOr(this.elements, mark, this.conditions, this.transformerNews, this.transformer);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(ArrayUtil.append(this.elements, ingredient));
    }

    @Override
    public boolean matches(IItemStack item) {
        for (IIngredient ingredient : this.elements) {
            if (!(ingredient == null ? item == null : ingredient.matches(item))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        for (IIngredient ingredient : this.elements) {
            if (!(ingredient == null ? item == null : ingredient.matchesExact(item))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        for (IIngredient ingredient : this.elements) {
            if (!(ingredient == null ? liquid == null : ingredient.matches(liquid))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        if (ingredient == null) {
            return this.matches((IItemStack)null) || this.matches((ILiquidStack)null);
        }
        List<IItemStack> items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        for (IItemTransformer transformer : this.transformer) {
            item = transformer.transform(item, byPlayer);
        }
        return item;
    }

    @Override
    public IItemStack applyNewTransform(IItemStack item) {
        boolean changed = false;
        for (IIngredient element : this.elements) {
            if (element == null || !element.matches(item) || !element.hasNewTransformers()) continue;
            item = element.applyNewTransform(item);
            changed = true;
        }
        if (this.transformerNews.length == 0 && !changed) {
            return ItemStackUnknown.INSTANCE;
        }
        for (IItemTransformerNew transformer : this.transformerNews) {
            item = transformer.transform(item);
        }
        return item;
    }

    @Override
    public boolean hasNewTransformers() {
        for (IIngredient element : this.elements) {
            if (element == null || !element.hasNewTransformers()) continue;
            return true;
        }
        return this.transformerNews.length > 0;
    }

    @Override
    public boolean hasTransformers() {
        return this.transformer.length != 0;
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientOr(this.elements, this.mark, this.conditions, this.transformerNews, ArrayUtil.append(this.transformer, transformer));
    }

    @Override
    public Object getInternal() {
        return this.elements;
    }

    @Override
    public String toCommandString() {
        if (this.elements.length == 0) {
            return "ERROR";
        }
        StringJoiner joiner = new StringJoiner(" | ");
        for (IIngredient element : this.elements) {
            joiner.add(element == null ? "null" : element.toCommandString());
        }
        return joiner.toString();
    }

    public String toString() {
        return this.toCommandString();
    }
}

