/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles;

import com.creativemd.littletiles.client.render.cache.RenderingThread;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="littletiles", category="")
@Mod.EventBusSubscriber
public class LittleTilesConfig {
    @Config.Name(value="core")
    @Config.LangKey(value="config.littletiles.core")
    @Config.RequiresMcRestart
    public static Core core = new Core();
    @Config.Name(value="building")
    @Config.LangKey(value="config.littletiles.building")
    public static Building building = new Building();
    @Config.Name(value="rendering")
    @Config.LangKey(value="config.littletiles.rendering")
    public static Rendering rendering = new Rendering();

    public static List<String> getConfigProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        LittleTilesConfig.loadProperties("", LittleTilesConfig.class, properties);
        return properties;
    }

    private static void loadProperties(String category, Class<?> clazz, List<String> properties) {
        for (Field field : clazz.getFields()) {
            Config.Name config = field.getAnnotation(Config.Name.class);
            if (config == null) continue;
            if (field.getType().getAnnotation(LittleConfig.class) != null) {
                LittleTilesConfig.loadProperties(category + (category.isEmpty() ? "" : ".") + config.value(), field.getType(), properties);
                continue;
            }
            properties.add(category + "." + config.value());
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("littletiles")) {
            ConfigManager.sync((String)"littletiles", (Config.Type)Config.Type.INSTANCE);
            RenderingThread.initThreads(LittleTilesConfig.rendering.renderingThreadCount);
        }
    }

    @LittleConfig
    public static class Rendering {
        @Config.Name(value="useQuadCache")
        @Config.LangKey(value="config.littletiles.useQuadCache")
        @Config.Comment(value={"Significantly increases RAM usuage, but reduces rerendering time. Only effective if useCubeCache is true (Requires world restart)"})
        public boolean useQuadCache = false;
        @Config.Name(value="useCubeCache")
        @Config.LangKey(value="config.littletiles.useCubeCache")
        @Config.Comment(value={"Significantly increases RAM usuage, but reduces rerendering time. (Requires world restart)"})
        public boolean useCubeCache = true;
        @Config.Name(value="hideParticleBlock")
        @Config.LangKey(value="config.littletiles.hideParticleBlock")
        @Config.Comment(value={"Whether the particle block is visible or not"})
        public boolean hideParticleBlock = false;
        @Config.Name(value="renderingThreadCount")
        @Config.LangKey(value="config.littletiles.renderingThreadCount")
        @Config.Comment(value={"Number of threads for rendering blocks"})
        public int renderingThreadCount = 2;
        @Config.Name(value="highlightStructureBox")
        @Config.LangKey(value="config.littletiles.highlightStructureBox")
        @Config.Comment(value={"Whether a tile of structure should render its own selection box or that of the entire structure"})
        public boolean highlightStructureBox = true;
        @Config.Name(value="previewLines")
        @Config.LangKey(value="config.littletiles.previewLines")
        @Config.Comment(value={"When set to true lines will be used to render the preview"})
        public boolean previewLines = false;
        @Config.Name(value="enableRandomDisplayTick")
        @Config.LangKey(value="config.littletiles.enableRandomDisplayTick")
        @Config.Comment(value={"When set to true sand, gravel and redstone ore will spawn particles (also support other mods)"})
        public boolean enableRandomDisplayTick = false;
    }

    @LittleConfig
    public static class Building {
        @Config.Name(value="invertStickToGrid")
        @Config.LangKey(value="config.littletiles.invertStickToGrid")
        @Config.Comment(value={"Whether tiles should stick to the vanilla grid when second mode is enabled or disabled."})
        public boolean invertStickToGrid = false;
        @Config.Name(value="maxSavedActions")
        @Config.LangKey(value="config.littletiles.maxSavedActions")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Number of actions which can be reverted."})
        public int maxSavedActions = 32;
        @Config.Name(value="useALTForEverything")
        @Config.LangKey(value="config.littletiles.useALTForEverything")
        @Config.Comment(value={"Second mode will be activated if 'ALT' is pressed (default: sneaking)."})
        public boolean useALTForEverything = false;
        @Config.Name(value="useAltWhenFlying")
        @Config.LangKey(value="config.littletiles.useAltWhenFlying")
        @Config.Comment(value={"Press 'ALT' when flying instead of sneaking to activate second mode."})
        public boolean useAltWhenFlying = true;
    }

    @Config.RequiresMcRestart
    @LittleConfig
    public static class Core {
        @Config.Name(value="defaultSize")
        @Config.RequiresMcRestart
        @Config.Comment(value={"Needs to be part of the row. ATTENTION! This needs be equal for every client & server. Backup your world. This will make your tiles either shrink down or increase in size!"})
        @Config.RangeInt(min=1, max=0x7FFFFFFF)
        public int defaultSize = 16;
        @Config.Name(value="minSize")
        @Config.RequiresMcRestart
        @Config.Comment(value={"The minimum grid size possible. ATTENTION! This needs be equal for every client & server. Backup your world."})
        @Config.RangeInt(min=1, max=0x7FFFFFFF)
        public int minSize = 1;
        @Config.Name(value="scale")
        @Config.RequiresMcRestart
        @Config.Comment(value={"How many grids there are. ATTENTION! This needs be equal for every client & server. Make sure that it is enough for the defaultSize to exist."})
        @Config.RangeInt(min=1, max=0x7FFFFFFF)
        public int scale = 6;
        @Config.Name(value="multiplier")
        @Config.RequiresMcRestart
        @Config.Comment(value={"minSize ^ (multiplier * scale). ATTENTION! This needs be equal for every client & server. Default is 2 -> (1, 2, 4, 8, 16, 32 etc.)."})
        @Config.RangeInt(min=2, max=0x7FFFFFFF)
        public int exponent = 2;
        @Config.Name(value="forceToSaveDefaultSize")
        @Config.RequiresMcRestart
        @Config.Comment(value={"Default grid size will be saved as well"})
        public boolean forceToSaveDefaultSize = false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LittleConfig {
    }
}

