/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleInventory;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientEntry;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredients;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class LittleSubGuiUtils {
    public static GuiStackSelectorAll.StackCollector getCollector(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return new GuiStackSelectorAll.CreativeCollector((GuiStackSelectorAll.StackSelector)new LittleBlockSelector());
        }
        return new LittleBlockCollector((GuiStackSelectorAll.StackSelector)new LittleBlockSelector());
    }

    public static class LittleBlockCollector
    extends GuiStackSelectorAll.InventoryCollector {
        public LittleBlockCollector(GuiStackSelectorAll.StackSelector selector) {
            super(selector);
        }

        public HashMapList<String, ItemStack> collect(EntityPlayer player) {
            HashMapList stacks = super.collect(player);
            BlockIngredient ingredients = new BlockIngredient();
            for (ItemStack stack : LittleAction.getInventories(player)) {
                LittleIngredients inventory = ((ILittleInventory)stack.func_77973_b()).getInventory(stack);
                if (inventory == null) continue;
                ingredients.add(inventory.get(BlockIngredient.class));
            }
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (BlockIngredientEntry ingredient : ingredients) {
                ItemStack stack = ingredient.getItemStack();
                stack.func_190920_e(Math.max(1, (int)ingredient.value));
                NBTTagCompound display = new NBTTagCompound();
                NBTTagList list = new NBTTagList();
                int blocks = (int)ingredient.value;
                double pixel = (ingredient.value - (double)blocks) * (double)LittleGridContext.get().maxTilesPerBlock;
                list.func_74742_a((NBTBase)new NBTTagString((blocks > 0 ? blocks + " blocks " : "") + (pixel > 0.0 ? Math.round(pixel * 100.0) / 100L + " pixel" : "")));
                display.func_74782_a("Lore", (NBTBase)list);
                stack.func_77983_a("display", (NBTBase)display);
                newStacks.add(stack);
            }
            stacks.add((Object)"selector.ingredients", newStacks);
            return stacks;
        }
    }

    public static class LittleBlockSelector
    extends GuiStackSelectorAll.GuiBlockSelector {
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return LittleAction.isBlockValid(BlockUtils.getState((ItemStack)stack));
            }
            return false;
        }
    }
}

