/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAvatarLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.gui.LittleSubGuiUtils;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.items.ItemLittleChisel;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.shape.DragShape;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.util.Color;

public class SubGuiChisel
extends SubGuiConfigure {
    public SubGuiChisel(ItemStack stack) {
        super(140, 180, stack);
        this.stack = stack;
    }

    public LittleGridContext getContext() {
        return ((ILittleTile)this.stack.func_77973_b()).getPositionContext(this.stack);
    }

    public void createControls() {
        LittleTilePreview preview = ItemLittleChisel.getPreview(this.stack);
        Color color = ColorUtils.IntToRGBA((int)preview.getColor());
        this.controls.add(new GuiColorPicker("picker", 2, 2, color, SpecialServerConfig.isTransparencyEnabled(this.getPlayer()), SpecialServerConfig.getMinimumTransparency(this.getPlayer())));
        GuiStackSelectorAll selector = new GuiStackSelectorAll("preview", 0, 75, 112, this.getPlayer(), LittleSubGuiUtils.getCollector(this.getPlayer()), true);
        selector.setSelectedForce(preview.getBlockStack());
        this.controls.add(selector);
        GuiComboBox box = new GuiComboBox("shape", 0, 96, 134, new ArrayList<String>(DragShape.shapes.keySet()));
        box.select(ItemLittleChisel.getShape((ItemStack)this.stack).key);
        GuiScrollBox scroll = new GuiScrollBox("settings", 0, 117, 133, 58);
        this.controls.add(box);
        this.controls.add(scroll);
        this.onChange();
        GuiAvatarLabel label = new GuiAvatarLabel("", 115, 35, 0, null);
        label.name = "avatar";
        label.height = 60;
        label.avatarSize = 32;
        this.controls.add(label);
        this.updateLabel();
    }

    @CustomEventSubscribe
    public void onComboBoxChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"shape"})) {
            this.onChange();
        } else if (event.source.is(new String[]{"picker", "preview"})) {
            this.updateLabel();
        }
    }

    public void onChange() {
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        DragShape shape = DragShape.getShape(box.caption);
        scroll.controls.clear();
        scroll.controls.addAll(shape.getCustomSettings(this.stack.func_77978_p(), this.getContext()));
        scroll.refreshControls();
    }

    public void updateLabel() {
        LittleTilePreview preview;
        GuiStackSelectorAll selector = (GuiStackSelectorAll)this.get("preview");
        ItemStack selected = selector.getSelected();
        if (!selected.func_190926_b() && selected.func_77973_b() instanceof ItemBlock) {
            LittleTileBlock tile = new LittleTileBlock(((ItemBlock)selected.func_77973_b()).func_179223_d(), selected.func_77960_j());
            tile.box = new LittleTileBox(LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size);
            preview = ((LittleTile)tile).getPreviewTile();
        } else {
            preview = ItemLittleChisel.getPreview(this.stack);
        }
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        preview.setColor(ColorUtils.RGBAToInt((Color)picker.color));
        GuiAvatarLabel label = (GuiAvatarLabel)this.get("avatar");
        label.avatar = new AvatarItemStack(ItemBlockTiles.getStackFromPreview(LittleGridContext.get(), preview));
    }

    @Override
    public void saveConfiguration() {
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        DragShape shape = DragShape.getShape(box.caption);
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        LittleTilePreview preview = ItemLittleChisel.getPreview(this.stack);
        GuiStackSelectorAll selector = (GuiStackSelectorAll)this.get("preview");
        ItemStack selected = selector.getSelected();
        if (!selected.func_190926_b() && selected.func_77973_b() instanceof ItemBlock) {
            LittleTileBlock tile = new LittleTileBlock(((ItemBlock)selected.func_77973_b()).func_179223_d(), selected.func_77960_j());
            tile.box = new LittleTileBox(LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size);
            preview = ((LittleTile)tile).getPreviewTile();
        } else {
            preview = ItemLittleChisel.getPreview(this.stack);
        }
        preview.setColor(ColorUtils.RGBAToInt((Color)picker.color));
        ItemLittleChisel.setPreview(this.stack, preview);
        ItemLittleChisel.setShape(this.stack, shape);
        shape.saveCustomSettings((GuiParent)scroll, this.stack.func_77978_p(), this.getContext());
    }
}

