/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.items.ItemLittleGrabber;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SubGuiGrabber
extends SubGuiConfigure {
    public final ItemLittleGrabber.GrabberMode mode;
    public final int index;
    public final ItemLittleGrabber.GrabberMode[] modes;
    public LittleGridContext context;

    public SubGuiGrabber(ItemLittleGrabber.GrabberMode mode, ItemStack stack, int width, int height, LittleGridContext context) {
        super(width, height, stack);
        this.mode = mode;
        this.modes = ItemLittleGrabber.getModes();
        this.index = ItemLittleGrabber.indexOf(mode);
        this.context = context;
    }

    @Override
    public void onClosed() {
        super.onClosed();
        ItemLittleGrabber.setMode(this.stack, this.mode);
        this.saveConfiguration();
        this.sendPacketToServer(this.stack.func_77978_p());
    }

    public void openNewGui(ItemLittleGrabber.GrabberMode mode) {
        ItemLittleGrabber.setMode(this.stack, mode);
        GuiHandler.openGui((String)"grabber", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)this.getPlayer());
    }

    public void createControls() {
        this.controls.add(new GuiButton("<<", 0, 0, 10){

            public void onClicked(int x, int y, int button) {
                int newIndex = SubGuiGrabber.this.index - 1;
                if (newIndex < 0) {
                    newIndex = SubGuiGrabber.this.modes.length - 1;
                }
                SubGuiGrabber.this.openNewGui(SubGuiGrabber.this.modes[newIndex]);
            }
        });
        this.controls.add(new GuiButton(">>", 124, 0, 10){

            public void onClicked(int x, int y, int button) {
                int newIndex = SubGuiGrabber.this.index + 1;
                if (newIndex >= SubGuiGrabber.this.modes.length) {
                    newIndex = 0;
                }
                SubGuiGrabber.this.openNewGui(SubGuiGrabber.this.modes[newIndex]);
            }
        });
        this.controls.add(new GuiLabel(this.mode.getLocalizedName(), 20, 3));
    }
}

