/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.littletiles.common.utils.tooltip.ActionMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class GuiActionDisplay
extends GuiControl {
    protected List<ActionMessage> messages = new ArrayList<ActionMessage>();
    private int maxActions;
    private int displayTime;
    private int fadeTime;
    private int totalTime;
    protected int lines = 0;

    public GuiActionDisplay(String name, int x, int y, int width) {
        super(name, x, y, width, 10);
        this.setTimer(5, 1);
        this.setMessageCount(6);
    }

    public GuiActionDisplay setMessageCount(int count) {
        this.maxActions = count;
        ArrayList<ActionMessage> newMessages = new ArrayList<ActionMessage>();
        for (int i = 0; i < this.messages.size() && i < count; ++i) {
            newMessages.add(this.messages.get(i));
        }
        this.messages = newMessages;
        this.height = (GuiActionDisplay.font.field_78288_b + 3) * this.maxActions;
        return this;
    }

    public GuiActionDisplay setLinesCount(int count) {
        this.height = (GuiActionDisplay.font.field_78288_b + 3) * count;
        return this;
    }

    public GuiActionDisplay setTimer(int displaySeconds, int fadeSeconds) {
        this.displayTime = displaySeconds * 1000;
        this.fadeTime = fadeSeconds * 1000;
        this.totalTime = this.displayTime + this.fadeTime;
        return this;
    }

    public void addMessage(ActionMessage message) {
        this.messages.add(0, message);
        if (this.messages.size() > this.maxActions) {
            for (int i = this.maxActions; i < this.messages.size(); ++i) {
                this.messages.remove(i);
            }
        }
        this.updateLineCount();
    }

    public void addMessage(String text, Object ... objects) {
        this.addMessage(new ActionMessage(text, objects));
    }

    protected void removeMessage(int index) {
        this.messages.remove(index);
        this.updateLineCount();
    }

    protected void updateLineCount() {
        this.lines = 0;
        for (int i = 0; i < this.messages.size(); ++i) {
            if (this.messages.get(i) == null) continue;
            this.lines += this.messages.get((int)i).lines.size();
        }
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        int i = 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        int requiredHeight = (GuiActionDisplay.font.field_78288_b + 3) * (this.lines - 1);
        GlStateManager.func_179109_b((float)(width / 2), (float)(height - requiredHeight), (float)0.0f);
        while (i < this.messages.size()) {
            ActionMessage message = this.messages.get(i);
            long timer = System.currentTimeMillis() - message.timestamp;
            if (timer >= (long)this.totalTime) {
                this.removeMessage(i);
                continue;
            }
            GlStateManager.func_179094_E();
            float alpha = timer > (long)this.displayTime ? 1.0f - Math.max(0.0f, (float)(timer - (long)this.displayTime)) / (float)this.fadeTime : 1.0f;
            message.render(helper, Math.max(0.05f, alpha));
            ++i;
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
    }
}

