/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.littletiles.client.gui.controls.GuiSlotControlBlockIngredient;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientEntry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotControlBlockIngredient
extends SlotControl {
    public BlockIngredientEntry ingredient;

    public SlotControlBlockIngredient(Slot slot, BlockIngredientEntry ingredient) {
        super(slot);
        this.ingredient = ingredient;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiControl createGuiControl() {
        GuiSlotControlBlockIngredient control = new GuiSlotControlBlockIngredient(this.slot.field_75223_e, this.slot.field_75221_f, this, this.ingredient);
        return control;
    }

    public int getStackLimit(Slot slot, ItemStack stack) {
        return LittleGridContext.get().maxTilesPerBlock;
    }

    public int getItemStackLimit(ItemStack stack) {
        return LittleGridContext.get().maxTilesPerBlock;
    }

    public boolean canMergeIntoInventory(Slot mergeSlot) {
        return super.canMergeIntoInventory(mergeSlot) && !mergeSlot.field_75224_c.func_70005_c_().equals("input");
    }

    public boolean isFullItem() {
        return this.slot.func_75211_c().func_190916_E() >= LittleGridContext.get().maxTilesPerBlock;
    }

    public ItemStack getFullStack() {
        if (this.ingredient != null) {
            ItemStack stack = this.ingredient.getItemStack();
            stack.func_190920_e(this.slot.func_75211_c().func_190916_E() / LittleGridContext.get().maxTilesPerBlock);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void transferIntoOtherInventory(int amount) {
        if (!this.isFullItem()) {
            super.transferIntoOtherInventory(amount);
        }
        ItemStack stack = this.getFullStack();
        int countbefore = stack.func_190916_E();
        if (amount > stack.func_190916_E()) {
            amount = stack.func_190916_E();
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(amount);
        int minAmount = stack.func_190916_E() - amount;
        this.mergeToOtherInventory(copy, false);
        if (!copy.func_190926_b()) {
            this.mergeToOtherInventory(copy, true);
        }
        if (copy.func_190926_b()) {
            stack.func_190920_e(minAmount);
        } else {
            stack.func_190918_g(amount - copy.func_190916_E());
        }
        this.slot.func_75211_c().func_190918_g((countbefore - stack.func_190916_E()) * LittleGridContext.get().maxTilesPerBlock);
    }

    public void takeStack(boolean leftClick, InventoryPlayer inventoryplayer) {
        if (!this.isFullItem()) {
            super.takeStack(leftClick, inventoryplayer);
            return;
        }
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o();
        ItemStack slotItem = this.getFullStack();
        int countbefore = slotItem.func_190916_E();
        if (leftClick) {
            int stackSize = Math.min(Math.min(slotItem.func_190916_E(), slotItem.func_77976_d()), slotItem.func_190916_E());
            ItemStack newHand = slotItem.func_77946_l();
            newHand.func_190920_e(stackSize);
            inventoryplayer.func_70437_b(newHand);
            slotItem.func_190918_g(stackSize);
            this.slot.func_75211_c().func_190918_g((countbefore - slotItem.func_190916_E()) * LittleGridContext.get().maxTilesPerBlock);
            this.slot.func_190901_a(this.getPlayer(), inventoryplayer.func_70445_o());
        }
    }
}

