/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.config;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.ConfigTab;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.creativemd.igcm.api.segments.IntegerSliderSegment;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;

public class IGCMLoader {
    public static void initIGCM() {
        ConfigTab.root.registerElement("littletiles", (ConfigElement)new ConfigBranch("LittleTiles", new ItemStack(LittleTiles.hammer)){

            public void saveExtra(NBTTagCompound nbt) {
            }

            public void loadExtra(NBTTagCompound nbt) {
            }

            public boolean requiresSynchronization() {
                return true;
            }

            public void onRecieveFrom(Side side) {
                SpecialServerConfig.allowFlowingWater = (Boolean)this.getValue("allowFlowingWater");
                SpecialServerConfig.allowFlowingLava = (Boolean)this.getValue("allowFlowingLava");
                SpecialServerConfig.enableBed = (Boolean)this.getValue("enableBed");
            }

            public void createChildren() {
                this.registerElement("survival", (ConfigElement)new ConfigBranch("Survival", new ItemStack(Blocks.field_180401_cv)){

                    public void saveExtra(NBTTagCompound nbt) {
                    }

                    public void loadExtra(NBTTagCompound nbt) {
                    }

                    public boolean requiresSynchronization() {
                        return true;
                    }

                    public void onRecieveFrom(Side side) {
                        SpecialServerConfig.strictMining = (Boolean)this.getValue("strictMining");
                        SpecialServerConfig.editUnbreakable = (Boolean)this.getValue("editUnbreakable");
                        SpecialServerConfig.limitEditBlocksSurvival = (Boolean)this.getValue("limitEditBlocksSurvival");
                        SpecialServerConfig.maxEditBlocks = (Integer)this.getValue("maxEditBlocks");
                        SpecialServerConfig.limitPlaceBlocksSurvival = (Boolean)this.getValue("limitPlaceBlocksSurvival");
                        SpecialServerConfig.maxPlaceBlocks = (Integer)this.getValue("maxPlaceBlocks");
                        SpecialServerConfig.minimumTransparency = (Integer)this.getValue("minimumTransparency");
                        SpecialServerConfig.storagePerPixel = ((Float)this.getValue("storagePerPixel")).floatValue();
                        SpecialServerConfig.dyeVolume = ((Float)this.getValue("dyeVolume")).floatValue();
                        SpecialServerConfig.highestHarvestTierSurvival = (Integer)this.getValue("highestHarvestTierSurvival");
                    }

                    public void createChildren() {
                        this.registerElement("strictMining", (ConfigElement)new BooleanSegment("Strict Mininig in Survival", Boolean.valueOf(false)).setToolTip(new String[]{"If you can edit a vanilla block in survival directly (hammer/ paint brush)."}));
                        this.registerElement("highestHarvestTierSurvival", (ConfigElement)new IntegerSegment("Harvest Level in Survival", Integer.valueOf(0), 0, 10).setToolTip(new String[]{"0: any, 1: stone, 2: iron, 3: dimanond."}));
                        this.registerElement("editUnbreakable", (ConfigElement)new BooleanSegment("Edit Unbreakable Blocks", Boolean.valueOf(false)).setToolTip(new String[]{"If you can edit an unbreakable block (bedrock) in survival."}));
                        this.registerElement("limitEditBlocksSurvival", (ConfigElement)new BooleanSegment("Limit Edit/Remove Range", Boolean.valueOf(false)).setToolTip(new String[]{"If the amount a player can destroy or paint at once should be limited in survival."}));
                        this.registerElement("maxEditBlocks", (ConfigElement)new IntegerSegment("Max Edit/Remove Range", Integer.valueOf(10), 1, Integer.MAX_VALUE).setToolTip(new String[]{"Only affects the range if edit/remove limitation is enabled."}));
                        this.registerElement("limitPlaceBlocksSurvival", (ConfigElement)new BooleanSegment("Limit Place Range", Boolean.valueOf(false)).setToolTip(new String[]{"If the amount a player can place at once should be limited in survival."}));
                        this.registerElement("maxPlaceBlocks", (ConfigElement)new IntegerSegment("Max Place Range", Integer.valueOf(10), 1, Integer.MAX_VALUE).setToolTip(new String[]{"Only affects the range if place limitation is enabled."}));
                        this.registerElement("minimumTransparency", (ConfigElement)new IntegerSliderSegment("Minimum Transparency in survival", Integer.valueOf(255), 0, 255).setToolTip(new String[]{"Transparency will be enabled if the minimum is smaller than 255."}));
                        this.registerElement("storagePerPixel", (ConfigElement)new FloatSegment("Storage per Pixel", Float.valueOf(1.0f), 0.0f, Float.MAX_VALUE).setToolTip(new String[]{"Each pixel in default grid makes space for one itemstack (stacksize of one).", "64 pixel add up to one slot"}));
                        this.registerElement("dyeVolume", (ConfigElement)new FloatSegment("Dye Volume", Float.valueOf(1.0f), 0.0f, Float.MAX_VALUE).setToolTip(new String[]{"How many blocks can painted with one dye", "assuming the tile has the exact same color"}));
                    }
                });
                this.registerElement("allowFlowingWater", (ConfigElement)new BooleanSegment("Allow Flowing Water", Boolean.valueOf(true)).setToolTip(new String[]{"If disabled the bucket cannot be used to change the water flow."}));
                this.registerElement("allowFlowingLava", (ConfigElement)new BooleanSegment("Allow Flowing Lava", Boolean.valueOf(true)).setToolTip(new String[]{"If disabled the bucket cannot be used to change the lava flow."}));
                this.registerElement("enableBed", (ConfigElement)new BooleanSegment("Enable Bed", Boolean.valueOf(true)).setToolTip(new String[]{"Whether players should be allowed to sleep in LT beds or not."}));
            }
        });
    }
}

