/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxPlane;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.utils.math.collision.CollidingPlane;
import com.creativemd.creativecore.common.utils.math.collision.CollisionCoordinator;
import com.creativemd.creativecore.common.utils.math.vec.ChildVecOrigin;
import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import com.creativemd.creativecore.common.utils.math.vec.VecUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.FakeWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.client.render.world.LittleRenderChunkSuppilier;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.entity.AABBCombiner;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.events.LittleDoorHandler;
import com.creativemd.littletiles.common.items.ItemLittleWrench;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierStructureAbsolute;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.vec.LittleRayTraceResult;
import com.creativemd.littletiles.common.utils.vec.LittleTransformation;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimation
extends Entity {
    protected static final Predicate<Entity> noAnimation = x -> !(x instanceof EntityAnimation);
    public double initalOffX;
    public double initalOffY;
    public double initalOffZ;
    public double initalRotX;
    public double initalRotY;
    public double initalRotZ;
    public CreativeWorld fakeWorld;
    public IVecOrigin origin;
    public EntityAnimationController controller;
    public boolean enteredAsChild = false;
    public LittleStructure structure;
    public LittleTileIdentifierStructureAbsolute structureIdentifier;
    public StructureAbsolute center;
    public BlockPos absolutePreviewPos;
    public boolean preventPush = false;
    public boolean noCollision = false;
    public AABBCombiner collisionBoxWorker;
    public List<OrientatedBoundingBox> worldCollisionBoxes;
    public OrientatedBoundingBox worldBoundingBox;
    @SideOnly(value=Side.CLIENT)
    public boolean spawnedInWorld;
    protected boolean hasOriginChanged = false;
    private boolean addedDoor;

    public EntityAnimation(World worldIn) {
        super(worldIn);
    }

    public EntityAnimation(World world, CreativeWorld fakeWorld, EntityAnimationController controller, BlockPos absolutePreviewPos, UUID uuid, StructureAbsolute center, LittleTileIdentifierStructureAbsolute identifier) {
        this(world);
        this.structureIdentifier = identifier;
        try {
            this.structure = identifier == null ? null : LittleAction.getTile((World)fakeWorld, (LittleTileIdentifierAbsolute)identifier).connection.getStructureWithoutLoading();
        }
        catch (LittleActionException e) {
            throw new RuntimeException(e);
        }
        this.controller = controller;
        this.controller.setParent(this);
        this.absolutePreviewPos = absolutePreviewPos;
        this.setFakeWorld(fakeWorld);
        this.field_96093_i = uuid;
        this.field_189513_ar = this.field_96093_i.toString();
        this.setCenter(center);
        this.updateWorldCollision();
        this.func_70107_b(center.baseOffset.func_177958_n(), center.baseOffset.func_177956_o(), center.baseOffset.func_177952_p());
        this.addDoor();
        this.preventPush = true;
        this.updateTickState();
        this.updateBoundingBox();
        this.initalOffX = this.origin.offX();
        this.initalOffY = this.origin.offY();
        this.initalOffZ = this.origin.offZ();
        this.initalRotX = this.origin.rotX();
        this.initalRotY = this.origin.rotY();
        this.initalRotZ = this.origin.rotZ();
        this.preventPush = false;
        this.origin.tick();
    }

    public void setFakeWorld(CreativeWorld fakeWorld) {
        this.fakeWorld = fakeWorld;
        this.fakeWorld.parent = this;
        if (this.field_70170_p.field_72995_K && this.fakeWorld.renderChunkSupplier == null) {
            this.fakeWorld.renderChunkSupplier = new LittleRenderChunkSuppilier();
        }
    }

    public boolean shouldAddDoor() {
        return !(this.field_70170_p instanceof FakeWorld) && (!(this.field_70170_p instanceof SubWorld) || !(((SubWorld)this.field_70170_p).getRealWorld() instanceof FakeWorld));
    }

    public World getRealWorld() {
        if (this.field_70170_p instanceof SubWorld) {
            return ((SubWorld)this.field_70170_p).getParent();
        }
        return this.field_70170_p;
    }

    public boolean isDoorAdded() {
        return this.addedDoor;
    }

    public void addDoor() {
        if (!this.shouldAddDoor()) {
            return;
        }
        if (!this.addedDoor) {
            LittleDoorHandler.getHandler(this.field_70170_p.field_72995_K).createDoor(this);
            this.addedDoor = true;
        }
    }

    public void markRemoved() {
        this.field_70128_L = true;
        this.addedDoor = false;
        if (this.fakeWorld == null || this.fakeWorld.field_72996_f == null) {
            return;
        }
        for (Entity entity : this.fakeWorld.field_72996_f) {
            if (!(entity instanceof EntityAnimation)) continue;
            ((EntityAnimation)entity).markRemoved();
        }
    }

    protected void func_70088_a() {
        this.addDoor();
    }

    public void setCenter(StructureAbsolute center) {
        this.center = center;
        this.fakeWorld.setOrigin(center.rotationCenter);
        this.origin = this.fakeWorld.getOrigin();
        if (this.fakeWorld.field_72996_f.isEmpty()) {
            return;
        }
        for (Entity entity : this.fakeWorld.field_72996_f) {
            if (!(entity instanceof EntityAnimation)) continue;
            ((ChildVecOrigin)((EntityAnimation)entity).origin).parent = this.origin;
        }
    }

    public void setCenterVec(LittleTilePos axis, LittleTileVec additional) {
        this.setCenter(new StructureAbsolute(axis, additional));
    }

    public void setParentWorld(World world) {
        this.enteredAsChild = this.field_70170_p instanceof CreativeWorld && !(world instanceof CreativeWorld);
        this.field_70170_p = world;
        if (this.fakeWorld instanceof SubWorld) {
            ((SubWorld)this.fakeWorld).parentWorld = world;
        }
        this.fakeWorld.setOrigin(this.center.rotationCenter);
        this.origin = this.fakeWorld.getOrigin();
        this.hasOriginChanged = true;
    }

    public void updateWorldCollision() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        this.worldCollisionBoxes = new ArrayList<OrientatedBoundingBox>();
        for (TileEntity tileEntity : this.fakeWorld.field_147482_g) {
            TileEntityLittleTiles te;
            if (!(tileEntity instanceof TileEntityLittleTiles) || (te = (TileEntityLittleTiles)tileEntity).isEmpty()) continue;
            AxisAlignedBB bb = te.getSelectionBox();
            minX = Math.min(minX, bb.field_72340_a);
            minY = Math.min(minY, bb.field_72338_b);
            minZ = Math.min(minZ, bb.field_72339_c);
            maxX = Math.max(maxX, bb.field_72336_d);
            maxY = Math.max(maxY, bb.field_72337_e);
            maxZ = Math.max(maxZ, bb.field_72334_f);
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (LittleTile tile : te) {
                List<LittleTileBox> tileBoxes = tile.getCollisionBoxes();
                for (LittleTileBox box : tileBoxes) {
                    boxes.add(box.getBox(te.getContext(), te.func_174877_v()));
                }
            }
            for (AxisAlignedBB box : boxes) {
                this.worldCollisionBoxes.add(new OrientatedBoundingBox(this.origin, box));
            }
        }
        this.fakeWorld.hasChanged = false;
        this.hasOriginChanged = true;
        this.collisionBoxWorker = new AABBCombiner(this.worldCollisionBoxes, 0.0);
        this.worldBoundingBox = minX == Double.MAX_VALUE ? new OrientatedBoundingBox(this.origin, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0) : new OrientatedBoundingBox(this.origin, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static double minIgnore(double par1, double par2) {
        if (Math.abs(par2) < Math.abs(par1)) {
            return par2;
        }
        return par1;
    }

    private static double maxIgnore(double par1, double par2) {
        if (Math.abs(par2) > Math.abs(par1)) {
            return par2;
        }
        return par1;
    }

    public void moveAndRotateAnimation(double x, double y, double z, double rotX, double rotY, double rotZ) {
        if (x == 0.0 && y == 0.0 && z == 0.0 && rotX == 0.0 && rotY == 0.0 && rotZ == 0.0) {
            return;
        }
        CollisionCoordinator coordinator = new CollisionCoordinator(x, y, z, rotX, rotY, rotZ, this.origin, this.origin);
        this.moveAndRotateAnimation(coordinator);
        coordinator.move();
    }

    public void moveAndRotateAnimation(CollisionCoordinator coordinator) {
        if (this.preventPush) {
            return;
        }
        this.noCollision = true;
        World world = this.getRealWorld();
        List entities = world.func_175647_a(Entity.class, coordinator.computeSurroundingBox((AxisAlignedBB)this.worldBoundingBox), noAnimation);
        if (!entities.isEmpty()) {
            Entity entity;
            ArrayList<AxisAlignedBB> surroundingBoxes = new ArrayList<AxisAlignedBB>(this.worldCollisionBoxes.size());
            for (OrientatedBoundingBox box : this.worldCollisionBoxes) {
                if (box.cache == null) {
                    box.buildCache();
                }
                box.cache.reset();
                surroundingBoxes.add(coordinator.computeSurroundingBox((AxisAlignedBB)box));
            }
            CollidingPlane.PushCache[] caches = new CollidingPlane.PushCache[entities.size()];
            for (int j = 0; j < entities.size(); ++j) {
                entity = (Entity)entities.get(j);
                AxisAlignedBB entityBB = entity.func_174813_aQ();
                Vector3d center = new Vector3d(entityBB.field_72340_a + (entityBB.field_72336_d - entityBB.field_72340_a) * 0.5, entityBB.field_72338_b + (entityBB.field_72337_e - entityBB.field_72338_b) * 0.5, entityBB.field_72339_c + (entityBB.field_72334_f - entityBB.field_72339_c) * 0.5);
                double radius = VecUtils.distanceToSquared((double)entityBB.field_72340_a, (double)entityBB.field_72338_b, (double)entityBB.field_72339_c, (Vector3d)center);
                Double t = null;
                OrientatedBoundingBox pushingBox = null;
                EnumFacing facing = null;
                block2: for (int i = 0; i < surroundingBoxes.size(); ++i) {
                    if (!((AxisAlignedBB)surroundingBoxes.get(i)).func_72326_a(entityBB)) continue;
                    OrientatedBoundingBox box = this.worldCollisionBoxes.get(i);
                    if (!box.cache.isCached()) {
                        box.cache.planes = CollidingPlane.getPlanes((CreativeAxisAlignedBB)box, (CollidingPlane.PlaneCache)box.cache, (CollisionCoordinator)coordinator);
                    }
                    for (CollidingPlane plane : box.cache.planes) {
                        Double tempT = plane.binarySearch(t, entityBB, radius, center, coordinator);
                        if (tempT == null) continue;
                        t = tempT;
                        pushingBox = box;
                        facing = plane.facing;
                        if (t == 0.0) break block2;
                    }
                }
                if (t == null) continue;
                CollidingPlane.PushCache cache = new CollidingPlane.PushCache();
                cache.facing = facing;
                Vector3d newCenter = new Vector3d(center);
                coordinator.transform(newCenter, Double.valueOf(1.0 - t));
                this.origin.transformPointToWorld(center);
                this.origin.transformPointToWorld(newCenter);
                cache.pushBox = pushingBox;
                cache.entityBox = entityBB.func_72317_d(newCenter.x - center.x, newCenter.y - center.y, newCenter.z - center.z);
                caches[j] = cache;
            }
            coordinator.move();
            for (int i = 0; i < entities.size(); ++i) {
                boolean cached;
                entity = (Entity)entities.get(i);
                CollidingPlane.PushCache cache = caches[i];
                boolean bl = cached = cache != null;
                if (!cached) {
                    cache = new CollidingPlane.PushCache();
                    cache.entityBox = entity.func_174813_aQ();
                }
                OrientatedBoundingBox fakeBox = coordinator.origin.getOrientatedBox(cache.entityBox);
                Vector3d center = new Vector3d(cache.entityBox.field_72340_a + (cache.entityBox.field_72336_d - cache.entityBox.field_72340_a) * 0.5, cache.entityBox.field_72338_b + (cache.entityBox.field_72337_e - cache.entityBox.field_72338_b) * 0.5, cache.entityBox.field_72339_c + (cache.entityBox.field_72334_f - cache.entityBox.field_72339_c) * 0.5);
                coordinator.origin.transformPointToFakeWorld(center);
                EnumFacing.Axis one = cached ? RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)cache.facing.func_176740_k()) : null;
                EnumFacing.Axis two = cached ? RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)cache.facing.func_176740_k()) : null;
                boolean ignoreOne = false;
                Boolean positiveOne = null;
                boolean ignoreTwo = false;
                Boolean positiveTwo = null;
                double maxVolume = 0.0;
                ArrayList<OrientatedBoundingBox> intersecting = new ArrayList<OrientatedBoundingBox>();
                ArrayList<EnumFacing> intersectingFacing = new ArrayList<EnumFacing>();
                if (cached) {
                    intersecting.add(cache.pushBox);
                    intersectingFacing.add(cache.facing);
                }
                for (OrientatedBoundingBox box : this.worldCollisionBoxes) {
                    if (cached && box == cache.pushBox || !box.func_72326_a((AxisAlignedBB)fakeBox)) continue;
                    box.cache.planes = CollidingPlane.getPlanes((CreativeAxisAlignedBB)box, (CollidingPlane.PlaneCache)box.cache, (CollisionCoordinator)coordinator);
                    EnumFacing facing = CollidingPlane.getDirection((CollisionCoordinator)coordinator, (OrientatedBoundingBox)box, (Vector3d)center);
                    if (facing == null || !coordinator.hasRotation && (!coordinator.hasTranslation || RotationUtils.get((EnumFacing.Axis)facing.func_176740_k(), (Tuple3d)coordinator.translation) == 0.0)) continue;
                    boolean add = false;
                    if (cached) {
                        if (facing == cache.facing) {
                            add = true;
                        } else if (!ignoreOne && facing.func_176740_k() == one) {
                            add = true;
                            if (positiveOne == null) {
                                positiveOne = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                            } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveOne) {
                                ignoreOne = true;
                                add = false;
                            }
                        } else if (!ignoreTwo && facing.func_176740_k() == two) {
                            add = true;
                            if (positiveTwo == null) {
                                positiveTwo = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                            } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveTwo) {
                                ignoreTwo = true;
                                add = false;
                            }
                        }
                    } else {
                        add = true;
                    }
                    if (!add) continue;
                    double intersectingVolume = box.getIntersectionVolume((AxisAlignedBB)fakeBox);
                    if (intersectingVolume > maxVolume) {
                        cache.pushBox = box;
                        maxVolume = intersectingVolume;
                        cache.facing = facing;
                    }
                    intersecting.add(box);
                    intersectingFacing.add(facing);
                }
                if (intersecting.isEmpty()) continue;
                if (!cached) {
                    one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)cache.facing.func_176740_k());
                    two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)cache.facing.func_176740_k());
                    positiveOne = null;
                    positiveTwo = null;
                    for (EnumFacing facing : intersectingFacing) {
                        if (!ignoreOne && facing.func_176740_k() == one) {
                            if (positiveOne == null) {
                                positiveOne = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                            } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveOne) {
                                ignoreOne = true;
                            }
                        } else if (!ignoreTwo && facing.func_176740_k() == two) {
                            if (positiveTwo == null) {
                                positiveTwo = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                            } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveTwo) {
                                ignoreTwo = true;
                            }
                        }
                        if (!ignoreOne || !ignoreTwo) continue;
                        break;
                    }
                }
                Vector3d pushVec = new Vector3d();
                RotationUtils.setValue((Tuple3d)pushVec, (double)cache.facing.func_176743_c().func_179524_a(), (EnumFacing.Axis)cache.facing.func_176740_k());
                if (!ignoreOne && positiveOne != null) {
                    RotationUtils.setValue((Tuple3d)pushVec, (double)(positiveOne != false ? 1.0 : -1.0), (EnumFacing.Axis)one);
                }
                if (!ignoreTwo && positiveTwo != null) {
                    RotationUtils.setValue((Tuple3d)pushVec, (double)(positiveTwo != false ? 1.0 : -1.0), (EnumFacing.Axis)two);
                }
                Vector3d pushInv = new Vector3d(-pushVec.x, -pushVec.y, -pushVec.z);
                Vector3d rotatedVec = new Vector3d(pushVec);
                this.origin.rotation().transform((Tuple3d)rotatedVec);
                Vector3d[] corners = BoxUtils.getRotatedCorners((AxisAlignedBB)cache.entityBox, (IVecOrigin)coordinator.origin);
                BoxPlane xPlane = BoxPlane.createOppositePlane((EnumFacing.Axis)EnumFacing.Axis.X, (Vector3d)rotatedVec, (Vector3d[])corners);
                BoxPlane yPlane = BoxPlane.createOppositePlane((EnumFacing.Axis)EnumFacing.Axis.Y, (Vector3d)rotatedVec, (Vector3d[])corners);
                BoxPlane zPlane = BoxPlane.createOppositePlane((EnumFacing.Axis)EnumFacing.Axis.Z, (Vector3d)rotatedVec, (Vector3d[])corners);
                double scale = 0.0;
                for (int j = 0; j < intersecting.size(); ++j) {
                    EnumFacing facing = (EnumFacing)intersectingFacing.get(j);
                    if (ignoreOne && facing.func_176740_k() == one || ignoreTwo && facing.func_176740_k() == two) continue;
                    scale = ((OrientatedBoundingBox)intersecting.get(j)).getPushOutScale(scale, fakeBox, cache.entityBox, pushVec, pushInv, xPlane, yPlane, zPlane);
                }
                boolean collidedHorizontally = entity.field_70123_F;
                boolean collidedVertically = entity.field_70124_G;
                boolean onGround = entity.field_70122_E;
                AxisAlignedBB originalBox = entity.func_174813_aQ();
                double moveX = cache.entityBox.field_72340_a - originalBox.field_72340_a + rotatedVec.x * scale;
                double moveY = cache.entityBox.field_72338_b - originalBox.field_72338_b + rotatedVec.y * scale;
                double moveZ = cache.entityBox.field_72339_c - originalBox.field_72339_c + rotatedVec.z * scale;
                entity.func_70091_d(MoverType.PISTON, moveX, moveY, moveZ);
                if (entity instanceof EntityPlayerMP) {
                    LittleDoorHandler.setPushedByDoor((EntityPlayerMP)entity);
                }
                if (moveX != 0.0 || moveZ != 0.0) {
                    collidedHorizontally = true;
                }
                if (moveY != 0.0) {
                    collidedVertically = true;
                    onGround = true;
                }
                entity.field_70123_F = collidedHorizontally;
                entity.field_70124_G = collidedVertically;
                entity.field_70122_E = onGround;
                entity.field_70132_H = collidedHorizontally || collidedVertically;
            }
            for (OrientatedBoundingBox box : this.worldCollisionBoxes) {
                box.cache.reset();
            }
        }
        for (int i = 0; i < this.fakeWorld.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.fakeWorld.field_72996_f.get(i);
            if (!(entity instanceof EntityAnimation)) continue;
            coordinator.reset(((EntityAnimation)entity).origin);
            ((EntityAnimation)entity).moveAndRotateAnimation(coordinator);
        }
        this.noCollision = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void createClient() {
    }

    public LittleRenderChunkSuppilier getRenderChunkSuppilier() {
        return (LittleRenderChunkSuppilier)this.fakeWorld.renderChunkSupplier;
    }

    protected void handleForces() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    protected void markOriginChange() {
        this.hasOriginChanged = true;
        if (this.fakeWorld.field_72996_f.isEmpty()) {
            return;
        }
        for (Entity entity : this.fakeWorld.field_72996_f) {
            if (!(entity instanceof EntityAnimation)) continue;
            ((EntityAnimation)entity).markOriginChange();
        }
    }

    public void updateBoundingBox() {
        if (this.worldBoundingBox == null || this.fakeWorld == null) {
            return;
        }
        if (this.origin.hasChanged() || this.hasOriginChanged) {
            this.markOriginChange();
            this.func_174826_a(this.origin.getAxisAlignedBox((AxisAlignedBB)this.worldBoundingBox));
            this.hasOriginChanged = false;
        }
    }

    public void updateTickState() {
        if (this.controller == null) {
            return;
        }
        AnimationState state = this.controller.getTickingState();
        Vector3d offset = state.getOffset();
        Vector3d rotation = state.getRotation();
        this.moveAndRotateAnimation(offset.x - this.origin.offX(), offset.y - this.origin.offY(), offset.z - this.origin.offZ(), rotation.x - this.origin.rotX(), rotation.y - this.origin.rotY(), rotation.z - this.origin.rotZ());
        this.origin.tick();
        this.hasOriginChanged = true;
    }

    public void onTick() {
        if (this.controller == null) {
            return;
        }
        AnimationState state = this.controller.tick();
        Vector3d offset = state.getOffset();
        Vector3d rotation = state.getRotation();
        this.moveAndRotateAnimation(offset.x - this.origin.offX(), offset.y - this.origin.offY(), offset.z - this.origin.offZ(), rotation.x - this.origin.rotX(), rotation.y - this.origin.rotY(), rotation.z - this.origin.rotZ());
    }

    public void func_70071_h_() {
    }

    public void onUpdateForReal() {
        if (this.fakeWorld == null && !this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
        if (this.fakeWorld == null) {
            return;
        }
        if (this.fakeWorld.hasChanged) {
            this.updateWorldCollision();
        }
        if (this.collisionBoxWorker != null) {
            this.collisionBoxWorker.work();
            if (this.collisionBoxWorker.hasFinished()) {
                this.collisionBoxWorker = null;
            }
        }
        this.origin.tick();
        this.handleForces();
        super.func_70071_h_();
        for (int i = 0; i < this.fakeWorld.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.fakeWorld.field_72996_f.get(i);
            if (!(entity instanceof EntityAnimation)) continue;
            ((EntityAnimation)entity).onUpdateForReal();
        }
        this.fakeWorld.field_72996_f.removeIf(x -> {
            if (x.field_70128_L) {
                if (x instanceof EntityAnimation) {
                    ((EntityAnimation)((Object)x)).markRemoved();
                }
                return true;
            }
            return false;
        });
        this.onTick();
        this.updateBoundingBox();
        ArrayList positions = new ArrayList();
        for (TileEntity te : this.fakeWorld.field_147482_g) {
            List<LittleTile> tickingTiles = ((TileEntityLittleTiles)te).getTickingTiles();
            if (tickingTiles.isEmpty()) continue;
            for (LittleTile tile : tickingTiles) {
                tile.updateEntity();
            }
        }
        this.field_70169_q = (double)this.center.baseOffset.func_177958_n() + this.origin.offXLast();
        this.field_70167_r = (double)this.center.baseOffset.func_177956_o() + this.origin.offYLast();
        this.field_70166_s = (double)this.center.baseOffset.func_177952_p() + this.origin.offZLast();
        this.field_70165_t = (double)this.center.baseOffset.func_177958_n() + this.origin.offX();
        this.field_70163_u = (double)this.center.baseOffset.func_177956_o() + this.origin.offY();
        this.field_70161_v = (double)this.center.baseOffset.func_177952_p() + this.origin.offZ();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
    }

    public void func_70634_a(double x, double y, double z) {
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
    }

    public void setInitialPosition(double x, double y, double z) {
        this.func_70107_b(x, y, z);
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.updateBoundingBox();
    }

    public void func_70106_y() {
        if (!(this.field_70128_L || this.field_70170_p.field_72995_K && this.controller != null && this.controller.isWaitingForRender())) {
            this.field_70128_L = true;
        }
    }

    public void destroyAnimation() {
        this.field_70128_L = true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return true;
    }

    public LittleRayTraceResult getRayTraceResult(Vec3d pos, Vec3d look) {
        return EntityAnimation.getTarget(this.fakeWorld, this.origin.transformPointToFakeWorld(pos), this.origin.transformPointToFakeWorld(look), pos, look);
    }

    private static LittleRayTraceResult getTarget(CreativeWorld world, Vec3d pos, Vec3d look, Vec3d originalPos, Vec3d originalLook) {
        RayTraceResult tempResult;
        LittleRayTraceResult result = null;
        double distance = 0.0;
        if (!world.field_72996_f.isEmpty()) {
            for (Entity entity : world.field_72996_f) {
                LittleRayTraceResult tempResult2;
                Vec3d newLook;
                if (!(entity instanceof EntityAnimation)) continue;
                EntityAnimation animation = (EntityAnimation)entity;
                Vec3d newPos = animation.origin.transformPointToFakeWorld(originalPos);
                if (!animation.worldBoundingBox.func_72326_a(new AxisAlignedBB(newPos, newLook = animation.origin.transformPointToFakeWorld(originalLook))) || (tempResult2 = EntityAnimation.getTarget(animation.fakeWorld, newPos, newLook, originalPos, originalLook)) == null) continue;
                double tempDistance = newPos.func_72438_d(tempResult2.getHitVec());
                if (result != null && !(tempDistance < distance)) continue;
                result = tempResult2;
                distance = tempDistance;
            }
        }
        if ((tempResult = world.func_72933_a(pos, look)) == null || tempResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return result;
        }
        tempResult.hitInfo = world;
        if (result == null || pos.func_72438_d(tempResult.field_72307_f) < distance) {
            return new LittleRayTraceResult(tempResult, world);
        }
        return result;
    }

    public boolean onRightClick(@Nullable EntityPlayer player, Vec3d pos, Vec3d look) {
        if (player != null && player.func_184614_ca().func_77973_b() instanceof ItemLittleWrench) {
            ItemLittleWrench.rightClickAnimation(this, player);
            return true;
        }
        LittleRayTraceResult result = this.getRayTraceResult(pos, look);
        if (result == null) {
            return false;
        }
        TileEntity te = result.world.func_175625_s(result.getBlockPos());
        IBlockState state = result.world.func_180495_p(result.getBlockPos());
        Vec3d hit = result.getHitVec();
        return state.func_177230_c().func_180639_a((World)this.fakeWorld, result.getBlockPos(), state, player, EnumHand.MAIN_HAND, result.result.field_178784_b, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
    }

    public boolean func_70027_ad() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void transformWorld(LittleTransformation transformation) {
        if (!(this.structure.loadTiles() && this.structure.loadChildren() && this.structure.loadParent())) {
            return;
        }
        LittleAbsolutePreviewsStructure previews = this.structure.getAbsolutePreviewsSameWorldOnly(transformation.center);
        transformation.transform(previews);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (TileEntity te : this.fakeWorld.field_147482_g) {
            if (!(te instanceof TileEntityLittleTiles)) continue;
            ((TileEntityLittleTiles)te).updateTilesSecretly(x -> x.clear());
            positions.add(te.func_174877_v());
        }
        for (BlockPos pos : positions) {
            this.fakeWorld.func_175698_g(pos);
            this.fakeWorld.func_175713_t(pos);
        }
        if (this.field_70170_p.field_72995_K) {
            this.getRenderChunkSuppilier().unloadRenderCache();
        }
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, previews.pos);
        int childId = this.structure.parent.getChildID();
        LittleStructure parentStructure = this.structure.parent.getStructure((World)this.fakeWorld);
        LittleActionPlaceStack.LittlePlaceResult result = LittleActionPlaceStack.placeTilesWithoutPlayer((World)this.fakeWorld, previews.context, splitted, previews.getStructure(), PlacementMode.all, previews.pos, null, null, null, null);
        this.structure = result.parentStructure;
        ((IAnimatedStructure)((Object)this.structure)).setAnimation(this);
        parentStructure.updateChildConnection(childId, this.structure);
        this.structure.updateParentConnection(childId, parentStructure);
        this.structure.transformAnimation(transformation);
        this.controller.transform(transformation);
        this.absolutePreviewPos = transformation.transform(this.absolutePreviewPos);
        this.updateWorldCollision();
        this.updateBoundingBox();
        this.updateTickState();
    }

    @Deprecated
    private LittleStructure searchForParent() {
        for (TileEntity te : this.fakeWorld.field_147482_g) {
            if (!(te instanceof TileEntityLittleTiles)) continue;
            for (LittleTile tile : (TileEntityLittleTiles)te) {
                if (tile.connection.isLink()) continue;
                LittleStructure structure = tile.connection.getStructureWithoutLoading();
                if (structure.parent != null && !structure.parent.isLinkToAnotherWorld()) continue;
                return structure;
            }
        }
        throw new RuntimeException("Could not find parent structure!");
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.markRemoved();
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setFakeWorld((CreativeWorld)(compound.func_74767_n("subworld") ? SubWorld.createFakeWorld((World)this.field_70170_p) : FakeWorld.createFakeWorld((String)this.func_189512_bd(), (boolean)this.field_70170_p.field_72995_K)));
        this.initalOffX = compound.func_74769_h("initOffX");
        this.initalOffY = compound.func_74769_h("initOffY");
        this.initalOffZ = compound.func_74769_h("initOffZ");
        this.initalRotX = compound.func_74769_h("initRotX");
        this.initalRotY = compound.func_74769_h("initRotY");
        this.initalRotZ = compound.func_74769_h("initRotZ");
        if (compound.func_74764_b("axis")) {
            this.setCenterVec(new LittleTilePos("axis", compound), new LittleTileVec("additional", compound));
        } else {
            this.setCenter(new StructureAbsolute("center", compound));
        }
        NBTTagList list = compound.func_150295_c("tileEntity", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            this.fakeWorld.func_175656_a(pos, BlockTile.getState(nbt.func_74762_e("stateId")));
            TileEntityLittleTiles te = (TileEntityLittleTiles)this.fakeWorld.func_175625_s(pos);
            te.func_145839_a(nbt);
            if (!this.field_70170_p.field_72995_K) continue;
            te.updateCustomRenderer();
        }
        this.fakeWorld.field_147482_g.removeIf(x -> x.func_145837_r());
        int[] array = compound.func_74759_k("previewPos");
        this.absolutePreviewPos = array.length == 3 ? new BlockPos(array[0], array[1], array[2]) : this.center.baseOffset;
        if (compound.func_74764_b("identifier")) {
            this.structureIdentifier = new LittleTileIdentifierStructureAbsolute(compound.func_74775_l("identifier"));
            try {
                this.structure = LittleAction.getTile((World)this.fakeWorld, (LittleTileIdentifierAbsolute)this.structureIdentifier).connection.getStructureWithoutLoading();
            }
            catch (LittleActionException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.structure = this.searchForParent();
            this.structureIdentifier = this.structure.getAbsoluteIdentifier();
        }
        this.controller = EntityAnimationController.parseController(this, compound.func_74775_l("controller"));
        if (compound.func_74764_b("subEntities")) {
            NBTTagList subEntities = compound.func_150295_c("subEntities", 10);
            for (int i = 0; i < subEntities.func_74745_c(); ++i) {
                Entity entity = EntityList.func_75615_a((NBTTagCompound)subEntities.func_150305_b(i), (World)this.fakeWorld);
                if (entity == null) continue;
                this.fakeWorld.func_72838_d(entity);
            }
        }
        this.updateWorldCollision();
        this.updateBoundingBox();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        this.center.writeToNBT("center", compound);
        compound.func_74780_a("initOffX", this.initalOffX);
        compound.func_74780_a("initOffY", this.initalOffY);
        compound.func_74780_a("initOffZ", this.initalOffZ);
        compound.func_74780_a("initRotX", this.initalRotX);
        compound.func_74780_a("initRotY", this.initalRotY);
        compound.func_74780_a("initRotZ", this.initalRotZ);
        compound.func_74757_a("subworld", this.fakeWorld.hasParent());
        NBTTagList list = new NBTTagList();
        for (TileEntity te : this.fakeWorld.field_147482_g) {
            if (!(te instanceof TileEntityLittleTiles)) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("stateId", BlockTile.getStateId((TileEntityLittleTiles)te));
            list.func_74742_a((NBTBase)te.func_189515_b(nbt));
        }
        compound.func_74782_a("controller", (NBTBase)this.controller.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("tileEntity", (NBTBase)list);
        compound.func_74783_a("previewPos", new int[]{this.absolutePreviewPos.func_177958_n(), this.absolutePreviewPos.func_177956_o(), this.absolutePreviewPos.func_177952_p()});
        compound.func_74782_a("identifier", (NBTBase)this.structureIdentifier.writeToNBT(new NBTTagCompound()));
        if (!this.fakeWorld.field_72996_f.isEmpty()) {
            NBTTagList subEntities = new NBTTagList();
            for (Entity entity : this.fakeWorld.field_72996_f) {
                NBTTagCompound nbt = new NBTTagCompound();
                entity.func_184198_c(nbt);
                subEntities.func_74742_a((NBTBase)nbt);
            }
            compound.func_74782_a("subEntities", (NBTBase)subEntities);
        }
    }
}

