/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.events;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.client.render.entity.RenderAnimation;
import com.creativemd.littletiles.client.render.overlay.PreviewRenderer;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleEntityRequestPacket;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleDoorHandler {
    public static LittleDoorHandler client;
    public static LittleDoorHandler server;
    public final Side side;
    protected List<EntityAnimation> toBeAdded = new ArrayList<EntityAnimation>();
    protected boolean isTicking = false;
    public List<EntityAnimation> openDoors = new CopyOnWriteArrayList<EntityAnimation>();
    @SideOnly(value=Side.CLIENT)
    public static RenderAnimation render;
    @SideOnly(value=Side.CLIENT)
    private EntityPlayer lastPlayerRayTraceResult;
    @SideOnly(value=Side.CLIENT)
    private RayTraceResult lastRayTraceResult;
    @SideOnly(value=Side.CLIENT)
    private CreativeWorld lastWorldRayTraceResult;
    private static Field wasPushedByDoor;

    public static LittleDoorHandler getHandler(boolean client) {
        if (client) {
            return LittleDoorHandler.client;
        }
        return server;
    }

    public LittleDoorHandler(Side side) {
        this.side = side;
    }

    public List<EntityAnimation> findDoors(World world, AxisAlignedBB bb) {
        if (this.openDoors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAnimation> doors = new ArrayList<EntityAnimation>();
        for (EntityAnimation door : this.openDoors) {
            if (!door.func_174813_aQ().func_72326_a(bb)) continue;
            doors.add(door);
        }
        return doors;
    }

    public List<LittleDoor> findDoors(World world, BlockPos pos) {
        if (this.openDoors.isEmpty()) {
            return Collections.emptyList();
        }
        AxisAlignedBB box = new AxisAlignedBB(pos);
        ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
        for (EntityAnimation door : this.openDoors) {
            if (door.field_70170_p != world || !(door.structure instanceof LittleDoor) || !door.func_174813_aQ().func_72326_a(box) || doors.contains(door.structure)) continue;
            doors.add(((LittleDoor)door.structure).getParentDoor());
        }
        return doors;
    }

    public EntityAnimation findDoor(UUID uuid) {
        for (EntityAnimation animation : this.openDoors) {
            if (!animation.func_110124_au().equals(uuid)) continue;
            return animation;
        }
        return null;
    }

    public void createDoor(EntityAnimation door) {
        if (this.isTicking) {
            this.toBeAdded.add(door);
        } else {
            this.openDoors.add(door);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.side == this.side && event.phase == TickEvent.Phase.END) {
            World world = event.world;
            this.openDoors.addAll(this.toBeAdded);
            this.toBeAdded.clear();
            this.isTicking = true;
            for (EntityAnimation door : this.openDoors) {
                if (door.field_70170_p != world || door.field_70170_p instanceof CreativeWorld) continue;
                door.onUpdateForReal();
            }
            this.openDoors.removeIf(x -> {
                if (x.field_70128_L) {
                    x.markRemoved();
                    return true;
                }
                return false;
            });
            this.isTicking = false;
        }
    }

    @SubscribeEvent
    public void trackEntity(PlayerEvent.StartTracking event) {
        if (this.side.isClient()) {
            return;
        }
        if (event.getTarget() instanceof EntityAnimation && ((EntityAnimation)event.getTarget()).controller.activator() != event.getEntityPlayer()) {
            EntityAnimation animation = (EntityAnimation)event.getTarget();
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(animation.func_110124_au(), animation.func_189511_e(new NBTTagCompound()), animation.enteredAsChild), (EntityPlayerMP)((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTick() {
        if (render == null) {
            render = new RenderAnimation(Minecraft.func_71410_x().func_175598_ae());
        }
        float partialTicks = TickUtils.getPartialTickTime();
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (renderViewEntity == null || LittleDoorHandler.client.openDoors.isEmpty()) {
            return;
        }
        double camX = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double camY = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double camZ = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        TileEntityRendererDispatcher.field_147554_b = camX;
        TileEntityRendererDispatcher.field_147555_c = camY;
        TileEntityRendererDispatcher.field_147552_d = camZ;
        Frustum camera = new Frustum();
        camera.func_78547_a(camX, camY, camZ);
        for (EntityAnimation door : LittleDoorHandler.client.openDoors) {
            if (!render.func_177071_a(door, (ICamera)camera, camX, camY, camZ) || door.field_70128_L) continue;
            if (door.field_70173_aa == 0) {
                door.field_70142_S = door.field_70165_t;
                door.field_70137_T = door.field_70163_u;
                door.field_70136_U = door.field_70161_v;
            }
            double d0 = door.field_70142_S + (door.field_70165_t - door.field_70142_S) * (double)partialTicks;
            double d1 = door.field_70137_T + (door.field_70163_u - door.field_70137_T) * (double)partialTicks;
            double d2 = door.field_70136_U + (door.field_70161_v - door.field_70136_U) * (double)partialTicks;
            float f = door.field_70126_B + (door.field_70177_z - door.field_70126_B) * partialTicks;
            int i = door.func_70070_b();
            if (door.func_70027_ad()) {
                i = 0xF000F0;
            }
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                render.doRender(door, d0 - camX, d1 - camY, d2 - camZ, f, partialTicks);
            }
            catch (Throwable throwable1) {
                throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
            }
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            Entity selectedEntity;
            double d0;
            if (!event.getWorld().field_72995_K) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayer entity = event.getEntityPlayer();
            Vec3d vec3d = entity.func_174824_e(TickUtils.getPartialTickTime());
            double d1 = d0 = (double)mc.field_71442_b.func_78757_d();
            boolean flag = false;
            if (mc.field_71442_b.func_78749_i()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            if (mc.field_71476_x != null) {
                d1 = mc.field_71476_x.field_72307_f.func_72438_d(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i(TickUtils.getPartialTickTime());
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
            EntityAnimation pointedEntity = null;
            Vec3d vec3d3 = null;
            float f = 1.0f;
            List<EntityAnimation> list = this.findDoors(entity.field_70170_p, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0).func_72314_b(1.0, 1.0, 1.0));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                EntityAnimation entity1 = list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == entity.func_184208_bv() && !entity1.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && flag && vec3d.func_72438_d(vec3d3) > 3.0) {
                return;
            }
            Entity entity2 = selectedEntity = mc.field_71476_x != null ? mc.field_71476_x.field_72308_g : null;
            if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
                selectedEntity = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget();
            } else if (event instanceof PlayerInteractEvent.EntityInteract) {
                selectedEntity = ((PlayerInteractEvent.EntityInteract)event).getTarget();
            }
            if (pointedEntity == null && selectedEntity instanceof EntityAnimation) {
                pointedEntity = (EntityAnimation)selectedEntity;
            }
            if (pointedEntity != null && (d2 < d1 || mc.field_71476_x == null || selectedEntity == pointedEntity) && pointedEntity.onRightClick(entity, vec3d, vec3d2) && event instanceof PlayerInteractEvent.RightClickBlock) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (!(event.side != this.side || event.phase != TickEvent.Phase.END || Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().func_147113_T())) {
            for (EntityAnimation door : this.openDoors) {
                if (door.field_70170_p instanceof CreativeWorld) continue;
                door.onUpdateForReal();
            }
            this.openDoors.removeIf(x -> {
                if (x.field_70128_L) {
                    x.markRemoved();
                    return true;
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        if (event.getWorld().field_72995_K != this.side.isClient()) {
            return;
        }
        this.openDoors.removeIf(x -> {
            if (x.field_70128_L) {
                x.markRemoved();
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K != this.side.isClient()) {
            return;
        }
        this.openDoors.removeIf(x -> {
            if (x.field_70170_p == event.getWorld()) {
                x.markRemoved();
                return true;
            }
            return false;
        });
        if (this.side.isClient()) {
            this.lastPlayerRayTraceResult = null;
            this.lastRayTraceResult = null;
            this.lastWorldRayTraceResult = null;
        }
    }

    @SubscribeEvent
    public void worldCollision(GetCollisionBoxesEvent event) {
        if (event.getWorld().field_72995_K != this.side.isClient()) {
            return;
        }
        AxisAlignedBB box = event.getAabb();
        for (EntityAnimation animation : this.findDoors(event.getWorld(), box)) {
            if (animation.noCollision) continue;
            OrientatedBoundingBox newAlignedBox = animation.origin.getOrientatedBox(box);
            for (OrientatedBoundingBox bb : animation.worldCollisionBoxes) {
                if (!bb.func_72326_a((AxisAlignedBB)newAlignedBox)) continue;
                event.getCollisionBoxesList().add(bb);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public RayTraceResult getRayTraceResult(EntityPlayer player, float partialTicks, @Nullable RayTraceResult target) {
        if (this.lastPlayerRayTraceResult == player) {
            return this.lastRayTraceResult;
        }
        Vec3d pos = player.func_174824_e(partialTicks);
        double d0 = target != null ? pos.func_72438_d(target.field_72307_f) : (player.field_71075_bZ.field_75098_d ? 5.0 : 4.5);
        Vec3d look = player.func_70676_i(partialTicks);
        look = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        AxisAlignedBB box = new AxisAlignedBB(pos, target != null ? target.field_72307_f : look);
        World world = player.field_70170_p;
        RayTraceResult result = target;
        double distance = result != null ? pos.func_72438_d(result.field_72307_f) : 0.0;
        for (EntityAnimation animation : this.findDoors(world, box)) {
            RayTraceResult tempResult = LittleDoorHandler.getTarget(animation.fakeWorld, animation.origin.transformPointToFakeWorld(pos), animation.origin.transformPointToFakeWorld(look), pos, look);
            if (tempResult == null || tempResult.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            double tempDistance = pos.func_72438_d(animation.origin.transformPointToWorld(tempResult.field_72307_f));
            if (result != null && !(tempDistance < distance)) continue;
            result = tempResult;
            distance = tempDistance;
        }
        this.lastPlayerRayTraceResult = player;
        if (result == target) {
            result = null;
        }
        this.lastRayTraceResult = result;
        this.lastWorldRayTraceResult = result != null ? (CreativeWorld)result.hitInfo : null;
        return result;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderLast(RenderWorldLastEvent event) {
        if (this.side.isServer()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74319_N) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        float partialTicks = event.getPartialTicks();
        this.lastPlayerRayTraceResult = null;
        this.lastRayTraceResult = null;
        this.lastWorldRayTraceResult = null;
        RayTraceResult result = this.getRayTraceResult((EntityPlayer)player, event.getPartialTicks(), mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK ? mc.field_71476_x : null);
        if (result == null) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179098_w();
        mc.field_71446_o.func_110577_a(PreviewRenderer.WHITE_TEXTURE);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179091_B();
        BlockPos blockpos = result.func_178782_a();
        IBlockState iblockstate = this.lastWorldRayTraceResult.func_180495_p(blockpos);
        if (iblockstate.func_185904_a() != Material.field_151579_a && this.lastWorldRayTraceResult.func_175723_af().func_177746_a(blockpos)) {
            EntityAnimation entity = (EntityAnimation)this.lastWorldRayTraceResult.parent;
            GlStateManager.func_179094_E();
            entity.origin.setupRendering((Entity)entity, partialTicks);
            RenderGlobal.func_189697_a((AxisAlignedBB)iblockstate.func_185918_c((World)this.lastWorldRayTraceResult, blockpos).func_186662_g((double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        if (this.getRayTraceResult(this.lastPlayerRayTraceResult, event.getPartialTicks(), event.getTarget()) != null) {
            event.setCanceled(true);
        }
    }

    public static RayTraceResult getTarget(CreativeWorld world, Vec3d pos, Vec3d look, Vec3d originalPos, Vec3d originalLook) {
        RayTraceResult tempResult = world.func_72933_a(pos, look);
        if (tempResult == null || tempResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        tempResult.hitInfo = world;
        return tempResult;
    }

    public static void setPushedByDoor(EntityPlayerMP player) {
        try {
            wasPushedByDoor.setInt(player, 10);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkIfEmpty(List<AxisAlignedBB> boxes, EntityPlayerMP player) {
        try {
            if (wasPushedByDoor.getInt(player) > 0) {
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (boxes.isEmpty()) {
            return true;
        }
        for (int i = 0; i < boxes.size(); ++i) {
            if (boxes.get(i) instanceof OrientatedBoundingBox) continue;
            return false;
        }
        return true;
    }

    static {
        wasPushedByDoor = ReflectionHelper.findField(EntityPlayerMP.class, (String[])new String[]{"wasPushedByDoor"});
    }
}

