/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.SubGuiHammer;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiGridSelector;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.api.IBoxSelector;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.selection.selector.TileSelector;
import com.creativemd.littletiles.common.utils.shape.SelectShape;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHammer
extends Item
implements IBoxSelector {
    private static boolean activeFilter = false;
    private static TileSelector currentFilter = null;

    public static boolean isFiltered() {
        return activeFilter;
    }

    public static void setFilter(boolean active, TileSelector filter) {
        activeFilter = active;
        currentFilter = filter;
    }

    public static TileSelector getFilter() {
        return currentFilter;
    }

    public ItemHammer() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("can be used to chisel blocks");
        SelectShape shape = ItemHammer.getShape(stack);
        tooltip.add("mode: " + shape.key);
        shape.addExtraInformation(worldIn, stack.func_77978_p(), tooltip, this.getContext(stack));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (!world.field_72995_K) {
            GuiHandler.openGuiItem((EntityPlayer)player, (World)world);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public LittleBoxes getBox(World world, ItemStack stack, EntityPlayer player, RayTraceResult result, LittleTilePos absoluteHit) {
        SelectShape shape = ItemHammer.getShape(stack);
        return shape.getHighlightBoxes(player, stack.func_77978_p(), result, this.getContext(stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClickBlock(World world, ItemStack stack, EntityPlayer player, RayTraceResult result, LittleTilePos absoluteHit) {
        SelectShape shape = ItemHammer.getShape(stack);
        if (shape.leftClick(player, stack.func_77978_p(), result, this.getContext(stack))) {
            if (ItemHammer.isFiltered()) {
                new LittleActionDestroyBoxes.LittleActionDestroyBoxesFiltered(shape.getBoxes(player, stack.func_77978_p(), result, this.getContext(stack)), ItemHammer.getFilter()).execute();
            } else {
                new LittleActionDestroyBoxes(shape.getBoxes(player, stack.func_77978_p(), result, this.getContext(stack))).execute();
            }
        }
        return true;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @Override
    public void onDeselect(World world, ItemStack stack, EntityPlayer player) {
        ItemHammer.getShape(stack).deselect(player, stack.func_77978_p(), this.getContext(stack));
    }

    @Override
    public boolean hasCustomBox(World world, ItemStack stack, EntityPlayer player, IBlockState state, RayTraceResult result, LittleTilePos absoluteHit) {
        return LittleAction.isBlockValid(state) || world.func_175625_s(result.func_178782_a()) instanceof TileEntityLittleTiles;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return new SubGuiHammer(stack);
    }

    @Override
    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @Override
    public void rotateLittlePreview(ItemStack stack, Rotation rotation) {
        SelectShape shape = ItemHammer.getShape(stack);
        if (shape != null) {
            shape.rotate(rotation, stack.func_77978_p());
        }
    }

    @Override
    public void flipLittlePreview(ItemStack stack, EnumFacing.Axis axis) {
        SelectShape shape = ItemHammer.getShape(stack);
        if (shape != null) {
            shape.flip(axis, stack.func_77978_p());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiGridSelector(stack, ItemMultiTiles.currentContext, ItemHammer.isFiltered(), ItemHammer.getFilter()){

            @Override
            public void saveConfiguration(LittleGridContext context, boolean activeFilter, TileSelector selector) {
                ItemHammer.setFilter(activeFilter, selector);
                ItemMultiTiles.currentContext = context;
            }
        };
    }

    public static SelectShape getShape(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return SelectShape.getShape(stack.func_77978_p().func_74779_i("shape"));
    }

    @Override
    public LittleGridContext getContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }
}

