/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.mods.warpdrive;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.structure.connection.StructureLinkBaseRelative;
import com.creativemd.littletiles.common.structure.connection.StructureLinkTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierRelative;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.vec.LittleBlockTransformer;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TileEntityLittleTilesTransformer
implements IBlockTransformer {
    public static void init() {
        try {
            Class<?> clazz = Class.forName("cr0s.warpdrive.config.WarpDriveConfig");
            clazz.getMethod("registerBlockTransformer", String.class, IBlockTransformer.class).invoke(null, "littletiles", new TileEntityLittleTilesTransformer());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return tileEntity instanceof TileEntityLittleTiles;
    }

    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
        NBTTagCompound nbt = new NBTTagCompound();
        ArrayList<StructureLinkTile> connectors = new ArrayList<StructureLinkTile>();
        for (LittleTile tile : te) {
            if (!tile.isChildOfStructure() || !tile.isConnectedToStructure() || !(tile.connection instanceof LittleTileIdentifierRelative) || connectors.contains(tile.connection)) continue;
            connectors.add((StructureLinkTile)tile.connection);
        }
        NBTTagList list = new NBTTagList();
        for (StructureLinkTile connector : connectors) {
            NBTTagCompound connectNBT = connector.writeToNBT(new NBTTagCompound());
            connectNBT.func_74783_a("mainTileBox", connector.getStructure((World)world).getMainTile().box.getArray());
            connectNBT.func_74768_a("mainTileContext", connector.getStructure((World)world).getMainTile().getContext().size);
            list.func_74742_a((NBTBase)connectNBT);
        }
        nbt.func_74782_a("connectors", (NBTBase)list);
        return nbt;
    }

    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        int rotationStep;
        int rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return;
        }
        Rotation rotation = Rotation.Y_COUNTER_CLOCKWISE;
        int count = rotationSteps;
        if (rotationSteps == 3) {
            count = 1;
            rotation = Rotation.Y_CLOCKWISE;
        }
        TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
        NBTTagCompound nbt = (NBTTagCompound)nbtBase;
        ArrayList<LittleTileIdentifierRelative> connectors = new ArrayList<LittleTileIdentifierRelative>();
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
        ArrayList<LittleGridContext> contextes = new ArrayList<LittleGridContext>();
        NBTTagList list = nbt.func_150295_c("connectors", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound connectorNBT = list.func_150305_b(i);
            connectors.add(new LittleTileIdentifierRelative(connectorNBT));
            LittleTileBox box = LittleTileBox.createBox(connectorNBT.func_74759_k("mainTileBox"));
            LittleGridContext context = LittleGridContext.get(connectorNBT.func_74762_e("mainTileContext"));
            for (rotationStep = 0; rotationStep < count; ++rotationStep) {
                box.rotateBox(rotation, context.rotationCenter);
            }
            boxes.add(box);
            contextes.add(context);
        }
        for (LittleTile tile : te) {
            if (!tile.isChildOfStructure() || !(tile.connection instanceof StructureLinkBaseRelative)) continue;
            int index = connectors.indexOf(tile.connection);
            if (index != -1) {
                StructureLinkBaseRelative connect = (StructureLinkBaseRelative)tile.connection;
                for (rotationStep = 0; rotationStep < count; ++rotationStep) {
                    connect.coord = new BlockPos((Vec3i)RotationUtils.rotate((BlockPos)connect.coord, (Rotation)rotation));
                }
                connect.identifier = ((LittleTileBox)boxes.get(index)).getIdentifier();
                connect.context = (LittleGridContext)contextes.get(index);
                continue;
            }
            System.out.println("Could not find rotated connection ...");
        }
        te.updateTiles();
    }

    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        TileEntityLittleTiles te = (TileEntityLittleTiles)TileEntity.func_190200_a((World)transformation.getTargetWorld(), (NBTTagCompound)nbtTileEntity);
        Rotation rotation = Rotation.Y_COUNTER_CLOCKWISE;
        byte count = rotationSteps;
        if (rotationSteps == 3) {
            count = 1;
            rotation = Rotation.Y_CLOCKWISE;
        }
        LittleBlockTransformer.rotateTE(te, rotation, count, false);
        te.func_189515_b(nbtTileEntity);
        return metadata;
    }
}

