/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiDoorEvents;
import com.creativemd.littletiles.client.render.world.LittleRenderChunkSuppilier;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleActivateDoorPacket;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.type.door.LittleAdvancedDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleAxisDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorActivator;
import com.creativemd.littletiles.common.structure.type.door.LittleSlidingDoor;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.utils.animation.AnimationKey;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import com.creativemd.littletiles.common.utils.animation.ValueTimeline;
import com.creativemd.littletiles.common.utils.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.utils.animation.event.ChildActivateEvent;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.vec.LittleTransformation;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleDoorBase
extends LittleDoor
implements IAnimatedStructure {
    public int duration = 50;
    public boolean stayAnimated = false;
    public List<AnimationEvent> events = new ArrayList<AnimationEvent>();
    public EntityAnimation animation;

    public LittleDoorBase(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.events = new ArrayList<AnimationEvent>();
        NBTTagList list = nbt.func_150295_c("events", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.events.add(AnimationEvent.loadFromNBT(list.func_150305_b(i)));
        }
        this.duration = nbt.func_74764_b("duration") ? nbt.func_74762_e("duration") : 50;
        this.stayAnimated = nbt.func_74767_n("stayAnimated");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        NBTTagList list = new NBTTagList();
        for (AnimationEvent event : this.events) {
            list.func_74742_a((NBTBase)event.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("events", (NBTBase)list);
        nbt.func_74768_a("duration", this.duration);
        if (this.stayAnimated) {
            nbt.func_74757_a("stayAnimated", this.stayAnimated);
        }
    }

    public abstract LittleTransformation[] getDoorTransformations(@Nullable EntityPlayer var1);

    public abstract void transformDoorPreview(LittleAbsolutePreviewsStructure var1, LittleTransformation var2);

    public LittleAbsolutePreviewsStructure getDoorPreviews(LittleTransformation transformation) {
        LittleAbsolutePreviewsStructure previews = this.getAbsolutePreviewsSameWorldOnly(transformation.center);
        this.transformDoorPreview(previews, transformation);
        transformation.transform(previews);
        return previews;
    }

    @Override
    public void beforeTick(EntityAnimation animation, int tick) {
        super.beforeTick(animation, tick);
        DoorController controller = (DoorController)animation.controller;
        for (AnimationEvent event : this.events) {
            if (!event.shouldBeProcessed(tick)) continue;
            event.process(controller);
        }
    }

    @Override
    public void onFinished(EntityAnimation animation) {
        int duration = this.getCompleteDuration();
        for (AnimationEvent event : this.events) {
            event.invert(this, duration);
        }
        this.events.sort(null);
    }

    @Override
    public void sendActivationToClient(EntityPlayer activator, UUID uuid, LittleDoor.DoorOpeningResult result) {
        super.sendActivationToClient(activator, uuid, result);
        if (this.isAnimated()) {
            PacketHandler.sendPacketToTrackingPlayersExcept((CreativeCorePacket)new LittleActivateDoorPacket(this.getMainTile(), uuid, result), (Entity)this.getAnimation(), (EntityPlayer)activator, (WorldServer)((WorldServer)this.getAnimation().fakeWorld.getRealWorld()));
        }
    }

    @Override
    public int getCompleteDuration() {
        int duration = this.duration;
        for (AnimationEvent event : this.events) {
            duration = Math.max(duration, event.getMinimumRequiredDuration(this));
        }
        return duration;
    }

    @Override
    public List<LittleDoor> collectDoorsToCheck() {
        ArrayList<Integer> children = new ArrayList<Integer>();
        for (AnimationEvent event : this.events) {
            if (!(event instanceof ChildActivateEvent) || children.contains(((ChildActivateEvent)event).childId)) continue;
            children.add(((ChildActivateEvent)event).childId);
        }
        ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
        if (children.isEmpty()) {
            return doors;
        }
        for (Integer integer : children) {
            doors.add((LittleDoor)((IStructureChildConnector)this.children.get(integer)).getStructure(this.getWorld()));
        }
        return doors;
    }

    @Override
    public LittleDoor.DoorOpeningResult canOpenDoor(@Nullable EntityPlayer player) {
        LittleTransformation[] transformations;
        LittleDoor.DoorOpeningResult result = super.canOpenDoor(player);
        if (result == null) {
            return null;
        }
        for (AnimationEvent event : this.events) {
            event.reset();
        }
        if (this.isAnimated()) {
            return result;
        }
        for (LittleTransformation transformation : transformations = this.getDoorTransformations(player)) {
            ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
            LittleAbsolutePreviewsStructure previews = this.getDoorPreviews(transformation);
            previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
            HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, previews.pos);
            if (!LittleActionPlaceStack.canPlaceTiles(player, this.getWorld(), splitted, PlacementMode.all.getCoordsToCheck(splitted, previews.pos), PlacementMode.all, x -> !x.isChildOfStructure(this), true)) continue;
            if (transformations.length == 1) {
                return result;
            }
            if (result.isEmpty()) {
                result = new LittleDoor.DoorOpeningResult(new NBTTagCompound());
            }
            result.nbt.func_74783_a("transform", transformation.array());
            return result;
        }
        return null;
    }

    public EntityAnimation place(World world, @Nullable EntityPlayer player, LittleAbsolutePreviewsStructure previews, DoorController controller, UUID uuid, StructureAbsolute absolute, LittleTransformation transformation, boolean tickOnce) {
        LittleActionPlaceStack.LittlePlaceResult result;
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, previews.pos);
        ArrayList blocks = new ArrayList();
        SubWorld fakeWorld = SubWorld.createFakeWorld((World)world);
        if (world.field_72995_K) {
            fakeWorld.renderChunkSupplier = new LittleRenderChunkSuppilier();
        }
        if ((result = LittleActionPlaceStack.placeTilesWithoutPlayer((World)fakeWorld, previews.context, splitted, previews.getStructure(), PlacementMode.all, previews.pos, null, null, null, null)) == null) {
            throw new RuntimeException("Something went wrong during placing the door!");
        }
        controller.activator = player;
        if (world.field_72995_K) {
            controller.markWaitingForApprove();
            for (TileEntityLittleTiles te : this.tiles.keySet()) {
                if (te.waitingAnimation == null) continue;
                te.clearWaitingAnimations();
            }
        }
        LittleStructure newDoor = previews.getStructure();
        EntityAnimation animation = new EntityAnimation(world, (CreativeWorld)fakeWorld, controller, previews.pos, uuid, absolute, newDoor.getAbsoluteIdentifier());
        newDoor.transferChildrenToAnimation(animation);
        newDoor.transformAnimation(transformation);
        if (this.parent != null) {
            LittleStructure parentStructure = this.parent.getStructure(world);
            parentStructure.updateChildConnection(this.parent.getChildID(), newDoor);
            newDoor.updateParentConnection(this.parent.getChildID(), parentStructure);
        }
        world.func_72838_d((Entity)animation);
        if (tickOnce) {
            animation.onUpdateForReal();
        }
        return animation;
    }

    @Override
    public boolean canOpenDoor(@Nullable EntityPlayer player, LittleDoor.DoorOpeningResult result) {
        if (!super.canOpenDoor(player, result)) {
            return false;
        }
        LittleTransformation transform = !result.isEmpty() && result.nbt.func_74764_b("transform") ? new LittleTransformation(result.nbt.func_74759_k("transform")) : this.getDoorTransformations(player)[0];
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        LittleAbsolutePreviewsStructure previews = this.getDoorPreviews(transform);
        previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, previews.pos);
        return LittleActionPlaceStack.canPlaceTiles(player, this.getWorld(), splitted, PlacementMode.all.getCoordsToCheck(splitted, previews.pos), PlacementMode.all, x -> !x.isChildOfStructure(this), true);
    }

    @Override
    public EntityAnimation openDoor(@Nullable EntityPlayer player, UUIDSupplier uuid, LittleDoor.DoorOpeningResult result, boolean tickOnce) {
        if (this.isAnimated()) {
            ((DoorController)this.animation.controller).activate();
            if (tickOnce) {
                this.animation.onUpdateForReal();
            }
            return this.animation;
        }
        LittleTransformation transform = !result.isEmpty() && result.nbt.func_74764_b("transform") ? new LittleTransformation(result.nbt.func_74759_k("transform")) : this.getDoorTransformations(player)[0];
        LittleAbsolutePreviewsStructure previews = this.getDoorPreviews(transform);
        StructureAbsolute absolute = this.getAbsoluteAxis();
        HashMapList<TileEntityLittleTiles, LittleTile> allTilesFromWorld = this.getAllTilesSameWorld((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        for (Map.Entry entry : allTilesFromWorld.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).updateTilesSecretly(x -> x.removeAll((Collection)entry.getValue()));
        }
        EntityAnimation animation = this.place(this.getWorld(), player, previews, this.createController(result, uuid, previews, transform, this.getCompleteDuration()), uuid.next(), absolute, transform, tickOnce);
        World world = this.getWorld();
        if (!world.field_72995_K && world instanceof WorldServer) {
            for (TileEntityLittleTiles te : allTilesFromWorld.keySet()) {
                ((WorldServer)world).func_184164_w().func_180244_a(te.func_174877_v());
            }
        }
        return animation;
    }

    public abstract DoorController createController(LittleDoor.DoorOpeningResult var1, UUIDSupplier var2, LittleAbsolutePreviewsStructure var3, LittleTransformation var4, int var5);

    public abstract StructureAbsolute getAbsoluteAxis();

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public boolean isInMotion() {
        return this.animation != null && this.animation.controller.isChanging();
    }

    @Override
    public boolean isAnimated() {
        return this.animation != null;
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    protected void fillActivateChildren(BitSet set) {
        for (AnimationEvent event : this.events) {
            if (!(event instanceof ChildActivateEvent)) continue;
            set.set(((ChildActivateEvent)event).childId);
        }
    }

    public static void initDoors() {
        LittleStructureRegistry.registerStructureType("door", "door", LittleAxisDoor.class, LittleStructureAttribute.NONE, LittleAxisDoor.LittleAxisDoorParser.class);
        LittleStructureRegistry.registerStructureType("slidingDoor", "door", LittleSlidingDoor.class, LittleStructureAttribute.NONE, LittleSlidingDoor.LittleSlidingDoorParser.class);
        LittleStructureRegistry.registerStructureType("advancedDoor", "door", LittleAdvancedDoor.class, LittleStructureAttribute.NONE, LittleAdvancedDoor.LittleAdvancedDoorParser.class);
        LittleStructureRegistry.registerStructureType("doorActivator", "door", LittleDoorActivator.class, LittleStructureAttribute.NONE, LittleDoorActivator.LittleDoorActivatorParser.class);
    }

    public static abstract class LittleDoorBaseParser
    extends LittleStructureGuiParser {
        public LittleDoorBaseParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        @CustomEventSubscribe
        public void onChanged(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"duration_s"}) || event.source.is(new String[]{"children_activate"})) {
                this.updateTimeline();
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            this.parent.controls.add(new GuiCheckBox("stayAnimated", CoreControl.translate((String)"gui.door.stayAnimated"), 0, 120, structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).stayAnimated : false).setCustomTooltip(new String[]{CoreControl.translate((String)"gui.door.stayAnimatedTooltip")}));
            this.parent.controls.add(new GuiLabel(CoreControl.translate((String)"gui.door.duration") + ":", 90, 122));
            this.parent.controls.add(new GuiSteppedSlider("duration_s", 140, 122, 50, 6, structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).duration : 50, 1, 500));
            this.parent.controls.add(new SubGuiDoorEvents.GuiDoorEventsButton("children_activate", 93, 107, previews, structure instanceof LittleDoorBase ? (LittleDoorBase)structure : null));
            this.updateTimeline();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleDoorBase parseStructure(LittlePreviews previews) {
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("duration_s");
            GuiCheckBox checkBox = (GuiCheckBox)this.parent.get("stayAnimated");
            SubGuiDoorEvents.GuiDoorEventsButton button = (SubGuiDoorEvents.GuiDoorEventsButton)this.parent.get("children_activate");
            int duration = (int)slider.value;
            boolean stayAnimated = checkBox.value;
            LittleDoorBase door = this.parseStructure();
            door.duration = duration;
            door.stayAnimated = stayAnimated;
            door.events = button.events;
            return door;
        }

        @SideOnly(value=Side.CLIENT)
        public abstract LittleDoorBase parseStructure();

        @SideOnly(value=Side.CLIENT)
        public abstract void populateTimeline(AnimationTimeline var1);

        public void updateTimeline() {
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("duration_s");
            AnimationTimeline timeline = new AnimationTimeline((int)slider.value, (PairList<AnimationKey, ValueTimeline>)new PairList());
            SubGuiDoorEvents.GuiDoorEventsButton children = (SubGuiDoorEvents.GuiDoorEventsButton)this.parent.get("children_activate");
            this.populateTimeline(timeline);
            this.handler.setTimeline(timeline, children.events);
        }
    }
}

