/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.littletiles.common.tiles.LittleTile;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileList
implements List<LittleTile> {
    private final CopyOnWriteArrayList<LittleTile> content = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<LittleTile> ticking = new CopyOnWriteArrayList();
    @SideOnly(value=Side.CLIENT)
    private CopyOnWriteArrayList<LittleTile> render;
    private int collisionChecks = 0;
    private final boolean client;

    public TileList(boolean client) {
        this.client = client;
        if (client) {
            this.render = new CopyOnWriteArrayList();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<LittleTile> getRenderTiles() {
        return this.render;
    }

    @Override
    public boolean contains(Object o) {
        return this.content.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.content.containsAll(c);
    }

    public List<LittleTile> getTickingTiles() {
        return this.ticking;
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public boolean hasTicking() {
        return !this.ticking.isEmpty();
    }

    public boolean hasRendered() {
        if (this.client) {
            return !this.render.isEmpty();
        }
        for (LittleTile tile : this.content) {
            if (!tile.needCustomRendering()) continue;
            return true;
        }
        return false;
    }

    public boolean checkCollision() {
        return this.collisionChecks > 0;
    }

    public LittleTile first() {
        return this.isEmpty() ? null : this.content.get(0);
    }

    private void reset() {
        this.ticking.clear();
        if (this.client) {
            this.render.clear();
        }
        this.collisionChecks = 0;
    }

    @Override
    public boolean add(LittleTile e) {
        this.content.add(e);
        this.added(e);
        return true;
    }

    @Override
    public void add(int index, LittleTile element) {
        this.content.add(index, element);
        this.added(element);
    }

    @Override
    public boolean addAll(Collection<? extends LittleTile> c) {
        if (this.content.addAll(c)) {
            for (LittleTile littleTile : c) {
                this.added(littleTile);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends LittleTile> c) {
        if (this.content.addAll(index, c)) {
            for (LittleTile littleTile : c) {
                this.added(littleTile);
            }
            return true;
        }
        return false;
    }

    private void added(LittleTile tile) {
        if (tile.shouldTick()) {
            this.ticking.add(tile);
        }
        if (this.client && tile.needCustomRendering()) {
            this.render.add(tile);
        }
        if (tile.shouldCheckForCollision()) {
            ++this.collisionChecks;
        }
    }

    @Override
    public LittleTile remove(int index) {
        LittleTile tile = this.content.remove(index);
        if (tile != null) {
            this.removed(tile);
        }
        return tile;
    }

    private void removed(LittleTile tile) {
        this.ticking.remove(tile);
        if (this.client) {
            this.render.remove(tile);
        }
        if (tile.shouldCheckForCollision()) {
            --this.collisionChecks;
        }
    }

    @Override
    public boolean remove(Object o) {
        if (this.content.remove(o)) {
            this.removed((LittleTile)o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super LittleTile> filter) {
        if (this.content.removeIf(filter)) {
            this.reset();
            for (LittleTile tile : this.content) {
                this.added(tile);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.content.clear();
        this.reset();
    }

    @Override
    public Iterator<LittleTile> iterator() {
        return this.content.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.content.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.content.toArray(a);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.content.retainAll(c)) {
            this.reset();
            for (LittleTile tile : this.content) {
                this.added(tile);
            }
            return true;
        }
        return false;
    }

    @Override
    public LittleTile get(int index) {
        return this.content.get(index);
    }

    @Override
    public LittleTile set(int index, LittleTile element) {
        LittleTile tile = this.remove(index);
        this.removed(tile);
        this.content.set(index, element);
        this.added(element);
        return tile;
    }

    @Override
    public int indexOf(Object o) {
        return this.content.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.content.lastIndexOf(o);
    }

    @Override
    public ListIterator<LittleTile> listIterator() {
        return this.content.listIterator();
    }

    @Override
    public ListIterator<LittleTile> listIterator(int index) {
        return this.content.listIterator(index);
    }

    @Override
    public void sort(Comparator<? super LittleTile> c) {
        this.content.sort(c);
    }

    @Override
    public void replaceAll(UnaryOperator<LittleTile> operator) {
        this.content.replaceAll(operator);
        this.reset();
        for (LittleTile tile : this.content) {
            this.added(tile);
        }
    }

    @Override
    public List<LittleTile> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<LittleTile> spliterator() {
        throw new UnsupportedOperationException();
    }
}

