/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.place;

import com.creativemd.littletiles.client.render.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class PlacePreviewTileRelative
extends PlacePreviewTile {
    public LittleStructureType.StructureTypeRelative relativeType;
    public StructureRelative relative;

    public PlacePreviewTileRelative(LittleTileBox box, LittlePreviews structure, StructureRelative relative, LittleStructureType.StructureTypeRelative relativeType) {
        super(box.copy(), null, structure);
        this.relative = relative;
        this.relativeType = relativeType;
    }

    @Override
    public boolean needsCollisionTest() {
        return false;
    }

    @Override
    public boolean requiresSplit() {
        return false;
    }

    @Override
    public PlacePreviewTile copy() {
        return new PlacePreviewTileRelative(this.box.copy(), this.structurePreview, this.relative, this.relativeType);
    }

    @Override
    public List<LittleRenderingCube> getPreviews(LittleGridContext context) {
        List<LittleRenderingCube> cubes = super.getPreviews(context);
        for (LittleRenderingCube cube : cubes) {
            cube.color = this.relativeType.annotation.color();
        }
        return cubes;
    }

    @Override
    public List<LittleTile> placeTile(EntityPlayer player, ItemStack stack, BlockPos pos, LittleGridContext context, TileEntityLittleTiles teLT, TileList list, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, PlacementMode mode, EnumFacing facing, boolean requiresCollisionTest) {
        LittleStructure structure = this.structurePreview.getStructure();
        if (structure.getMainTile() == null && structure.selectMainTile()) {
            throw new RuntimeException("Invalid structure. Missing main tile!");
        }
        this.relative.setBox(BlockPos.field_177992_a, this.box.copy(), context);
        this.relative.add(new LittleTilePos(pos, context).getRelative(structure.getMainTile().getAbsolutePos()));
        this.relativeType.setRelative(structure, this.relative);
        return Collections.EMPTY_LIST;
    }
}

