/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.api.blocks.ISpecialBlockHandler;
import com.creativemd.littletiles.common.api.blocks.SpecialBlockHandler;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.combine.ICombinable;
import com.creativemd.littletiles.common.tiles.place.FixedHandler;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.compression.LittleNBTCompressionTools;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientEntry;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTilePreview
implements ICombinable {
    private static HashMap<String, Class<? extends LittleTilePreview>> previewTypes = new HashMap();
    public boolean canSplit = true;
    protected NBTTagCompound tileData;
    public LittleTileBox box;
    public List<FixedHandler> fixedhandlers = new ArrayList<FixedHandler>();
    public static int lowResolutionMode = 2000;

    public static void registerPreviewType(String id, Class<? extends LittleTilePreview> type) {
        previewTypes.put(id, type);
    }

    public String getTypeID() {
        if (!this.isCustomPreview()) {
            return "";
        }
        for (Map.Entry<String, Class<? extends LittleTilePreview>> type : previewTypes.entrySet()) {
            if (type.getValue() != this.getClass()) continue;
            return type.getKey();
        }
        return "";
    }

    public boolean isCustomPreview() {
        return this.getClass() != LittleTilePreview.class;
    }

    public LittleTilePreview(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bBoxminX") || nbt.func_74764_b("bBox")) {
            this.box = LittleTileBox.loadBox("bBox", nbt);
        } else if (nbt.func_74764_b("sizex") || nbt.func_74764_b("size")) {
            LittleTileSize size = new LittleTileSize("size", nbt);
            this.box = new LittleTileBox(0, 0, 0, size.sizeX, size.sizeY, size.sizeZ);
        } else {
            this.box = new LittleTileBox(0, 0, 0, 1, 1, 1);
        }
        if (nbt.func_74764_b("tile")) {
            this.tileData = nbt.func_74775_l("tile");
        } else {
            this.tileData = nbt.func_74737_b();
            this.tileData.func_82580_o("bBox");
            this.tileData.func_82580_o("size");
        }
    }

    public LittleTilePreview(LittleTileBox box, NBTTagCompound tileData) {
        this.box = box;
        this.tileData = tileData;
    }

    public boolean canBeConvertedToBlockEntry() {
        return this.hasBlockIngredient();
    }

    public String getBlockName() {
        return this.tileData.func_74779_i("block");
    }

    public Block getBlock() {
        return Block.func_149684_b((String)this.tileData.func_74779_i("block"));
    }

    public int getMeta() {
        return this.tileData.func_74762_e("meta");
    }

    public boolean hasColor() {
        return this.tileData.func_74764_b("color");
    }

    public int getColor() {
        if (this.tileData.func_74764_b("color")) {
            return this.tileData.func_74762_e("color");
        }
        return -1;
    }

    public void setColor(int color) {
        if (ColorUtils.isWhite((int)color) && !ColorUtils.isTransparent((int)color)) {
            if (this.tileData.func_74779_i("tID").equals("BlockTileColored")) {
                this.tileData.func_74778_a("tID", "BlockTileBlock");
            }
            this.tileData.func_82580_o("color");
        } else {
            if (this.tileData.func_74779_i("tID").equals("BlockTileBlock")) {
                this.tileData.func_74778_a("tID", "BlockTileColored");
            }
            this.tileData.func_74768_a("color", color);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public RenderCubeObject getCubeBlock(LittleGridContext context) {
        LittleRenderingCube cube = this.box.getRenderingCube(context, this.getBlock(), this.getMeta());
        cube.color = this.getColor();
        return cube;
    }

    public boolean isInvisible() {
        return this.tileData.func_74767_n("invisible");
    }

    public void setInvisibile(boolean invisible) {
        this.tileData.func_74757_a("invisible", invisible);
    }

    public NBTTagCompound getTileData() {
        return this.tileData;
    }

    public boolean hasBlockIngredient() {
        return !this.tileData.func_74767_n("nodrop");
    }

    @Nullable
    public BlockIngredientEntry getBlockIngredient(LittleGridContext context) {
        return IngredientUtils.getBlockIngredient(this.getBlock(), this.getMeta(), this.getPercentVolume(context));
    }

    public ItemStack getBlockStack() {
        return new ItemStack(this.getBlock(), 1, this.getMeta());
    }

    public double getPercentVolume(LittleGridContext context) {
        return this.box.getPercentVolume(context);
    }

    public double getVolume() {
        return this.box.getVolume();
    }

    public int getSmallestContext(LittleGridContext context) {
        return this.box.getSmallestContext(context);
    }

    public void convertTo(LittleGridContext from, LittleGridContext to) {
        this.box.convertTo(from, to);
    }

    public void convertTo(int from, int to) {
        this.box.convertTo(from, to);
    }

    public boolean canBeCombined(LittleTilePreview preview) {
        return this.tileData.equals((Object)preview.getTileData());
    }

    @Override
    public LittleTileBox getBox() {
        return this.box;
    }

    @Override
    public void setBox(LittleTileBox box) {
        this.box = box;
    }

    @Override
    public boolean isChildOfStructure() {
        return false;
    }

    @Override
    public boolean canCombine(ICombinable combinable) {
        return this.canBeCombined((LittleTilePreview)combinable);
    }

    @Override
    public void combine(ICombinable combinable) {
    }

    @Override
    public void fillInSpace(LittleTileBox otherBox, boolean[][][] filled) {
        this.box.fillInSpace(otherBox, filled);
    }

    @Override
    public LittleTilePreview copy() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(nbt);
        if (preview == null) {
            preview = new LittleTilePreview(this.box.copy(), this.tileData.func_74737_b());
        }
        preview.canSplit = this.canSplit;
        preview.fixedhandlers = new ArrayList<FixedHandler>(this.fixedhandlers);
        return preview;
    }

    public ISpecialBlockHandler getSpecialHandler() {
        return SpecialBlockHandler.getSpecialBlockHandler(this.getBlock(), this.getMeta());
    }

    public String toString() {
        return this.box.toString();
    }

    public LittleTile getLittleTile(TileEntityLittleTiles te) {
        return LittleTile.CreateandLoadTile(te, te.func_145831_w(), this.tileData);
    }

    public PlacePreviewTile getPlaceableTile(LittleTileBox overallBox, boolean fixed, LittleTileVec offset, LittlePreviews previews) {
        LittleTileBox newBox = this.box.copy();
        if (!fixed) {
            newBox.add(offset);
        }
        return new PlacePreviewTile(newBox, this, previews);
    }

    public void flipPreview(EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        this.box.flipBox(axis, doubledCenter);
        this.getSpecialHandler().flipPreview(axis, this, doubledCenter);
    }

    public void rotatePreview(Rotation rotation, LittleTileVec doubledCenter) {
        this.box.rotateBox(rotation, doubledCenter);
        this.getSpecialHandler().rotatePreview(rotation, this, doubledCenter);
    }

    public static LittleTilePreview loadPreviewFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt.func_74764_b("type")) {
            Class<? extends LittleTilePreview> type = previewTypes.get(nbt.func_74779_i("type"));
            if (type != null) {
                LittleTilePreview preview = null;
                try {
                    preview = type.getConstructor(NBTTagCompound.class).newInstance(nbt);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return preview;
            }
        } else {
            return new LittleTilePreview(nbt);
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.box.writeToNBT("bBox", nbt);
        nbt.func_74782_a("tile", (NBTBase)this.tileData);
        if (this.isCustomPreview() && !this.getTypeID().equals("")) {
            nbt.func_74778_a("type", this.getTypeID());
        }
    }

    public List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound nbt) {
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound copy = nbt.func_74737_b();
            copy.func_82580_o("boxes");
            copy.func_74783_a("bBox", list.func_150306_c(i));
            tags.add(copy);
        }
        return tags;
    }

    public boolean canBeNBTGrouped(LittleTilePreview preview) {
        return this.box != null && preview.box != null && preview.canSplit == preview.canSplit && preview.getTileData().equals((Object)this.getTileData());
    }

    public NBTTagCompound startNBTGrouping() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        nbt.func_82580_o("bBox");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.box.getNBTIntArray());
        nbt.func_74782_a("boxes", (NBTBase)list);
        return nbt;
    }

    public void groupNBTTile(NBTTagCompound nbt, LittleTilePreview preview) {
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        list.func_74742_a((NBTBase)preview.box.getNBTIntArray());
    }

    public static LittlePreviews getPreview(ItemStack stack) {
        return LittleTilePreview.getPreview(stack, false);
    }

    public static LittlePreviews getPreview(ItemStack stack, boolean allowLowResolution) {
        return LittlePreviews.getPreview(stack, allowLowResolution);
    }

    public static LittleTileSize getSize(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("size")) {
            return new LittleTileSize("size", stack.func_77978_p());
        }
        return new LittleTileSize(1, 1, 1);
    }

    public static LittleTileVec getOffset(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("min")) {
            return new LittleTileVec("min", stack.func_77978_p());
        }
        return null;
    }

    public static void removePreviewTiles(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        LittleGridContext.remove(nbt);
        nbt.func_82580_o("size");
        nbt.func_82580_o("min");
        nbt.func_82580_o("pos");
        nbt.func_82580_o("tiles");
        nbt.func_82580_o("count");
        nbt.func_82580_o("children");
    }

    public static NBTTagCompound saveChildPreviews(LittlePreviews previews) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (previews.hasStructure()) {
            nbt.func_74782_a("structure", (NBTBase)previews.getStructureData());
        }
        NBTTagList list = LittleNBTCompressionTools.writePreviews(previews);
        nbt.func_74782_a("tiles", (NBTBase)list);
        nbt.func_74768_a("count", previews.size());
        if (previews.hasChildren()) {
            NBTTagList children = new NBTTagList();
            for (LittlePreviews child : previews.getChildren()) {
                children.func_74742_a((NBTBase)LittleTilePreview.saveChildPreviews(child));
            }
            nbt.func_74782_a("children", (NBTBase)children);
        }
        return nbt;
    }

    public static void savePreview(LittlePreviews previews, ItemStack stack) {
        NBTTagList list;
        if (previews instanceof LittleAbsolutePreviews) {
            throw new IllegalArgumentException("Absolute positions cannot be saved!");
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (previews.hasStructure()) {
            stack.func_77978_p().func_74782_a("structure", (NBTBase)previews.getStructureData());
        }
        previews.context.set(stack.func_77978_p());
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleTilePreview preview : previews.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ).writeToNBT("size", stack.func_77978_p());
        new LittleTileVec(minX, minY, minZ).writeToNBT("min", stack.func_77978_p());
        if (previews.totalSize() >= lowResolutionMode) {
            list = new NBTTagList();
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            for (int i = 0; i < previews.size(); ++i) {
                BlockPos pos = previews.get((int)i).box.getMinVec().getBlockPos(previews.context);
                if (positions.contains(pos)) continue;
                positions.add(pos);
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            }
            stack.func_77978_p().func_74782_a("pos", (NBTBase)list);
        } else {
            stack.func_77978_p().func_82580_o("pos");
        }
        list = LittleNBTCompressionTools.writePreviews(previews);
        stack.func_77978_p().func_74782_a("tiles", (NBTBase)list);
        stack.func_77978_p().func_74768_a("count", previews.size());
        if (previews.hasChildren()) {
            NBTTagList children = new NBTTagList();
            for (LittlePreviews child : previews.getChildren()) {
                children.func_74742_a((NBTBase)LittleTilePreview.saveChildPreviews(child));
            }
            stack.func_77978_p().func_74782_a("children", (NBTBase)children);
        } else {
            stack.func_77978_p().func_82580_o("children");
        }
    }

    public static void saveTiles(World world, LittleGridContext context, TileEntityLittleTiles te, ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        LittlePreviews previews = new LittlePreviews(context);
        previews.addTiles(te);
        LittleTilePreview.savePreview(previews, stack);
    }

    public static void saveTiles(World world, LittleGridContext context, List<LittleTile> tiles, ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        LittlePreviews previews = new LittlePreviews(context);
        previews.addTiles(tiles);
        LittleTilePreview.savePreview(previews, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<RenderCubeObject> getCubes(LittlePreviews previews) {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        for (LittleTilePreview preview : previews.allPreviews()) {
            cubes.add(preview.getCubeBlock(previews.context));
        }
        return cubes;
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<RenderCubeObject> getCubes(ItemStack stack) {
        return LittleTilePreview.getCubes(stack, true);
    }

    public static int getTotalCount(NBTTagCompound nbt) {
        int count = nbt.func_74762_e("count");
        if (nbt.func_74764_b("children")) {
            NBTTagList list = nbt.func_150295_c("children", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                count += LittleTilePreview.getTotalCount(list.func_150305_b(i));
            }
        }
        return count;
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<RenderCubeObject> getCubes(ItemStack stack, boolean allowLowResolution) {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        if (stack.func_77942_o() && LittleTilePreview.getTotalCount(stack.func_77978_p()) >= lowResolutionMode && allowLowResolution) {
            NBTTagList list = stack.func_77978_p().func_150295_c("pos", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                cubes.add(new RenderCubeObject((float)array[0], (float)array[1], (float)array[2], (float)(array[0] + 1), (float)(array[1] + 1), (float)(array[2] + 1), LittleTiles.coloredBlock));
            }
        } else {
            LittlePreviews previews = LittleTilePreview.getPreview(stack);
            for (LittleTilePreview preview : previews.allPreviews()) {
                cubes.add(preview.getCubeBlock(previews.context));
            }
        }
        return cubes;
    }
}

