/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.creativecore.common.utils.math.RangedBitSet;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.client.render.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.tiles.combine.BasicCombiner;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleSlice;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleTileSlicedBox;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleTileSlicedOrdinaryBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.vec.SplitRangeBoxes;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileBox {
    public static final int secondMethodVolume = 256;
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public LittleTileBox(LittleTileVec center, LittleTileSize size) {
        LittleTileVec offset = size.calculateCenter();
        this.minX = center.x - offset.x;
        this.minY = center.y - offset.y;
        this.minZ = center.z - offset.z;
        this.maxX = this.minX + size.sizeX;
        this.maxY = this.minY + size.sizeY;
        this.maxZ = this.minZ + size.sizeZ;
    }

    public LittleTileBox(LittleGridContext context, CubeObject cube) {
        this(context.toGrid(cube.minX), context.toGrid(cube.minY), context.toGrid(cube.minZ), context.toGrid(cube.maxX), context.toGrid(cube.maxY), context.toGrid(cube.maxZ));
    }

    public LittleTileBox(LittleGridContext context, AxisAlignedBB box) {
        this(context.toGrid(box.field_72340_a), context.toGrid(box.field_72338_b), context.toGrid(box.field_72339_c), context.toGrid(box.field_72336_d), context.toGrid(box.field_72337_e), context.toGrid(box.field_72334_f));
    }

    public LittleTileBox(LittleTileBox ... boxes) {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (int i = 0; i < boxes.length; ++i) {
            this.minX = Math.min(boxes[i].minX, this.minX);
            this.minY = Math.min(boxes[i].minY, this.minY);
            this.minZ = Math.min(boxes[i].minZ, this.minZ);
            this.maxX = Math.max(boxes[i].maxX, this.maxX);
            this.maxY = Math.max(boxes[i].maxY, this.maxY);
            this.maxZ = Math.max(boxes[i].maxZ, this.maxZ);
        }
    }

    public LittleTileBox(LittleTileVec min, LittleTileVec max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public LittleTileBox(LittleTileVec min) {
        this(min.x, min.y, min.z, min.x + 1, min.y + 1, min.z + 1);
    }

    public LittleTileBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void addCollisionBoxes(LittleGridContext context, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, BlockPos offset) {
        AxisAlignedBB axisalignedbb = this.getBox(context, offset);
        if (entityBox.func_72326_a(axisalignedbb)) {
            collidingBoxes.add(axisalignedbb);
        }
    }

    public AxisAlignedBB getSelectionBox(LittleGridContext context, BlockPos pos) {
        return this.getBox(context, pos);
    }

    public AxisAlignedBB getBox(LittleGridContext context, BlockPos offset) {
        return new AxisAlignedBB(context.toVanillaGrid(this.minX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.minY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.minZ) + (double)offset.func_177952_p(), context.toVanillaGrid(this.maxX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.maxY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.maxZ) + (double)offset.func_177952_p());
    }

    public AxisAlignedBB getBox(LittleGridContext context) {
        return new AxisAlignedBB(context.toVanillaGrid(this.minX), context.toVanillaGrid(this.minY), context.toVanillaGrid(this.minZ), context.toVanillaGrid(this.maxX), context.toVanillaGrid(this.maxY), context.toVanillaGrid(this.maxZ));
    }

    public CubeObject getCube(LittleGridContext context) {
        return new CubeObject((float)context.toVanillaGrid(this.minX), (float)context.toVanillaGrid(this.minY), (float)context.toVanillaGrid(this.minZ), (float)context.toVanillaGrid(this.maxX), (float)context.toVanillaGrid(this.maxY), (float)context.toVanillaGrid(this.maxZ));
    }

    public int[] getArray() {
        return new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public NBTTagIntArray getNBTIntArray() {
        return new NBTTagIntArray(this.getArray());
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, this.getArray());
    }

    public int getSmallestContext(LittleGridContext context) {
        int size = LittleGridContext.minSize;
        size = Math.max(size, context.getMinGrid(this.minX));
        size = Math.max(size, context.getMinGrid(this.minY));
        size = Math.max(size, context.getMinGrid(this.minZ));
        size = Math.max(size, context.getMinGrid(this.maxX));
        size = Math.max(size, context.getMinGrid(this.maxY));
        size = Math.max(size, context.getMinGrid(this.maxZ));
        return size;
    }

    public void convertTo(LittleGridContext from, LittleGridContext to) {
        if (from.size > to.size) {
            int ratio = from.size / to.size;
            this.minX /= ratio;
            this.minY /= ratio;
            this.minZ /= ratio;
            this.maxX /= ratio;
            this.maxY /= ratio;
            this.maxZ /= ratio;
        } else {
            int ratio = to.size / from.size;
            this.minX *= ratio;
            this.minY *= ratio;
            this.minZ *= ratio;
            this.maxX *= ratio;
            this.maxY *= ratio;
            this.maxZ *= ratio;
        }
    }

    public void convertTo(int from, int to) {
        if (from > to) {
            int ratio = from / to;
            this.minX /= ratio;
            this.minY /= ratio;
            this.minZ /= ratio;
            this.maxX /= ratio;
            this.maxY /= ratio;
            this.maxZ /= ratio;
        } else {
            int ratio = to / from;
            this.minX *= ratio;
            this.minY *= ratio;
            this.minZ *= ratio;
            this.maxX *= ratio;
            this.maxY *= ratio;
            this.maxZ *= ratio;
        }
    }

    public boolean isCompletelyFilled() {
        return true;
    }

    public int getLongestSide() {
        return Math.max(this.maxX - this.minX, Math.max(this.maxY - this.minY, this.maxZ - this.minZ));
    }

    public Vec3d getSizeVec(LittleGridContext context) {
        return new Vec3d(context.toVanillaGrid(this.maxX - this.minX), context.toVanillaGrid(this.maxY - this.minY), context.toVanillaGrid(this.maxZ - this.minZ));
    }

    public LittleTileSize getSize() {
        return new LittleTileSize(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public double getVolume() {
        return (this.maxX - this.minX) * (this.maxY - this.minY) * (this.maxZ - this.minZ);
    }

    public double getPercentVolume(LittleGridContext context) {
        return this.getVolume() / (double)context.maxTilesPerBlock;
    }

    public int getValueOfFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0;
    }

    public LittleTileVec getCorner(BoxUtils.BoxCorner corner) {
        return new LittleTileVec(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public Vec3d getExactCorner(BoxUtils.BoxCorner corner) {
        return new Vec3d((double)this.getCornerX(corner), (double)this.getCornerY(corner), (double)this.getCornerZ(corner));
    }

    public int getCornerValue(BoxUtils.BoxCorner corner, EnumFacing.Axis axis) {
        return this.getValueOfFacing(corner.getFacing(axis));
    }

    public int getCornerX(BoxUtils.BoxCorner corner) {
        return this.getValueOfFacing(corner.x);
    }

    public int getCornerY(BoxUtils.BoxCorner corner) {
        return this.getValueOfFacing(corner.y);
    }

    public int getCornerZ(BoxUtils.BoxCorner corner) {
        return this.getValueOfFacing(corner.z);
    }

    public int getSize(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX - this.minX;
            }
            case Y: {
                return this.maxY - this.minY;
            }
            case Z: {
                return this.maxZ - this.minZ;
            }
        }
        return 0;
    }

    public void setMin(EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
    }

    public int getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0;
    }

    public void setMax(EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
    }

    public int getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0;
    }

    public boolean isValidBox() {
        return this.maxX > this.minX && this.maxY > this.minY && this.maxZ > this.minZ;
    }

    public boolean needsMultipleBlocks(LittleGridContext context) {
        int x = this.minX / context.size;
        int y = this.minY / context.size;
        int z = this.minZ / context.size;
        return this.maxX - x * context.size <= context.maxPos && this.maxY - y * context.size <= context.maxPos && this.maxZ - z * context.size <= context.maxPos;
    }

    public boolean isBoxInsideBlock(LittleGridContext context) {
        return this.minX >= context.minPos && this.maxX <= context.maxPos && this.minY >= context.minPos && this.maxY <= context.maxPos && this.minZ >= context.minPos && this.maxZ <= context.maxPos;
    }

    public void split(LittleGridContext context, BlockPos offset, HashMapList<BlockPos, LittleTileBox> boxes) {
        LittleTileSize size = this.getSize();
        int minOffX = context.toBlockOffset(this.minX);
        int minOffY = context.toBlockOffset(this.minY);
        int minOffZ = context.toBlockOffset(this.minZ);
        int maxOffX = context.toBlockOffset(this.maxX);
        int maxOffY = context.toBlockOffset(this.maxY);
        int maxOffZ = context.toBlockOffset(this.maxZ);
        ArrayList<LittleTileBox> tempBoxes = new ArrayList<LittleTileBox>();
        for (int x = minOffX; x <= maxOffX; ++x) {
            for (int y = minOffY; y <= maxOffY; ++y) {
                for (int z = minOffZ; z <= maxOffZ; ++z) {
                    int minX = Math.max(this.minX, x * context.size);
                    int minY = Math.max(this.minY, y * context.size);
                    int minZ = Math.max(this.minZ, z * context.size);
                    int maxX = Math.min(this.maxX, x * context.size + context.size);
                    int maxY = Math.min(this.maxY, y * context.size + context.size);
                    int maxZ = Math.min(this.maxZ, z * context.size + context.size);
                    if (maxX <= minX || maxY <= minY || maxZ <= minZ) continue;
                    tempBoxes.clear();
                    BlockPos pos = new BlockPos(x + offset.func_177958_n(), y + offset.func_177956_o(), z + offset.func_177952_p());
                    int offsetX = x * context.size;
                    int offsetY = y * context.size;
                    int offsetZ = z * context.size;
                    this.extractBox(minX, minY, minZ, maxX, maxY, maxZ, tempBoxes);
                    for (LittleTileBox box : tempBoxes) {
                        box.minX -= offsetX;
                        box.maxX -= offsetX;
                        box.minY -= offsetY;
                        box.maxY -= offsetY;
                        box.minZ -= offsetZ;
                        box.maxZ -= offsetZ;
                        boxes.add((Object)pos, (Object)box);
                    }
                }
            }
        }
    }

    public boolean doesFillEntireBlock(LittleGridContext context) {
        return this.minX == 0 && this.minY == 0 && this.minZ == 0 && this.maxX == context.size && this.maxY == context.size && this.maxZ == context.size;
    }

    public LittleTileBox createOutsideBlockBox(LittleGridContext context, EnumFacing facing) {
        LittleTileBox box = this.copy();
        switch (facing) {
            case EAST: {
                box.minX = 0;
                box.maxX -= context.size;
                break;
            }
            case WEST: {
                box.minX += context.size;
                box.maxX = context.size;
                break;
            }
            case UP: {
                box.minY = 0;
                box.maxY -= context.size;
                break;
            }
            case DOWN: {
                box.minY += context.size;
                box.maxY = context.size;
                break;
            }
            case SOUTH: {
                box.minZ = 0;
                box.maxZ -= context.size;
                break;
            }
            case NORTH: {
                box.minZ += context.size;
                box.maxZ = context.size;
            }
        }
        return box;
    }

    public LittleTileBox combineBoxes(LittleTileBox box, BasicCombiner combinator) {
        boolean z;
        if (box.getClass() != LittleTileBox.class) {
            return null;
        }
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return this;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return new LittleTileBox(this.minX, this.minY, box.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxZ == box.minZ) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, box.maxZ);
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return new LittleTileBox(this.minX, box.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxY == box.minY) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, box.maxY, this.maxZ);
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return new LittleTileBox(box.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxX == box.minX) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, box.maxX, this.maxY, this.maxZ);
            }
        }
        return null;
    }

    @Nullable
    public EnumFacing sharedBoxFace(LittleTileBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return null;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return EnumFacing.SOUTH;
            }
            if (this.maxZ == box.minZ) {
                return EnumFacing.NORTH;
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return EnumFacing.UP;
            }
            if (this.maxY == box.minY) {
                return EnumFacing.DOWN;
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return EnumFacing.EAST;
            }
            if (this.maxX == box.minX) {
                return EnumFacing.WEST;
            }
        }
        return null;
    }

    public SplitRangeBoxes split(List<LittleTileBox> boxes) {
        RangedBitSet x = this.split(EnumFacing.Axis.X, boxes);
        RangedBitSet y = this.split(EnumFacing.Axis.Y, boxes);
        RangedBitSet z = this.split(EnumFacing.Axis.Z, boxes);
        if (x != null && y != null && z != null) {
            return new SplitRangeBoxes(x, y, z);
        }
        return null;
    }

    protected RangedBitSet split(EnumFacing.Axis axis, List<LittleTileBox> boxes) {
        int min = this.getMin(axis);
        int max = this.getMax(axis);
        RangedBitSet set = new RangedBitSet(min, max);
        for (LittleTileBox box : boxes) {
            if (!box.isCompletelyFilled()) {
                return null;
            }
            if (!box.intersectsWith(this)) continue;
            set.add(box.getMin(axis));
            set.add(box.getMax(axis));
        }
        return set;
    }

    public List<LittleTileBox> cutOut(List<LittleTileBox> boxes, List<LittleTileBox> cutout) {
        SplitRangeBoxes ranges;
        ArrayList<LittleTileBox> newBoxes = new ArrayList<LittleTileBox>();
        if (this.getVolume() > 256.0 && (ranges = this.split(boxes)) != null) {
            ArrayList<LittleTileBox> tempBoxes = new ArrayList<LittleTileBox>();
            for (SplitRangeBoxes.SplitRangeBox range : ranges) {
                this.extractBox(range.x.min, range.y.min, range.z.min, range.x.max, range.y.max, range.z.max, tempBoxes);
                boolean cutted = false;
                block1: for (LittleTileBox box : tempBoxes) {
                    for (LittleTileBox cutBox : boxes) {
                        if (!cutBox.intersectsWith(box)) continue;
                        cutted = true;
                        break block1;
                    }
                }
                if (cutted) {
                    cutout.addAll(tempBoxes);
                } else {
                    newBoxes.addAll(tempBoxes);
                }
                tempBoxes.clear();
            }
        } else {
            int z;
            int y;
            int x;
            boolean[][][] filled = new boolean[this.getSize(EnumFacing.Axis.X)][this.getSize(EnumFacing.Axis.Y)][this.getSize(EnumFacing.Axis.Z)];
            for (LittleTileBox box : boxes) {
                box.fillInSpace(this, filled);
            }
            boolean expected = filled[0][0][0];
            boolean continuous = true;
            block4: for (x = 0; x < filled.length; ++x) {
                for (y = 0; y < filled[x].length; ++y) {
                    for (z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z] == expected) continue;
                        continuous = false;
                        break block4;
                    }
                }
            }
            if (continuous) {
                if (expected) {
                    cutout.add(this.copy());
                    return new ArrayList<LittleTileBox>();
                }
                newBoxes.add(this.copy());
                return newBoxes;
            }
            for (x = 0; x < filled.length; ++x) {
                for (y = 0; y < filled[x].length; ++y) {
                    for (z = 0; z < filled[x][y].length; ++z) {
                        LittleTileBox box = this.extractBox(x + this.minX, y + this.minY, z + this.minZ);
                        if (box == null) continue;
                        if (filled[x][y][z]) {
                            cutout.add(box);
                            continue;
                        }
                        newBoxes.add(box);
                    }
                }
            }
        }
        BasicCombiner.combineBoxes(newBoxes);
        BasicCombiner.combineBoxes(cutout);
        return newBoxes;
    }

    public List<LittleTileBox> cutOut(LittleTileBox box) {
        if (this.intersectsWith(box)) {
            ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
            if (this.getVolume() > 256.0 && box.isCompletelyFilled()) {
                ArrayList<LittleTileBox> splitting = new ArrayList<LittleTileBox>();
                splitting.add(box);
                ArrayList<LittleTileBox> tempBoxes = new ArrayList<LittleTileBox>();
                for (SplitRangeBoxes.SplitRangeBox range : this.split(splitting)) {
                    this.extractBox(range.x.min, range.y.min, range.z.min, range.x.max, range.y.max, range.z.max, tempBoxes);
                    boolean cutted = false;
                    for (LittleTileBox tempBox : tempBoxes) {
                        if (!box.intersectsWith(tempBox)) continue;
                        cutted = true;
                        break;
                    }
                    if (!cutted) {
                        boxes.addAll(tempBoxes);
                    }
                    tempBoxes.clear();
                }
                return boxes;
            }
            LittleTileVec vec = new LittleTileVec(0, 0, 0);
            for (int littleX = this.minX; littleX < this.maxX; ++littleX) {
                for (int littleY = this.minY; littleY < this.maxY; ++littleY) {
                    for (int littleZ = this.minZ; littleZ < this.maxZ; ++littleZ) {
                        vec.set(littleX, littleY, littleZ);
                        if (box.isVecInsideBox(box, vec)) continue;
                        boxes.add(this.extractBox(littleX, littleY, littleZ));
                    }
                }
            }
            BasicCombiner.combineBoxes(boxes);
            return boxes;
        }
        return null;
    }

    protected boolean intersectsWith(LittleTileBox box) {
        return box.maxX > this.minX && box.minX < this.maxX && box.maxY > this.minY && box.minY < this.maxY && box.maxZ > this.minZ && box.minZ < this.maxZ;
    }

    public boolean containsBox(LittleTileBox box) {
        return this.minX <= box.minX && this.maxX >= box.maxX && this.minY <= box.minY && this.maxY >= box.maxY && this.minZ <= box.minZ && this.maxZ >= box.maxZ;
    }

    public void fillInSpace(LittleTileBox otherBox, boolean[][][] filled) {
        int minX = Math.max(this.minX, otherBox.minX);
        int maxX = Math.min(this.maxX, otherBox.maxX);
        int minY = Math.max(this.minY, otherBox.minY);
        int maxY = Math.min(this.maxY, otherBox.maxY);
        int minZ = Math.max(this.minZ, otherBox.minZ);
        int maxZ = Math.min(this.maxZ, otherBox.maxZ);
        if (this.isCompletelyFilled()) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                    }
                }
            }
        } else {
            LittleTileVec vec = new LittleTileVec(0, 0, 0);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        vec.set(x, y, z);
                        if (!this.isVecInsideBox(otherBox, vec)) continue;
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                    }
                }
            }
        }
    }

    public void add(int x, int y, int z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public void add(LittleTileVec vec) {
        this.minX += vec.x;
        this.minY += vec.y;
        this.minZ += vec.z;
        this.maxX += vec.x;
        this.maxY += vec.y;
        this.maxZ += vec.z;
    }

    public void sub(int x, int y, int z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX -= x;
        this.maxY -= y;
        this.maxZ -= z;
    }

    public void sub(LittleTileVec vec) {
        this.minX -= vec.x;
        this.minY -= vec.y;
        this.minZ -= vec.z;
        this.maxX -= vec.x;
        this.maxY -= vec.y;
        this.maxZ -= vec.z;
    }

    public LittleTileVec getMinVec() {
        return new LittleTileVec(this.minX, this.minY, this.minZ);
    }

    public LittleTileVec getMaxVec() {
        return new LittleTileVec(this.maxX, this.maxY, this.maxZ);
    }

    public LittleTileVec getNearstedPointTo(LittleTileVec vec) {
        int x = this.minX;
        if (vec.x >= this.minX || vec.x <= this.maxX) {
            x = vec.x;
        }
        if (Math.abs(this.minX - x) > Math.abs(this.maxX - x)) {
            x = this.maxX;
        }
        int y = this.minY;
        if (vec.y >= this.minY || vec.y <= this.maxY) {
            y = vec.y;
        }
        if (Math.abs(this.minY - y) > Math.abs(this.maxY - y)) {
            y = this.maxY;
        }
        int z = this.minZ;
        if (vec.z >= this.minZ || vec.z <= this.maxZ) {
            z = vec.z;
        }
        if (Math.abs(this.minZ - z) > Math.abs(this.maxZ - z)) {
            z = this.maxZ;
        }
        return new LittleTileVec(x, y, z);
    }

    public LittleTileVec getNearstedPointTo(LittleTileBox box) {
        int x = 0;
        x = this.minX >= box.minX && this.minX <= box.maxX ? this.minX : (box.minX >= this.minX && box.minX <= box.maxX ? box.minX : (Math.abs(this.minX - box.maxX) > Math.abs(this.maxX - box.minX) ? this.maxX : this.minX));
        int y = 0;
        y = this.minY >= box.minY && this.minY <= box.maxY ? this.minY : (box.minY >= this.minY && box.minY <= box.maxY ? box.minY : (Math.abs(this.minY - box.maxY) > Math.abs(this.maxY - box.minY) ? this.maxY : this.minY));
        int z = 0;
        z = this.minZ >= box.minZ && this.minZ <= box.maxZ ? this.minZ : (box.minZ >= this.minZ && box.minZ <= box.maxZ ? box.minZ : (Math.abs(this.minZ - box.maxZ) > Math.abs(this.maxZ - box.minZ) ? this.maxZ : this.minZ));
        return new LittleTileVec(x, y, z);
    }

    public double distanceTo(LittleTileBox box) {
        return this.distanceTo(box.getNearstedPointTo(this));
    }

    public double distanceTo(LittleTileVec vec) {
        return this.getNearstedPointTo(vec).distanceTo(vec);
    }

    public boolean isVecInsideBox(int x, int y, int z) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY && z >= this.minZ && z < this.maxZ;
    }

    public boolean isVecInsideBox(LittleTileBox box, LittleTileVec vec) {
        return this.isVecInsideBox(vec.x, vec.y, vec.z);
    }

    public boolean intersectsWithFace(EnumFacing facing, LittleTileVec vec, boolean completely) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)facing.func_176740_k());
        EnumFacing.Axis two = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)facing.func_176740_k());
        return vec.get(one) >= this.getMin(one) && vec.get(one) <= this.getMax(one) && vec.get(two) >= this.getMin(two) && vec.get(two) <= this.getMax(two);
    }

    public boolean intersectsWithAxis(LittleGridContext context, EnumFacing.Axis axis, Vec3d vec) {
        switch (axis) {
            case X: {
                return this.intersectsWithYZ(context, vec);
            }
            case Y: {
                return this.intersectsWithXZ(context, vec);
            }
            case Z: {
                return this.intersectsWithXY(context, vec);
            }
        }
        return false;
    }

    public boolean intersectsWithYZ(LittleGridContext context, Vec3d vec) {
        return vec.field_72448_b >= context.toVanillaGrid(this.minY) && vec.field_72448_b < context.toVanillaGrid(this.maxY) && vec.field_72449_c >= context.toVanillaGrid(this.minZ) && vec.field_72449_c < context.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXZ(LittleGridContext context, Vec3d vec) {
        return vec.field_72450_a >= context.toVanillaGrid(this.minX) && vec.field_72450_a < context.toVanillaGrid(this.maxX) && vec.field_72449_c >= context.toVanillaGrid(this.minZ) && vec.field_72449_c < context.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXY(LittleGridContext context, Vec3d vec) {
        return vec.field_72450_a >= context.toVanillaGrid(this.minX) && vec.field_72450_a < context.toVanillaGrid(this.maxX) && vec.field_72448_b >= context.toVanillaGrid(this.minY) && vec.field_72448_b < context.toVanillaGrid(this.maxY);
    }

    public LittleTileVec getCenter() {
        return new LittleTileVec((this.maxX + this.minX) / 2, (this.maxY + this.minY) / 2, (this.maxZ + this.minZ) / 2);
    }

    @Nullable
    protected Vec3d collideWithPlane(LittleGridContext context, EnumFacing.Axis axis, double value, Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = axis != EnumFacing.Axis.X ? (axis != EnumFacing.Axis.Y ? vecA.func_72434_d(vecB, value) : vecA.func_72435_c(vecB, value)) : vecA.func_72429_b(vecB, value);
        return vec3d != null && this.intersectsWithAxis(context, axis, vec3d) ? vec3d : null;
    }

    @Nullable
    public RayTraceResult calculateIntercept(LittleGridContext context, BlockPos pos, Vec3d vecA, Vec3d vecB) {
        vecA = vecA.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        vecB = vecB.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d collision = null;
        EnumFacing collided = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vec3d temp = this.collideWithPlane(context, facing.func_176740_k(), (double)this.getValueOfFacing(facing) / (double)context.size, vecA, vecB);
            if (temp == null || !LittleTileBox.isClosest(vecA, collision, temp)) continue;
            collided = facing;
            collision = temp;
        }
        if (collision == null) {
            return null;
        }
        return new RayTraceResult(collision.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), collided, pos);
    }

    public void rotateBox(Rotation rotation, LittleTileVec doubledCenter) {
        long tempMinX = this.minX * 2 - doubledCenter.x;
        long tempMinY = this.minY * 2 - doubledCenter.y;
        long tempMinZ = this.minZ * 2 - doubledCenter.z;
        long tempMaxX = this.maxX * 2 - doubledCenter.x;
        long tempMaxY = this.maxY * 2 - doubledCenter.y;
        long tempMaxZ = this.maxZ * 2 - doubledCenter.z;
        this.resort((int)((rotation.getMatrix().getX(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.z) / 2L), (int)((rotation.getMatrix().getX(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.z) / 2L));
    }

    public void flipBox(EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        long tempMin = this.getMin(axis) * 2 - doubledCenter.get(axis);
        long tempMax = this.getMax(axis) * 2 - doubledCenter.get(axis);
        int min = (int)(((long)doubledCenter.get(axis) - tempMin) / 2L);
        int max = (int)(((long)doubledCenter.get(axis) - tempMax) / 2L);
        this.setMin(axis, Math.min(min, max));
        this.setMax(axis, Math.max(min, max));
    }

    public int hashCode() {
        return this.minX + this.minY + this.minZ + this.maxX + this.maxY + this.maxZ;
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileBox) {
            return object.getClass() == this.getClass() && this.minX == ((LittleTileBox)object).minX && this.minY == ((LittleTileBox)object).minY && this.minZ == ((LittleTileBox)object).minZ && this.maxX == ((LittleTileBox)object).maxX && this.maxY == ((LittleTileBox)object).maxY && this.maxZ == ((LittleTileBox)object).maxZ;
        }
        return super.equals(object);
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "]";
    }

    public LittleTileBox extractBox(int x, int y, int z) {
        return new LittleTileBox(x, y, z, x + 1, y + 1, z + 1);
    }

    public List<LittleTileBox> extractBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, List<LittleTileBox> boxes) {
        boxes.add(new LittleTileBox(minX, minY, minZ, maxX, maxY, maxZ));
        return boxes;
    }

    public LittleTileBox copy() {
        return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean isFaceAtEdge(LittleGridContext context, EnumFacing facing) {
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return this.getMax(facing.func_176740_k()) == context.size;
        }
        return this.getMin(facing.func_176740_k()) == context.minPos;
    }

    public LittleTileBox grow(EnumFacing facing) {
        EnumFacing.Axis axis = facing.func_176740_k();
        LittleTileBox result = this.copy();
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            result.setMax(axis, this.getMax(axis) + 1);
        } else {
            result.setMin(axis, this.getMin(axis) - 1);
        }
        return result;
    }

    public LittleTileBox shrink(EnumFacing facing, boolean toLimit) {
        EnumFacing.Axis axis = facing.func_176740_k();
        if (this.getSize(axis) > 1) {
            LittleTileBox result = this.copy();
            if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                result.setMax(axis, toLimit ? this.getMin(axis) + 1 : this.getMax(axis) - 1);
            } else {
                result.setMin(axis, toLimit ? this.getMax(axis) - 1 : this.getMin(axis) + 1);
            }
            return result;
        }
        return null;
    }

    public void resort() {
        this.set(Math.min(this.minX, this.maxX), Math.min(this.minY, this.maxY), Math.min(this.minZ, this.maxZ), Math.max(this.minX, this.maxX), Math.max(this.minY, this.maxY), Math.max(this.minZ, this.maxZ));
    }

    public void resort(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ), Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    @SideOnly(value=Side.CLIENT)
    public LittleRenderingCube getRenderingCube(LittleGridContext context, Block block, int meta) {
        return this.getRenderingCube(context, this.getCube(context), block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public LittleRenderingCube getRenderingCube(LittleGridContext context, CubeObject cube, Block block, int meta) {
        return new LittleRenderingCube(cube, this, block, meta);
    }

    @Nullable
    public LittleTileFace getFace(LittleGridContext context, EnumFacing facing) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)facing.func_176740_k());
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)facing.func_176740_k());
        return new LittleTileFace(this, context, facing, this.getMin(one), this.getMin(two), this.getMax(one), this.getMax(two), facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMax(facing.func_176740_k()) : this.getMin(facing.func_176740_k()));
    }

    public boolean intersectsWith(LittleTileFace face) {
        return (face.face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMin(face.face.func_176740_k()) : this.getMax(face.face.func_176740_k())) == face.origin && face.maxOne > this.getMin(face.one) && face.minOne < this.getMax(face.one) && face.maxTwo > this.getMin(face.two) && face.minTwo < this.getMax(face.two);
    }

    public boolean canFaceBeCombined(LittleTileBox other) {
        return true;
    }

    public void fill(LittleTileFace face) {
        block7: {
            if (!this.intersectsWith(face)) break block7;
            int minOne = Math.max(this.getMin(face.one), face.minOne);
            int maxOne = Math.min(this.getMax(face.one), face.maxOne);
            int minTwo = Math.max(this.getMin(face.two), face.minTwo);
            int maxTwo = Math.min(this.getMax(face.two), face.maxTwo);
            if (this.isCompletelyFilled()) {
                for (int one = minOne; one < maxOne; ++one) {
                    for (int two = minTwo; two < maxTwo; ++two) {
                        face.filled[one - face.minOne][two - face.minTwo] = true;
                    }
                }
            } else {
                boolean completely = !this.canFaceBeCombined(face.getBox());
                int min = this.getValueOfFacing(face.face.func_176734_d());
                if (face.face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                    --min;
                }
                LittleTileVec vec = new LittleTileVec(min, min, min);
                for (int one = minOne; one < maxOne; ++one) {
                    for (int two = minTwo; two < maxTwo; ++two) {
                        vec.set(face.one, one);
                        vec.set(face.two, two);
                        if (!this.intersectsWithFace(face.face.func_176734_d(), vec, completely)) continue;
                        face.filled[one - face.minOne][two - face.minTwo] = true;
                    }
                }
            }
        }
    }

    public int[] getIdentifier() {
        return new int[]{this.minX, this.minY, this.minZ};
    }

    public boolean is(int[] identifier) {
        if (identifier.length == 3) {
            return identifier[0] == this.minX && identifier[1] == this.minY && identifier[2] == this.minZ;
        }
        return false;
    }

    public static LittleTileBox loadBox(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagByte) {
            LittleTileBox box = new LittleTileBox(nbt.func_74771_c(name + "minX"), nbt.func_74771_c(name + "minY"), nbt.func_74771_c(name + "minZ"), nbt.func_74771_c(name + "maxX"), nbt.func_74771_c(name + "maxY"), nbt.func_74771_c(name + "maxZ"));
            nbt.func_82580_o(name + "minX");
            nbt.func_82580_o(name + "minY");
            nbt.func_82580_o(name + "minZ");
            nbt.func_82580_o(name + "maxX");
            nbt.func_82580_o(name + "maxY");
            nbt.func_82580_o(name + "maxZ");
            box.writeToNBT(name, nbt);
            return box;
        }
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagInt) {
            LittleTileBox box = new LittleTileBox(nbt.func_74762_e(name + "minX"), nbt.func_74762_e(name + "minY"), nbt.func_74762_e(name + "minZ"), nbt.func_74762_e(name + "maxX"), nbt.func_74762_e(name + "maxY"), nbt.func_74762_e(name + "maxZ"));
            nbt.func_82580_o(name + "minX");
            nbt.func_82580_o(name + "minY");
            nbt.func_82580_o(name + "minZ");
            nbt.func_82580_o(name + "maxX");
            nbt.func_82580_o(name + "maxY");
            nbt.func_82580_o(name + "maxZ");
            box.writeToNBT(name, nbt);
            return box;
        }
        if (nbt.func_74781_a(name) instanceof NBTTagIntArray) {
            return LittleTileBox.createBox(nbt.func_74759_k(name));
        }
        if (nbt.func_74781_a(name) instanceof NBTTagString) {
            String[] coords = nbt.func_74779_i(name).split("\\.");
            try {
                return new LittleTileBox(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), Integer.parseInt(coords[3]), Integer.parseInt(coords[4]), Integer.parseInt(coords[5]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LittleTileBox(0, 0, 0, 0, 0, 0);
    }

    public static LittleTileBox createBox(int[] array) {
        switch (array.length) {
            case 6: {
                return new LittleTileBox(array[0], array[1], array[2], array[3], array[4], array[5]);
            }
            case 7: {
                return new LittleTileSlicedOrdinaryBox(array[0], array[1], array[2], array[3], array[4], array[5], LittleSlice.getSliceByID(array[6]));
            }
            case 11: {
                return new LittleTileSlicedBox(array[0], array[1], array[2], array[3], array[4], array[5], LittleSlice.getSliceByID(array[6]), Float.intBitsToFloat(array[7]), Float.intBitsToFloat(array[8]), Float.intBitsToFloat(array[9]), Float.intBitsToFloat(array[10]));
            }
        }
        throw new InvalidParameterException("No valid coords given " + Arrays.toString(array));
    }

    public static void combineBoxesBlocks(LittleBoxes boxes) {
        LittleTileBox.combineBoxesBlocks(boxes.context, boxes);
    }

    public static void combineBoxesBlocks(LittleGridContext context, List<LittleTileBox> boxes) {
        HashMapList chunked = new HashMapList();
        for (int i = 0; i < boxes.size(); ++i) {
            chunked.add((Object)boxes.get(i).getMinVec().getBlockPos(context), (Object)boxes.get(i));
        }
        boxes.clear();
        BasicCombiner combiner = new BasicCombiner(new ArrayList<LittleTileBox>());
        for (ArrayList list : chunked.values()) {
            combiner.set(list);
            combiner.combine();
            boxes.addAll(list);
        }
    }

    public static boolean isClosest(Vec3d from, @Nullable Vec3d optional, Vec3d toCheck) {
        return optional == null || from.func_72436_e(toCheck) < from.func_72436_e(optional);
    }

    public static boolean intersectsWith(LittleTileBox box, LittleTileBox box2) {
        if (box.getClass() == LittleTileBox.class) {
            return box2.intersectsWith(box);
        }
        return box.intersectsWith(box2);
    }

    public static class LittleTileFace {
        public LittleGridContext context;
        public LittleTileBox box;
        public EnumFacing.Axis one;
        public EnumFacing.Axis two;
        public EnumFacing face;
        public int minOne;
        public int minTwo;
        public int maxOne;
        public int maxTwo;
        public int origin;
        public int oldOrigin;
        public boolean[][] filled;

        public void ensureContext(LittleGridContext context) {
            if (context == this.context || this.context.size > context.size) {
                return;
            }
            int ratio = context.size / this.context.size;
            this.minOne *= ratio;
            this.minTwo *= ratio;
            this.maxOne *= ratio;
            this.maxTwo *= ratio;
            this.origin *= ratio;
            this.oldOrigin *= ratio;
            this.box = this.box.copy();
            this.box.convertTo(this.context, context);
            this.context = context;
            this.filled = new boolean[this.maxOne - this.minOne][this.maxTwo - this.minTwo];
        }

        public LittleTileFace(LittleTileBox box, LittleGridContext context, EnumFacing face, int minOne, int minTwo, int maxOne, int maxTwo, int origin) {
            this.box = box;
            this.context = context;
            this.face = face;
            this.one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)face.func_176740_k());
            this.two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)face.func_176740_k());
            this.minOne = minOne;
            this.minTwo = minTwo;
            this.maxOne = maxOne;
            this.maxTwo = maxTwo;
            this.origin = origin;
            this.oldOrigin = origin;
            this.filled = new boolean[maxOne - minOne][maxTwo - minTwo];
        }

        public boolean isFilled() {
            int min = this.oldOrigin;
            if (this.face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                --min;
            }
            LittleTileVec vec = new LittleTileVec(min, min, min);
            for (int one = 0; one < this.filled.length; ++one) {
                for (int two = 0; two < this.filled[one].length; ++two) {
                    vec.set(this.one, this.minOne + one);
                    vec.set(this.two, this.minTwo + two);
                    if (this.filled[one][two] || !this.box.intersectsWithFace(this.face, vec, false)) continue;
                    return false;
                }
            }
            return true;
        }

        public LittleTileBox getBox() {
            return this.box;
        }

        public boolean isFaceInsideBlock() {
            return this.origin > this.context.minPos && this.origin < this.context.maxPos;
        }

        public void move(EnumFacing facing) {
            this.origin = this.face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.context.minPos : this.context.maxPos;
        }
    }
}

