/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.security.InvalidParameterException;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class LittleTileIdentifierRelative {
    public BlockPos coord;
    public LittleGridContext context;
    public int[] identifier;

    public LittleTileIdentifierRelative(TileEntity te, BlockPos coord, LittleGridContext context, int[] identifier) {
        this(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), coord, context, identifier);
    }

    public LittleTileIdentifierRelative(BlockPos origin, BlockPos coord, LittleGridContext context, int[] identifier) {
        this(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p(), coord, context, identifier);
    }

    public LittleTileIdentifierRelative(int baseX, int baseY, int baseZ, BlockPos coord, LittleGridContext context, int[] identifier) {
        this(coord.func_177958_n() - baseX, coord.func_177956_o() - baseY, coord.func_177952_p() - baseZ, context, identifier);
    }

    protected LittleTileIdentifierRelative(int relativeX, int relativeY, int relativeZ, LittleGridContext context, int[] identifier) {
        this.coord = new BlockPos(relativeX, relativeY, relativeZ);
        this.context = context;
        this.identifier = identifier;
    }

    public static LittleTileIdentifierRelative loadIdentifierOld(String id, NBTTagCompound nbt) {
        return new LittleTileIdentifierRelative(id, nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LittleTileIdentifierRelative(String id, NBTTagCompound nbt) {
        if (nbt.func_74764_b(id + "coord")) {
            int[] array = nbt.func_74759_k(id + "coord");
            if (array.length != 3) throw new InvalidParameterException("No valid coord given " + nbt);
            this.coord = new BlockPos(array[0], array[1], array[2]);
        } else {
            this.coord = nbt.func_74764_b(id + "coordX") ? new BlockPos(nbt.func_74762_e(id + "coordX"), nbt.func_74762_e(id + "coordY"), nbt.func_74762_e(id + "coordZ")) : new BlockPos(0, 0, 0);
        }
        if (nbt.func_74764_b(id + "pos")) {
            LittleTileVec position = new LittleTileVec(id + "pos", nbt);
            this.identifier = new int[]{position.x, position.y, position.z};
        } else {
            this.identifier = nbt.func_74759_k("id");
        }
        this.context = LittleGridContext.get(nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LittleTileIdentifierRelative(NBTTagCompound nbt) {
        if (nbt.func_74764_b("coord")) {
            int[] array = nbt.func_74759_k("coord");
            if (array.length != 3) throw new InvalidParameterException("No valid coord given " + nbt);
            this.coord = new BlockPos(array[0], array[1], array[2]);
        } else {
            this.coord = nbt.func_74764_b("coordX") ? new BlockPos(nbt.func_74762_e("coordX"), nbt.func_74762_e("coordY"), nbt.func_74762_e("coordZ")) : new BlockPos(0, 0, 0);
        }
        if (nbt.func_74764_b("pos")) {
            LittleTileVec position = new LittleTileVec("pos", nbt);
            this.identifier = new int[]{position.x, position.y, position.z};
        } else {
            this.identifier = nbt.func_74759_k("id");
        }
        this.context = LittleGridContext.get(nbt);
    }

    public BlockPos getAbsolutePosition(TileEntity te) {
        return this.getAbsolutePosition(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
    }

    public BlockPos getAbsolutePosition(BlockPos origin) {
        return this.getAbsolutePosition(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
    }

    public BlockPos getAbsolutePosition(int x, int y, int z) {
        return new BlockPos(this.coord.func_177958_n() + x, this.coord.func_177956_o() + y, this.coord.func_177952_p() + z);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74783_a("coord", new int[]{this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p()});
        nbt.func_74783_a("id", this.identifier);
        this.context.set(nbt);
        return nbt;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LittleTileIdentifierRelative) {
            if (!this.coord.equals((Object)((LittleTileIdentifierRelative)obj).coord)) {
                return false;
            }
            return Arrays.equals(this.identifier, LittleTileIdentifierAbsolute.convertTo(((LittleTileIdentifierRelative)obj).identifier, ((LittleTileIdentifierRelative)obj).context, this.context));
        }
        return false;
    }

    public String toString() {
        return "coord:[" + this.coord.func_177958_n() + "," + this.coord.func_177956_o() + "," + this.coord.func_177952_p() + "]|position:" + Arrays.toString(this.identifier);
    }

    public LittleTileIdentifierRelative copy() {
        return new LittleTileIdentifierRelative(this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p(), this.context, (int[])this.identifier.clone());
    }
}

