/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation.event;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.utils.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.utils.animation.event.AnimationEvent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChildActivateEvent
extends AnimationEvent {
    public int childId;

    public ChildActivateEvent(int tick, int childId) {
        super(tick);
        this.childId = childId;
    }

    public ChildActivateEvent(int tick) {
        super(tick);
    }

    @Override
    protected void write(NBTTagCompound nbt) {
        nbt.func_74768_a("childId", this.childId);
    }

    @Override
    protected void read(NBTTagCompound nbt) {
        this.childId = nbt.func_74762_e("childId");
    }

    @Override
    protected boolean run(EntityAnimationController controller) {
        LittleStructure structure = controller.parent.structure;
        IStructureChildConnector connector = structure.children.get(this.childId);
        LittleDoor door = (LittleDoor)connector.getStructure(structure.getWorld());
        LittleDoor.DoorOpeningResult result = controller instanceof DoorController ? (((DoorController)controller).result.isEmpty() || !((DoorController)controller).result.nbt.func_74764_b("c" + door.parent.getChildID()) ? LittleDoor.EMPTY_OPENING_RESULT : new LittleDoor.DoorOpeningResult(((DoorController)controller).result.nbt.func_74775_l("c" + door.parent.getChildID()))) : LittleDoor.EMPTY_OPENING_RESULT;
        if (!door.canOpenDoor(null, result)) {
            result = door.canOpenDoor(null);
        }
        if (result == null) {
            return true;
        }
        EntityAnimation childAnimation = door.openDoor(null, ((DoorController)controller).supplier, result, true);
        if (childAnimation != null) {
            childAnimation.controller.onServerApproves();
        }
        return true;
    }

    @Override
    public int getEventDuration(LittleStructure structure) {
        IStructureChildConnector connector = structure.children.get(this.childId);
        LittleDoor door = (LittleDoor)connector.getStructure(structure.getWorld());
        return door.getCompleteDuration();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void prepareInGui(LittlePreviews previews, LittleStructure structure, EntityAnimation animation, AnimationGuiHandler handler) {
        if (structure.children.size() <= this.childId) {
            return;
        }
        IStructureChildConnector connector = structure.children.get(this.childId);
        if (connector != null && connector.isConnected(structure.getWorld()) && connector.getStructureWithoutLoading() instanceof LittleDoor) {
            LittleDoor child = (LittleDoor)connector.getStructureWithoutLoading();
            EntityAnimation childAnimation = !connector.isLinkToAnotherWorld() ? child.openDoor(null, new UUIDSupplier(), LittleDoor.EMPTY_OPENING_RESULT, false) : (child instanceof IAnimatedStructure ? ((IAnimatedStructure)((Object)child)).getAnimation() : null);
            GuiParent parent = new GuiParent("temp", 0, 0, 0, 0){};
            AnimationGuiHandler.AnimationGuiHolder holder = new AnimationGuiHandler.AnimationGuiHolder(previews.getChildren().get(this.childId), new AnimationGuiHandler(this.getTick(), handler), child, childAnimation);
            LittleStructureGuiParser parser = LittleStructureRegistry.getParser(parent, holder.handler, LittleStructureRegistry.getParserClass("structure." + child.type.id + ".name"));
            parser.createControls(holder.previews, holder.previews.getStructure());
            if (holder.handler.hasTimeline()) {
                handler.subHolders.add(holder);
            }
        }
    }
}

