/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.mc.ChatFormatting;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredient;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class ColorIngredient
extends LittleIngredient<ColorIngredient> {
    private int limit = -1;
    public int black;
    public int cyan;
    public int magenta;
    public int yellow;
    public static float dyeToBlockPercentage = 4096.0f;

    public ColorIngredient() {
        this.yellow = 0;
        this.magenta = 0;
        this.cyan = 0;
        this.black = 0;
    }

    public ColorIngredient(int[] array) {
        if (array.length != 4) {
            throw new IllegalArgumentException("Invalid array " + array + "!");
        }
        this.black = array[0];
        this.cyan = array[1];
        this.magenta = array[2];
        this.yellow = array[3];
    }

    public ColorIngredient(int black, int cyan, int magenta, int yellow) {
        this.black = black;
        this.cyan = cyan;
        this.magenta = magenta;
        this.yellow = yellow;
    }

    public ColorIngredient setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int[] getArray() {
        return new int[]{this.black, this.cyan, this.magenta, this.yellow};
    }

    @Override
    public void print(List<String> lines, List<ItemStack> stacks) {
        if (this.black > 0) {
            lines.add(this.getBlackDescription());
            stacks.add(ItemStack.field_190927_a);
        }
        if (this.cyan > 0) {
            lines.add(this.getCyanDescription());
            stacks.add(ItemStack.field_190927_a);
        }
        if (this.magenta > 0) {
            lines.add(this.getMagentaDescription());
            stacks.add(ItemStack.field_190927_a);
        }
        if (this.yellow > 0) {
            lines.add(this.getYellowDescription());
            stacks.add(ItemStack.field_190927_a);
        }
    }

    private static String getUnit(int number) {
        if (number == 1) {
            return I18n.func_74838_a((String)"color.unit.single");
        }
        return I18n.func_74838_a((String)"color.unit.multiple");
    }

    public String getBlackDescription() {
        return this.black + " " + ChatFormatting.DARK_GRAY + I18n.func_74838_a((String)"color.unit.black") + ChatFormatting.WHITE + " " + ColorIngredient.getUnit(this.black);
    }

    public String getCyanDescription() {
        return this.cyan + " " + ChatFormatting.AQUA + I18n.func_74838_a((String)"color.unit.cyan") + ChatFormatting.WHITE + " " + ColorIngredient.getUnit(this.cyan);
    }

    public String getMagentaDescription() {
        return this.magenta + " " + ChatFormatting.LIGHT_PURPLE + I18n.func_74838_a((String)"color.unit.magenta") + ChatFormatting.WHITE + " " + ColorIngredient.getUnit(this.magenta);
    }

    public String getYellowDescription() {
        return this.yellow + " " + ChatFormatting.YELLOW + I18n.func_74838_a((String)"color.unit.yellow") + ChatFormatting.WHITE + " " + ColorIngredient.getUnit(this.yellow);
    }

    public String toString() {
        return "[back=" + this.black + ",cyan=" + this.cyan + ",magenta=" + this.magenta + ",yellow=" + this.yellow + "]";
    }

    @Override
    public ColorIngredient add(ColorIngredient ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        ColorIngredient remaining = null;
        this.black += ingredient.black;
        if (this.limit > 0 && this.black > this.limit) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.black = this.black - this.limit;
            this.black = this.limit;
        }
        this.cyan += ingredient.cyan;
        if (this.limit > 0 && this.cyan > this.limit) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.cyan = this.cyan - this.limit;
            this.cyan = this.limit;
        }
        this.magenta += ingredient.magenta;
        if (this.limit > 0 && this.magenta > this.limit) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.magenta = this.magenta - this.limit;
            this.magenta = this.limit;
        }
        this.yellow += ingredient.yellow;
        if (this.limit > 0 && this.yellow > this.limit) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.yellow = this.yellow - this.limit;
            this.yellow = this.limit;
        }
        return remaining;
    }

    @Override
    public ColorIngredient sub(ColorIngredient ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        ColorIngredient remaining = null;
        this.black -= ingredient.black;
        if (this.black < 0) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.black = -this.black;
            this.black = this.limit;
        }
        this.cyan -= ingredient.cyan;
        if (this.cyan < 0) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.cyan = -this.cyan;
            this.cyan = this.limit;
        }
        this.magenta -= ingredient.magenta;
        if (this.magenta < 0) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.magenta = -this.magenta;
            this.magenta = this.limit;
        }
        this.yellow -= ingredient.yellow;
        if (this.yellow < 0) {
            if (remaining == null) {
                remaining = new ColorIngredient();
            }
            remaining.yellow = -this.yellow;
            this.yellow = this.limit;
        }
        return remaining;
    }

    @Override
    public ColorIngredient copy() {
        ColorIngredient copy = new ColorIngredient(this.black, this.cyan, this.magenta, this.yellow);
        copy.limit = this.limit;
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.black == 0 && this.cyan == 0 && this.magenta == 0 && this.yellow == 0;
    }

    @Override
    public void scale(int count) {
        this.black *= count;
        this.cyan *= count;
        this.magenta *= count;
        this.yellow *= count;
    }

    @Override
    public int getMinimumCount(ColorIngredient other, int availableCount) {
        int count = -1;
        if (this.black > 0 && other.black > 0) {
            count = Math.max(count, this.black / other.black);
        }
        if (this.cyan > 0 && other.cyan > 0) {
            count = Math.max(count, this.cyan / other.cyan);
        }
        if (this.magenta > 0 && other.magenta > 0) {
            count = Math.max(count, this.magenta / other.magenta);
        }
        if (this.yellow > 0 && other.yellow > 0) {
            count = Math.max(count, this.yellow / other.yellow);
        }
        return Math.min(availableCount, count);
    }

    public void scale(double scale) {
        this.black = (int)Math.ceil((double)this.black * scale);
        this.cyan = (int)Math.ceil((double)this.cyan * scale);
        this.magenta = (int)Math.ceil((double)this.magenta * scale);
        this.yellow = (int)Math.ceil((double)this.yellow * scale);
    }

    public void scaleLoose(double scale) {
        this.black = (int)Math.floor((double)this.black * scale);
        this.cyan = (int)Math.floor((double)this.cyan * scale);
        this.magenta = (int)Math.floor((double)this.magenta * scale);
        this.yellow = (int)Math.floor((double)this.yellow * scale);
    }

    @Override
    public String print(List<Object> objects) {
        String text = "";
        if (this.black > 0) {
            text = text + this.getBlackDescription();
        }
        if (this.cyan > 0) {
            text = text + (text.isEmpty() ? "" : " ") + this.getCyanDescription();
        }
        if (this.magenta > 0) {
            text = text + (text.isEmpty() ? "" : " ") + this.getMagentaDescription();
        }
        if (this.yellow > 0) {
            text = text + (text.isEmpty() ? "" : " ") + this.getYellowDescription();
        }
        return text;
    }

    public static ColorIngredient getColors(LittleTilePreview preview, double volume) {
        if (preview.hasColor()) {
            ColorIngredient color = ColorIngredient.getColors(preview.getColor());
            color.scale(volume);
            return color;
        }
        return null;
    }

    public static ColorIngredient getColors(LittleGridContext context, LittleTilePreview preview) {
        return ColorIngredient.getColors(preview, preview.getPercentVolume(context));
    }

    public static ColorIngredient getColors(int color) {
        float cmyk_scale = dyeToBlockPercentage;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (r == 0 && g == 0 && b == 0) {
            return new ColorIngredient((int)cmyk_scale, 0, 0, 0);
        }
        float c = 1.0f - (float)r / 255.0f;
        float m = 1.0f - (float)g / 255.0f;
        float y = 1.0f - (float)b / 255.0f;
        float min_cmy = Math.min(c, Math.min(m, y));
        c = (c - min_cmy) / (1.0f - min_cmy);
        m = (m - min_cmy) / (1.0f - min_cmy);
        y = (y - min_cmy) / (1.0f - min_cmy);
        float k = min_cmy;
        return new ColorIngredient((int)(k * cmyk_scale), (int)(c * cmyk_scale), (int)(m * cmyk_scale), (int)(y * cmyk_scale));
    }
}

