/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.api.ILittleInventory;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredient;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredients;
import com.creativemd.littletiles.common.utils.ingredients.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class LittleInventory
implements Iterable<ItemStack> {
    private boolean simulate;
    protected EntityPlayer player;
    protected IInventory inventory;
    protected List<LittleIngredients> inventories;
    protected List<Integer> inventoriesId;
    protected List<ItemStack> cachedInventory;
    protected List<LittleIngredients> cachedInventories;

    public LittleInventory(EntityPlayer player) {
        this(player, (IInventory)player.field_71071_by);
    }

    public LittleInventory(IInventory inventory) {
        this(null, inventory);
    }

    public LittleInventory(EntityPlayer player, IInventory inventory) {
        this.player = player;
        this.inventory = inventory;
        this.inventories = new ArrayList<LittleIngredients>();
        this.inventoriesId = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ILittleInventory)) continue;
            this.inventories.add(((ILittleInventory)stack.func_77973_b()).getInventory(stack));
            this.inventoriesId.add(i);
        }
    }

    public boolean isSimulation() {
        return this.simulate;
    }

    public void startSimulation() {
        this.cachedInventory = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            this.cachedInventory.add(this.inventory.func_70301_a(i).func_77946_l());
        }
        this.cachedInventories = new ArrayList<LittleIngredients>();
        this.inventories.forEach(x -> this.cachedInventories.add(x.copy()));
        this.simulate = true;
    }

    public void stopSimulation() {
        this.simulate = false;
        this.cachedInventory = null;
    }

    public boolean addStack(ItemStack stack) {
        int i;
        for (i = 0; i < this.size(); ++i) {
            int amount;
            ItemStack inventoryStack = this.get(i);
            if (!InventoryUtils.isItemStackEqual((ItemStack)inventoryStack, (ItemStack)stack) || (amount = Math.min(stack.func_77976_d() - inventoryStack.func_190916_E(), stack.func_190916_E())) <= 0) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(inventoryStack.func_190916_E() + amount);
            this.set(i, newStack);
            stack.func_190918_g(amount);
            if (!stack.func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < this.size(); ++i) {
            if (!this.get(i).func_190926_b()) continue;
            this.set(i, stack);
            return true;
        }
        return false;
    }

    public void addOrDropStacks(List<ItemStack> stacks) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        ArrayList<ItemStack> toDrop = null;
        for (ItemStack stack : stacks) {
            if (this.addStack(stack)) continue;
            if (toDrop == null) {
                toDrop = new ArrayList<ItemStack>();
            }
            toDrop.add(stack);
        }
        if (toDrop != null) {
            if (this.player == null) {
                throw new NotEnoughIngredientsException.NotEnoughSpaceException(new StackIngredient(toDrop));
            }
            if (!this.simulate) {
                WorldUtils.dropItem((EntityPlayer)this.player, toDrop);
            }
        }
    }

    public void set(int index, ItemStack stack) {
        if (this.simulate) {
            this.cachedInventory.set(index, stack);
        } else {
            this.inventory.func_70299_a(index, stack);
        }
    }

    public ItemStack get(int index) {
        return this.simulate ? this.cachedInventory.get(index) : this.inventory.func_70301_a(index);
    }

    public int size() {
        return this.simulate ? this.cachedInventory.size() : this.inventory.func_70302_i_();
    }

    @Override
    public Iterator<ItemStack> iterator() {
        if (this.simulate) {
            return this.cachedInventory.iterator();
        }
        return new Iterator<ItemStack>(){
            public int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < LittleInventory.this.inventory.func_70302_i_();
            }

            @Override
            public ItemStack next() {
                return LittleInventory.this.inventory.func_70301_a(this.index++);
            }
        };
    }

    protected LittleIngredient take(LittleIngredient ingredient) throws NotEnoughIngredientsException {
        List<LittleIngredients> inv = this.simulate ? this.cachedInventories : this.inventories;
        for (LittleIngredients ingredients : inv) {
            ingredient = ingredients.sub(ingredient);
            if (ingredient != null) continue;
            return null;
        }
        return ingredient;
    }

    public void take(LittleIngredients ingredients) throws NotEnoughIngredientsException {
        block7: {
            for (LittleIngredient ingredient : ingredients.getContent()) {
                if (ingredient == null) continue;
                ingredients.set(ingredient.getClass(), this.take(ingredient));
            }
            if (!ingredients.isEmpty()) {
                LittleIngredients overflow = new LittleIngredients();
                for (int i = 0; i < this.size(); ++i) {
                    int amount;
                    ItemStack stack = this.get(i);
                    LittleIngredients stackIngredients = LittleIngredient.extractWithoutCount(stack, false);
                    if (stackIngredients == null || (amount = ingredients.getMinimumCount(stackIngredients, stack.func_190916_E())) <= -1) continue;
                    stackIngredients.scale(amount);
                    overflow.add(ingredients.sub(stackIngredients));
                    stack.func_190918_g(amount);
                    if (ingredients.isEmpty()) break;
                }
                if (!ingredients.isEmpty()) {
                    throw new NotEnoughIngredientsException(ingredients);
                }
                if (!overflow.isEmpty()) {
                    try {
                        this.give(overflow);
                    }
                    catch (NotEnoughIngredientsException.NotEnoughSpaceException e) {
                        List<ItemStack> stacks = overflow.handleOverflow();
                        if (stacks == null || stacks.isEmpty()) break block7;
                        this.addOrDropStacks(stacks);
                    }
                }
            }
        }
        this.saveInventories();
    }

    protected LittleIngredient give(LittleIngredient ingredient) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        List<LittleIngredients> inv = this.simulate ? this.cachedInventories : this.inventories;
        for (LittleIngredients ingredients : inv) {
            ingredient = ingredients.add(ingredient);
            if (ingredient != null) continue;
            return null;
        }
        try {
            List<ItemStack> stacks = LittleIngredient.handleOverflow(ingredient);
            if (stacks != null) {
                this.addOrDropStacks(stacks);
            }
            return null;
        }
        catch (NotEnoughIngredientsException.NotEnoughSpaceException e) {
            return ingredient;
        }
    }

    public void give(LittleIngredients ingredients) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        LittleIngredients remainings = new LittleIngredients();
        for (LittleIngredient ingredient : ingredients.getContent()) {
            if (ingredient == null) continue;
            remainings.set(ingredient.getClass(), this.give(ingredient));
        }
        if (!remainings.isEmpty()) {
            throw new NotEnoughIngredientsException.NotEnoughSpaceException(remainings);
        }
        this.saveInventories();
    }

    public void saveInventories() {
        for (int i = 0; i < this.inventoriesId.size(); ++i) {
            int index = this.inventoriesId.get(i);
            ItemStack stack = this.get(index);
            ((ILittleInventory)stack.func_77973_b()).setInventory(stack, this.simulate ? this.cachedInventories.get(i) : this.inventories.get(i));
        }
    }
}

