/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredient;
import com.creativemd.littletiles.common.utils.ingredients.LittleIngredients;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredient;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredientEntry;
import com.creativemd.littletiles.common.utils.tooltip.ActionMessage;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class NotEnoughIngredientsException
extends LittleActionException {
    protected LittleIngredients ingredients;

    protected NotEnoughIngredientsException(String msg, LittleIngredient ingredient) {
        super(msg);
        this.ingredients = new LittleIngredients();
        this.ingredients.set(ingredient.getClass(), ingredient);
    }

    protected NotEnoughIngredientsException(String msg, LittleIngredients ingredients) {
        super(msg);
        this.ingredients = ingredients;
    }

    public NotEnoughIngredientsException(LittleIngredient ingredient) {
        this("exception.ingredient.missing", ingredient);
    }

    public NotEnoughIngredientsException(ItemStack stack) {
        this(new StackIngredient());
        this.ingredients.get(StackIngredient.class).add(new StackIngredientEntry(stack, stack.func_190916_E()));
    }

    public NotEnoughIngredientsException(LittleIngredients ingredients) {
        super("exception.ingredient.missing");
        this.ingredients = ingredients;
    }

    public LittleIngredients getIngredients() {
        return this.ingredients;
    }

    @Override
    public ActionMessage getActionMessage() {
        String message = this.getLocalizedMessage() + "\n";
        ArrayList<Object> objects = new ArrayList<Object>();
        for (LittleIngredient ingredient : this.ingredients) {
            message = message + ingredient.print(objects);
        }
        return new ActionMessage(message, objects.toArray());
    }

    public static class NotEnoughSpaceException
    extends NotEnoughIngredientsException {
        public NotEnoughSpaceException(LittleIngredient ingredient) {
            super("exception.ingredient.space", ingredient);
        }

        public NotEnoughSpaceException(LittleIngredients ingredients) {
            super("exception.ingredient.space", ingredients);
        }

        public NotEnoughSpaceException(ItemStack stack) {
            this(new StackIngredient());
            this.ingredients.get(StackIngredient.class).add(new StackIngredientEntry(stack, stack.func_190916_E()));
        }
    }
}

