/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.selection.selector;

import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.selection.selector.AndSelector;
import com.creativemd.littletiles.common.utils.selection.selector.AnySelector;
import com.creativemd.littletiles.common.utils.selection.selector.ColorSelector;
import com.creativemd.littletiles.common.utils.selection.selector.NoStructureSelector;
import com.creativemd.littletiles.common.utils.selection.selector.NotSelector;
import com.creativemd.littletiles.common.utils.selection.selector.OrSelector;
import com.creativemd.littletiles.common.utils.selection.selector.StateSelector;
import com.creativemd.littletiles.common.utils.selection.selector.TileSelectorBlock;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileSelector {
    private static HashMap<String, Class<? extends TileSelector>> selectorTypes = new HashMap();

    public static void registerType(String id, Class<? extends TileSelector> type) {
        selectorTypes.put(id, type);
    }

    public static String getTypeID(Class<? extends TileSelector> type) {
        for (Map.Entry<String, Class<? extends TileSelector>> entry : selectorTypes.entrySet()) {
            if (type != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Class<? extends TileSelector> getType(String id) {
        return selectorTypes.get(id);
    }

    public static TileSelector loadSelector(String id, NBTTagCompound nbt) {
        Class<? extends TileSelector> type = TileSelector.getType(id);
        if (type != null) {
            try {
                TileSelector selector = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                selector.loadNBT(nbt);
                return selector;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Selector type " + nbt.func_74779_i("type") + " is missing an empty constructor!");
            }
        }
        System.out.println("Selector " + nbt.func_74779_i("type") + " could not be found!");
        return null;
    }

    public static TileSelector loadSelector(NBTTagCompound nbt) {
        Class<? extends TileSelector> type = TileSelector.getType(nbt.func_74779_i("type"));
        if (type != null) {
            try {
                TileSelector selector = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                selector.loadNBT(nbt);
                return selector;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Selector type " + nbt.func_74779_i("type") + " is missing an empty constructor!");
            }
        }
        System.out.println("Selector " + nbt.func_74779_i("type") + " could not be found!");
        return null;
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.saveNBT(nbt);
        nbt.func_74778_a("type", TileSelector.getTypeID(this.getClass()));
        return nbt;
    }

    protected abstract void saveNBT(NBTTagCompound var1);

    protected abstract void loadNBT(NBTTagCompound var1);

    public abstract boolean is(LittleTile var1);

    public static LittleBoxes getAbsoluteBoxes(World world, BlockPos pos, BlockPos pos2, TileSelector selector) {
        LittleBoxes boxes = new LittleBoxes(pos, LittleGridContext.getMin());
        int minX = Math.min(pos.func_177958_n(), pos2.func_177958_n());
        int maxX = Math.max(pos.func_177958_n(), pos2.func_177958_n());
        int minY = Math.min(pos.func_177956_o(), pos2.func_177956_o());
        int maxY = Math.max(pos.func_177956_o(), pos2.func_177956_o());
        int minZ = Math.min(pos.func_177952_p(), pos2.func_177952_p());
        int maxZ = Math.max(pos.func_177952_p(), pos2.func_177952_p());
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
        for (int posX = minX; posX <= maxX; ++posX) {
            for (int posY = minY; posY <= maxY; ++posY) {
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    position.func_181079_c(posX, posY, posZ);
                    TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, (BlockPos)position);
                    if (te == null) continue;
                    for (LittleTile tile : te) {
                        if (!selector.is(tile)) continue;
                        boxes.addBox(tile);
                    }
                }
            }
        }
        return boxes;
    }

    public static List<LittleTileBox> getBoxes(World world, BlockPos pos, TileSelector selector) {
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        for (LittleTile tile : te) {
            if (!selector.is(tile)) continue;
            boxes.add(tile.box);
        }
        return boxes;
    }

    static {
        TileSelector.registerType("any", AnySelector.class);
        TileSelector.registerType("and", AndSelector.class);
        TileSelector.registerType("or", OrSelector.class);
        TileSelector.registerType("not", NotSelector.class);
        TileSelector.registerType("block", TileSelectorBlock.class);
        TileSelector.registerType("state", StateSelector.class);
        TileSelector.registerType("color", ColorSelector.class);
        TileSelector.registerType("nostructure", NoStructureSelector.class);
    }
}

