/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.shape;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.shape.DragShape;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SelectShape {
    public static LinkedHashMap<String, SelectShape> shapes = new LinkedHashMap();
    public static SelectShape tileShape = new SelectShape("tile"){

        @Override
        public boolean shouldBeRegistered() {
            return false;
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return true;
        }

        @Override
        public LittleBoxes getHighlightBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return this.getBoxes(player, nbt, result, context);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
            return new ArrayList<GuiControl>();
        }

        @Override
        public LittleBoxes getBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            LittleBoxes boxes;
            BlockTile.TEResult te = BlockTile.loadTeAndTile((IBlockAccess)player.field_70170_p, result.func_178782_a(), player);
            if (te.isComplete()) {
                boxes = new LittleBoxes(te.te.func_174877_v(), te.te.getContext());
                boxes.add(te.tile.box.copy());
            } else {
                boxes = new LittleBoxes(result.func_178782_a(), context);
            }
            return boxes;
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
        }
    };
    public static BasicSelectShape CUBE = new BasicSelectShape("cube"){

        @Override
        public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side, LittleGridContext context) {
            LittleTileVec offset = new LittleTileVec(side);
            offset.scale((thickness - 1) / 2);
            vec.sub(offset);
            if ((thickness & 1) == 0 && side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                vec.sub(side);
            }
            LittleTileBox box = new LittleTileBox(vec, new LittleTileSize(thickness, thickness, thickness));
            return box;
        }
    };
    public static BasicSelectShape BAR = new BasicSelectShape("bar"){

        @Override
        public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side, LittleGridContext context) {
            LittleTileBox box = CUBE.getBox(vec, thickness, side, context);
            switch (side.func_176740_k()) {
                case X: {
                    box.minX = 0;
                    box.maxX = context.size;
                    break;
                }
                case Y: {
                    box.minY = 0;
                    box.maxY = context.size;
                    break;
                }
                case Z: {
                    box.minZ = 0;
                    box.maxZ = context.size;
                }
            }
            return box;
        }
    };
    public static BasicSelectShape PLANE = new BasicSelectShape("plane"){

        @Override
        public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side, LittleGridContext context) {
            LittleTileBox box = CUBE.getBox(vec, thickness, side, context);
            switch (side.func_176740_k()) {
                case X: {
                    box.minY = 0;
                    box.maxY = context.size;
                    box.minZ = 0;
                    box.maxZ = context.size;
                    break;
                }
                case Y: {
                    box.minX = 0;
                    box.maxX = context.size;
                    box.minZ = 0;
                    box.maxZ = context.size;
                    break;
                }
                case Z: {
                    box.minX = 0;
                    box.maxX = context.size;
                    box.minY = 0;
                    box.maxY = context.size;
                }
            }
            return box;
        }
    };
    public static SelectShape defaultShape = CUBE;
    public final String key;

    public static SelectShape getShape(String name) {
        SelectShape shape = shapes.get(name);
        return shape == null ? defaultShape : shape;
    }

    public SelectShape(String name) {
        if (this.shouldBeRegistered()) {
            shapes.put(name, this);
        }
        this.key = name;
    }

    public boolean shouldBeRegistered() {
        return true;
    }

    public abstract LittleBoxes getHighlightBoxes(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3, LittleGridContext var4);

    public abstract boolean rightClick(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3, LittleGridContext var4);

    public abstract boolean leftClick(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3, LittleGridContext var4);

    public abstract void deselect(EntityPlayer var1, NBTTagCompound var2, LittleGridContext var3);

    public abstract LittleBoxes getBoxes(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3, LittleGridContext var4);

    public abstract void addExtraInformation(World var1, NBTTagCompound var2, List<String> var3, LittleGridContext var4);

    @SideOnly(value=Side.CLIENT)
    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1, LittleGridContext var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, NBTTagCompound var2, LittleGridContext var3);

    public void rotate(Rotation rotation, NBTTagCompound nbt) {
    }

    public void flip(EnumFacing.Axis axis, NBTTagCompound nbt) {
    }

    public static class DragSelectShape
    extends SelectShape {
        private final DragShape shape;
        public LittleTilePos first;

        public DragSelectShape(DragShape shape) {
            super("drag" + shape.key);
            this.shape = shape;
        }

        public LittleBoxes getBoxes(EntityPlayer player, NBTTagCompound nbt, LittleTilePos min, LittleTilePos max, boolean preview, LittleGridContext context) {
            min.ensureBothAreEqual(max);
            LittleTilePos offset = new LittleTilePos(min.pos, min.getContext());
            LittleTileBox box = new LittleTileBox(new LittleTileBox(min.getRelative(offset).getVec(context)), new LittleTileBox(max.getRelative(offset).getVec(context)));
            return this.shape.getBoxes(new LittleBoxes(offset.pos, context), box.getMinVec(), box.getMaxVec(), player, nbt, preview, min, max);
        }

        @Override
        public LittleBoxes getHighlightBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            LittleTilePos vec = new LittleTilePos(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(RotationUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.contextVec.vec.sub(result.field_178784_b);
            }
            if (this.first == null) {
                LittleBoxes boxes = new LittleBoxes(result.func_178782_a(), context);
                boxes.add(new LittleTileBox(vec.getRelative(new LittleTilePos(result.func_178782_a(), context)).getVec(context)));
                return boxes;
            }
            return this.getBoxes(player, nbt, this.first, vec, true, context);
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            if (this.first != null) {
                return true;
            }
            this.first = new LittleTilePos(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(RotationUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                this.first.contextVec.vec.sub(result.field_178784_b);
            }
            return false;
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
            this.first = null;
        }

        @Override
        public LittleBoxes getBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            LittleTilePos vec = new LittleTilePos(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(RotationUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.contextVec.vec.sub(result.field_178784_b);
            }
            LittleBoxes boxes = this.getBoxes(player, nbt, this.first, vec, false, context);
            this.first = null;
            return boxes;
        }

        @Override
        public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
            this.shape.addExtraInformation(nbt, list);
        }

        @Override
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
            return this.shape.getCustomSettings(nbt, context);
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
            this.shape.saveCustomSettings(gui, nbt, context);
        }

        @Override
        public void flip(EnumFacing.Axis axis, NBTTagCompound nbt) {
            this.shape.flip(nbt, axis);
        }

        @Override
        public void rotate(Rotation rotation, NBTTagCompound nbt) {
            this.shape.rotate(nbt, rotation);
        }
    }

    public static abstract class BasicSelectShape
    extends SelectShape {
        public BasicSelectShape(String name) {
            super(name);
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt, LittleGridContext context) {
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            return true;
        }

        @Override
        public LittleBoxes getHighlightBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            int thickness = nbt.func_74762_e("thick");
            if (thickness > context.size) {
                thickness = context.size;
                nbt.func_74768_a("thick", thickness);
            }
            LittleBoxes boxes = new LittleBoxes(result.func_178782_a(), context);
            LittleTilePos vec = new LittleTilePos(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(RotationUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.contextVec.vec.sub(result.field_178784_b);
            }
            boxes.add(this.getBox(vec.getRelative(new LittleTilePos(result.func_178782_a(), context)).getVec(context), Math.max(1, nbt.func_74762_e("thick")), result.field_178784_b, context));
            return boxes;
        }

        @Override
        public LittleBoxes getBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result, LittleGridContext context) {
            int thickness = nbt.func_74762_e("thick");
            if (thickness > context.size) {
                thickness = context.size;
                nbt.func_74768_a("thick", thickness);
            }
            LittleBoxes boxes = new LittleBoxes(result.func_178782_a(), context);
            LittleTilePos vec = new LittleTilePos(result, context);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && context.isAtEdge(RotationUtils.get((EnumFacing.Axis)result.field_178784_b.func_176740_k(), (Vec3d)result.field_72307_f))) {
                vec.contextVec.vec.sub(result.field_178784_b);
            }
            boxes.add(this.getBox(vec.getRelative(new LittleTilePos(result.func_178782_a(), context)).getVec(context), Math.max(1, nbt.func_74762_e("thick")), result.field_178784_b, context));
            return boxes;
        }

        @Override
        public void addExtraInformation(World world, NBTTagCompound nbt, List<String> list, LittleGridContext context) {
            list.add("thickness: " + Math.max(1, nbt.func_74762_e("thick")));
        }

        public abstract LittleTileBox getBox(LittleTileVec var1, int var2, EnumFacing var3, LittleGridContext var4);

        @Override
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
            ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
            controls.add((GuiControl)new GuiLabel("Size:", 0, 6));
            controls.add((GuiControl)new GuiSteppedSlider("thickness", 35, 5, 68, 10, Math.max(1, nbt.func_74762_e("thick")), 1, context.size));
            return controls;
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
            GuiSteppedSlider thickness = (GuiSteppedSlider)gui.get("thickness");
            nbt.func_74768_a("thick", (int)thickness.value);
        }
    }
}

