/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.tooltip;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.gui.controls.GuiActionDisplay;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class ActionMessage {
    public int height;
    public int width;
    public final List<ActionLine> lines = new ArrayList<ActionLine>();
    public final long timestamp;

    public ActionMessage(String text, Object ... objects) {
        ActionLine line;
        int i;
        ArrayList<Object> lineObjects = new ArrayList<Object>();
        int tempWidth = 0;
        int first = 0;
        block0: for (i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                if (first == i) {
                    ++first;
                    continue;
                }
                lineObjects.add(text.substring(first, i));
                line = new ActionLine(new ArrayList<Object>(lineObjects));
                tempWidth = Math.max(tempWidth, line.width);
                this.lines.add(line);
                lineObjects.clear();
                first = i + 1;
                continue;
            }
            if (text.charAt(i) != '{') continue;
            for (int j = i + 1; j < text.length(); ++j) {
                if (Character.isDigit(text.charAt(j))) continue;
                if (text.charAt(j) != '}') continue block0;
                if (first != i) {
                    lineObjects.add(text.substring(first, i));
                }
                lineObjects.add(objects[Integer.parseInt(text.substring(i + 1, j))]);
                first = j + 1;
                i = j;
                continue block0;
            }
        }
        if (first != i) {
            lineObjects.add(text.substring(first, i));
        }
        if (!lineObjects.isEmpty()) {
            line = new ActionLine(new ArrayList<Object>(lineObjects));
            tempWidth = Math.max(tempWidth, line.width);
            this.lines.add(line);
        }
        this.width = tempWidth;
        this.height = (GuiActionDisplay.font.field_78288_b + 3) * this.lines.size();
        this.timestamp = System.currentTimeMillis();
    }

    public void render(GuiRenderHelper helper, float alpha) {
        GlStateManager.func_179094_E();
        int color = ColorUtils.RGBAToInt((int)255, (int)255, (int)255, (int)((int)(alpha * 255.0f)));
        for (int i = 0; i < this.lines.size(); ++i) {
            ActionLine line = this.lines.get(i);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-line.width / 2), (float)0.0f, (float)0.0f);
            for (int j = 0; j < line.objects.size(); ++j) {
                int objWidth;
                Object obj = line.objects.get(j);
                if (obj instanceof String) {
                    helper.font.func_78276_b((String)obj, 0, 0, color);
                    objWidth = helper.font.func_78256_a((String)obj);
                } else if (obj instanceof ItemStack) {
                    objWidth = 20;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    helper.drawItemStack((ItemStack)obj, 2, -4, 16, 16, 0, color);
                } else {
                    objWidth = 0;
                }
                GlStateManager.func_179109_b((float)objWidth, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)(GuiActionDisplay.font.field_78288_b + 3), (float)0.0f);
        }
        GlStateManager.func_179121_F();
    }

    public int getObjectWidth(Object object) {
        if (object instanceof ItemStack) {
            return 20;
        }
        if (object instanceof String) {
            return GuiActionDisplay.font.func_78256_a((String)object);
        }
        return 0;
    }

    public class ActionLine {
        public final List<Object> objects;
        public final int width;

        public ActionLine(List<Object> objects) {
            this.objects = objects;
            int lineWidth = 0;
            for (int i = 0; i < objects.size(); ++i) {
                lineWidth += ActionMessage.this.getObjectWidth(objects.get(i));
            }
            this.width = lineWidth;
        }
    }
}

