/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.vec;

import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class SurroundingBox {
    protected int count = 0;
    protected LittleGridContext context = LittleGridContext.getMin();
    protected long minX = Long.MAX_VALUE;
    protected long minY = Long.MAX_VALUE;
    protected long minZ = Long.MAX_VALUE;
    protected long maxX = Long.MIN_VALUE;
    protected long maxY = Long.MIN_VALUE;
    protected long maxZ = Long.MIN_VALUE;
    protected int minYPos = Integer.MAX_VALUE;
    protected int maxYPos = Integer.MIN_VALUE;
    protected boolean mapScannedLists = false;
    protected HashMap<BlockPos, List<LittleTile>> map = new HashMap();

    public SurroundingBox(boolean mapScannedLists) {
        this.mapScannedLists = mapScannedLists;
    }

    public void clear() {
        this.count = 0;
        this.context = LittleGridContext.getMin();
        this.minX = Long.MAX_VALUE;
        this.minY = Long.MAX_VALUE;
        this.minZ = Long.MAX_VALUE;
        this.maxX = Long.MIN_VALUE;
        this.maxY = Long.MIN_VALUE;
        this.maxZ = Long.MIN_VALUE;
        this.minYPos = Integer.MAX_VALUE;
        this.maxYPos = Integer.MIN_VALUE;
        this.map.clear();
    }

    protected void convertTo(LittleGridContext to) {
        if (this.count == 0) {
            this.context = to;
            return;
        }
        if (this.context.size > to.size) {
            int modifier = this.context.size / to.size;
            this.minX /= (long)modifier;
            this.minY /= (long)modifier;
            this.minZ /= (long)modifier;
            this.maxX /= (long)modifier;
            this.maxY /= (long)modifier;
            this.maxZ /= (long)modifier;
        } else {
            int modifier = to.size / this.context.size;
            this.minX *= (long)modifier;
            this.minY *= (long)modifier;
            this.minZ *= (long)modifier;
            this.maxX *= (long)modifier;
            this.maxY *= (long)modifier;
            this.maxZ *= (long)modifier;
        }
        this.context = to;
    }

    protected boolean insertContext(LittleGridContext to) {
        if (this.context.size > to.size) {
            return false;
        }
        if (this.context.size < to.size) {
            this.convertTo(to);
        }
        return true;
    }

    public SurroundingBox add(Set<Map.Entry<TileEntityLittleTiles, ArrayList<LittleTile>>> entrySet) {
        for (Map.Entry<TileEntityLittleTiles, ArrayList<LittleTile>> entry : entrySet) {
            this.add(entry.getKey().getContext(), entry.getKey().func_174877_v(), (List<LittleTile>)entry.getValue());
        }
        return this;
    }

    public SurroundingBox add(LittleGridContext context, BlockPos pos, List<LittleTile> tiles) {
        int modifier = 1;
        if (!this.insertContext(context)) {
            modifier = this.context.size / context.size;
        }
        for (LittleTile tile : tiles) {
            this.add(tile.box, modifier, pos);
        }
        if (this.mapScannedLists) {
            this.map.put(pos, tiles);
        }
        return this;
    }

    protected void add(LittleTileBox box, int modifier, BlockPos pos) {
        this.minX = Math.min(this.minX, (long)(pos.func_177958_n() * this.context.size + box.minX * modifier));
        this.minY = Math.min(this.minY, (long)(pos.func_177956_o() * this.context.size + box.minY * modifier));
        this.minZ = Math.min(this.minZ, (long)(pos.func_177952_p() * this.context.size + box.minZ * modifier));
        this.maxX = Math.max(this.maxX, (long)(pos.func_177958_n() * this.context.size + box.maxX * modifier));
        this.maxY = Math.max(this.maxY, (long)(pos.func_177956_o() * this.context.size + box.maxY * modifier));
        this.maxZ = Math.max(this.maxZ, (long)(pos.func_177952_p() * this.context.size + box.maxZ * modifier));
        this.minYPos = Math.min(this.minYPos, pos.func_177956_o());
        this.maxYPos = Math.max(this.maxYPos, pos.func_177956_o());
        ++this.count;
    }

    public AxisAlignedBB getSurroundingBox() {
        return new AxisAlignedBB(this.context.toVanillaGrid(this.minX), this.context.toVanillaGrid(this.minY), this.context.toVanillaGrid(this.minZ), this.context.toVanillaGrid(this.maxX), this.context.toVanillaGrid(this.maxY), this.context.toVanillaGrid(this.maxZ));
    }

    public LittleTilePos getHighestCenterPoint() {
        int centerX = (int)Math.floor((double)(this.minX + this.maxX) / (double)this.context.size / 2.0);
        int centerY = (int)Math.floor((double)(this.minY + this.maxY) / (double)this.context.size / 2.0);
        int centerZ = (int)Math.floor((double)(this.minZ + this.maxZ) / (double)this.context.size / 2.0);
        int centerTileX = (int)(Math.floor(this.minX + this.maxX) / 2.0) - centerX * this.context.size;
        int centerTileY = (int)(Math.floor(this.minY + this.maxY) / 2.0) - centerY * this.context.size;
        int centerTileZ = (int)(Math.floor(this.minZ + this.maxZ) / 2.0) - centerZ * this.context.size;
        LittleTilePos pos = new LittleTilePos(new BlockPos(centerX, this.minYPos, centerZ), this.context, new LittleTileVec(centerTileX, 0, centerTileZ));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = this.minYPos; y <= this.maxYPos; ++y) {
            List<LittleTile> tilesInCenter = this.map.get(blockPos.func_181079_c(centerX, y, centerZ));
            if (tilesInCenter == null || tilesInCenter.isEmpty()) continue;
            TileEntityLittleTiles te = tilesInCenter.get((int)0).te;
            te.convertTo(this.context);
            LittleTileBox box = new LittleTileBox(centerTileX, this.context.minPos, centerTileZ, centerTileX + 1, this.context.maxPos, centerTileZ + 1);
            if (this.context.size <= centerTileX) {
                box.minX = this.context.size - 1;
                box.maxX = this.context.size;
            }
            if (this.context.size <= centerTileZ) {
                box.minZ = this.context.size - 1;
                box.maxZ = this.context.size;
            }
            for (int i = 0; i < tilesInCenter.size(); ++i) {
                List<LittleTileBox> collision = tilesInCenter.get(i).getCollisionBoxes();
                for (int j = 0; j < collision.size(); ++j) {
                    LittleTileBox littleBox = collision.get(j);
                    if (!LittleTileBox.intersectsWith(box, littleBox)) continue;
                    pos.contextVec.context = te.getContext();
                    pos.contextVec.vec.y = Math.max((y - this.minYPos) * this.context.size + littleBox.maxY, pos.contextVec.vec.y);
                }
            }
            te.convertToSmallest();
        }
        pos.removeInternalBlockOffset();
        pos.convertToSmallest();
        return pos;
    }

    public Vec3d getHighestCenterVec() {
        int centerX = (int)Math.floor((double)(this.minX + this.maxX) / (double)this.context.size / 2.0);
        int centerY = (int)Math.floor((double)(this.minY + this.maxY) / (double)this.context.size / 2.0);
        int centerZ = (int)Math.floor((double)(this.minZ + this.maxZ) / (double)this.context.size / 2.0);
        int centerTileX = (int)(Math.floor(this.minX + this.maxX) / 2.0) - centerX * this.context.size;
        int centerTileY = (int)(Math.floor(this.minY + this.maxY) / 2.0) - centerY * this.context.size;
        int centerTileZ = (int)(Math.floor(this.minZ + this.maxZ) / 2.0) - centerZ * this.context.size;
        LittleTilePos pos = new LittleTilePos(new BlockPos(centerX, this.minYPos, centerZ), this.context, new LittleTileVec(centerTileX, 0, centerTileZ));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = this.minYPos; y <= this.maxYPos; ++y) {
            List<LittleTile> tilesInCenter = this.map.get(blockPos.func_181079_c(centerX, y, centerZ));
            if (tilesInCenter == null || tilesInCenter.isEmpty()) continue;
            TileEntityLittleTiles te = tilesInCenter.get((int)0).te;
            te.convertTo(this.context);
            LittleTileBox box = new LittleTileBox(centerTileX, this.context.minPos, centerTileZ, centerTileX + 1, this.context.maxPos, centerTileZ + 1);
            if (this.context.size >= centerTileX) {
                box.minX = this.context.size - 1;
                box.maxX = this.context.size;
            }
            if (this.context.size >= centerTileZ) {
                box.minZ = this.context.size - 1;
                box.maxZ = this.context.size;
            }
            for (int i = 0; i < tilesInCenter.size(); ++i) {
                List<LittleTileBox> collision = tilesInCenter.get(i).getCollisionBoxes();
                for (int j = 0; j < collision.size(); ++j) {
                    LittleTileBox littleBox = collision.get(j);
                    if (!LittleTileBox.intersectsWith(box, littleBox)) continue;
                    pos.contextVec.context = te.getContext();
                    pos.contextVec.vec.y = Math.max((y - this.minYPos) * this.context.size + littleBox.maxY, pos.contextVec.vec.y);
                }
            }
            te.convertToSmallest();
        }
        return new Vec3d(this.context.toVanillaGrid((double)(this.minX + this.maxX) / 2.0), pos.getPosY(), this.context.toVanillaGrid((double)(this.minZ + this.maxZ) / 2.0));
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMinY() {
        return this.minY;
    }

    public long getMinZ() {
        return this.minZ;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getMaxZ() {
        return this.maxZ;
    }

    public LittleGridContext getContext() {
        return this.context;
    }

    public int count() {
        return this.count;
    }
}

