/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock.tesr;

import com.google.common.base.Stopwatch;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import mod.chiselsandbits.chiseledblock.EnumTESRRenderState;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.render.chiseledblock.ChiselLayer;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBaked;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockBackgroundRender;
import mod.chiselsandbits.render.chiseledblock.tesr.GfxRenderState;
import mod.chiselsandbits.render.chiseledblock.tesr.TileLayerRenderCache;
import mod.chiselsandbits.render.chiseledblock.tesr.TileList;
import mod.chiselsandbits.render.chiseledblock.tesr.TileRenderCache;
import mod.chiselsandbits.render.chiseledblock.tesr.TileRenderChunk;
import mod.chiselsandbits.render.chiseledblock.tesr.UploadTracker;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ChisledBlockRenderChunkTESR
extends TileEntitySpecialRenderer<TileEntityBlockChiseledTESR> {
    public static final AtomicInteger pendingTess = new AtomicInteger(0);
    public static final AtomicInteger activeTess = new AtomicInteger(0);
    private static final ThreadPoolExecutor pool;
    private static ChisledBlockRenderChunkTESR instance;
    static int TESR_Regions_rendered;
    static int TESR_SI_Regions_rendered;
    private static final WeakHashMap<World, WorldTracker> worldTrackers;
    boolean runUpload = false;
    int lastFancy = -1;
    int isConfigured = 0;

    private void markRendered(boolean singleInstanceMode) {
        if (singleInstanceMode) {
            ++TESR_SI_Regions_rendered;
        } else {
            ++TESR_Regions_rendered;
        }
    }

    public static ChisledBlockRenderChunkTESR getInstance() {
        return instance;
    }

    private static WorldTracker getTracker() {
        World w = ClientSide.instance.getPlayer().field_70170_p;
        WorldTracker t = worldTrackers.get(w);
        if (t == null) {
            t = new WorldTracker();
            worldTrackers.put(w, t);
        }
        return t;
    }

    public static void addNextFrameTask(Runnable r) {
        ChisledBlockRenderChunkTESR.getTracker().nextFrameTasks.offer(r);
    }

    private void addFutureTracker(TileLayerRenderCache tlrc, TileRenderCache renderCache, BlockRenderLayer layer) {
        ChisledBlockRenderChunkTESR.getTracker().futureTrackers.add(new FutureTracker(tlrc, renderCache, layer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleFutureTracker(FutureTracker ft) {
        if (ft.future != null && ft.future.isDone()) {
            block13: {
                try {
                    Tessellator t = ft.future.get();
                    if (ft.future == ft.tlrc.future) {
                        ft.tlrc.waiting = true;
                        ChisledBlockRenderChunkTESR.getTracker().uploaders.offer(new UploadTracker(ft.renderCache, ft.layer, t));
                        break block13;
                    }
                    try {
                        t.func_178180_c().func_178977_d();
                    }
                    catch (IllegalStateException e) {
                        Log.logError("Bad Tessellator Behavior.", e);
                    }
                    ChisledBlockBackgroundRender.submitTessellator(t);
                }
                catch (InterruptedException e) {
                    Log.logError("Failed to get TESR Future - C", e);
                }
                catch (ExecutionException e) {
                    Log.logError("Failed to get TESR Future - D", e);
                }
                catch (CancellationException cancellationException) {
                }
                finally {
                    if (ft.future == ft.tlrc.future) {
                        ft.tlrc.future = null;
                    }
                }
            }
            ft.done();
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void debugScreen(RenderGameOverlayEvent.Text t) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            if (TESR_Regions_rendered > 0 || TESR_SI_Regions_rendered > 0) {
                t.getRight().add("C&B DynRender: " + TESR_Regions_rendered + ":" + TESR_SI_Regions_rendered + " - " + (GfxRenderState.useVBO() ? "VBO" : "DspList"));
                TESR_Regions_rendered = 0;
                TESR_SI_Regions_rendered = 0;
            }
        } else {
            TESR_Regions_rendered = 0;
            TESR_SI_Regions_rendered = 0;
        }
    }

    @SubscribeEvent
    public void nextFrame(RenderWorldLastEvent e) {
        int currentFancy;
        this.runJobs(ChisledBlockRenderChunkTESR.getTracker().nextFrameTasks);
        this.uploadDisplaylists();
        int n = currentFancy = Minecraft.func_71410_x().field_71474_y.field_74347_j ? 1 : 0;
        if (currentFancy != this.lastFancy) {
            this.lastFancy = currentFancy;
            ChiselsAndBits.getInstance().clearCache();
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71438_f.func_72712_a();
        }
    }

    private void uploadDisplaylists() {
        WorldTracker trackers = ChisledBlockRenderChunkTESR.getTracker();
        Iterator i = trackers.futureTrackers.iterator();
        while (i.hasNext()) {
            if (!this.handleFutureTracker((FutureTracker)i.next())) continue;
            i.remove();
        }
        Stopwatch w = Stopwatch.createStarted();
        boolean dynamicRenderFullChunksOnly = ChiselsAndBits.getConfig().dynamicRenderFullChunksOnly;
        int maxMillisecondsPerBlock = ChiselsAndBits.getConfig().maxMillisecondsPerBlock;
        int maxMillisecondsUploadingPerFrame = ChiselsAndBits.getConfig().maxMillisecondsUploadingPerFrame;
        do {
            UploadTracker t;
            if ((t = (UploadTracker)trackers.uploaders.poll()) == null) {
                return;
            }
            if (t.trc instanceof TileRenderChunk) {
                Stopwatch sw = Stopwatch.createStarted();
                this.uploadDisplayList(t);
                if (!dynamicRenderFullChunksOnly && sw.elapsed(TimeUnit.MILLISECONDS) > (long)maxMillisecondsPerBlock) {
                    ((TileRenderChunk)t.trc).singleInstanceMode = true;
                }
            } else {
                this.uploadDisplayList(t);
            }
            t.trc.getLayer((BlockRenderLayer)t.layer).waiting = false;
        } while (w.elapsed(TimeUnit.MILLISECONDS) < (long)maxMillisecondsUploadingPerFrame);
    }

    private void runJobs(Queue<Runnable> tasks) {
        Runnable x;
        while ((x = tasks.poll()) != null) {
            x.run();
        }
    }

    private void uploadDisplayList(UploadTracker t) {
        BlockRenderLayer layer = t.layer;
        TileLayerRenderCache tlrc = t.trc.getLayer(layer);
        Tessellator tx = t.getTessellator();
        if (tlrc.displayList == null) {
            tlrc.displayList = GfxRenderState.getNewState(tx.func_178180_c().func_178989_h());
        }
        tlrc.displayList = tlrc.displayList.prepare(tx);
        t.submitForReuse();
    }

    public ChisledBlockRenderChunkTESR() {
        instance = this;
        ChiselsAndBits.registerWithBus((Object)this);
    }

    public void renderBreakingEffects(TileEntityBlockChiseled te, double x, double y, double z, float partialTicks, int destroyStage) {
        this.func_147499_a(TextureMap.field_110575_b);
        String file = field_178460_a[destroyStage].toString().replace("textures/", "").replace(".png", "");
        TextureAtlasSprite damageTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(file);
        GlStateManager.func_179094_E();
        GlStateManager.func_179143_c((int)515);
        BlockPos cp = te.func_174877_v();
        GlStateManager.func_179137_b((double)(x - (double)cp.func_177958_n()), (double)(y - (double)cp.func_177956_o()), (double)(z - (double)cp.func_177952_p()));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        IExtendedBlockState estate = te.getRenderState((IBlockAccess)te.func_145831_w());
        for (ChiselLayer lx : ChiselLayer.values()) {
            ChiseledBlockBaked model = ChiseledBlockSmartModel.getCachedModel(te, lx);
            if (model.isEmpty()) continue;
            IBakedModel damageModel = new SimpleBakedModel.Builder((IBlockState)estate, (IBakedModel)model, damageTexture, cp).func_177645_b();
            blockRenderer.func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), damageModel, (IBlockState)estate, te.func_174877_v(), buffer, false);
        }
        tessellator.func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179117_G();
        GlStateManager.func_179121_F();
    }

    private void renderTileEntityInner(TileEntityBlockChiseledTESR te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder worldRenderer) {
        if (destroyStage > 0) {
            this.renderLogic(te, x, y, z, partialTicks, destroyStage, false);
            return;
        }
        this.renderLogic(te, x, y, z, partialTicks, destroyStage, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLogic(TileEntityBlockChiseledTESR te, double x, double y, double z, float partialTicks, int destroyStage, boolean groupLogic) {
        GfxRenderState dl;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderPass() == 0 ? BlockRenderLayer.SOLID : BlockRenderLayer.TRANSLUCENT;
        TileRenderChunk renderChunk = te.getRenderChunk();
        TileRenderCache renderCache = renderChunk;
        if (renderChunk == null) {
            return;
        }
        if (destroyStage >= 0) {
            if (layer == BlockRenderLayer.SOLID) {
                return;
            }
            this.renderBreakingEffects(te, x, y, z, partialTicks, destroyStage);
            return;
        }
        if (renderChunk.singleInstanceMode) {
            if (groupLogic) {
                EnumTESRRenderState state = renderCache.update(layer, 0);
                if (renderCache == null || state == EnumTESRRenderState.SKIP) {
                    return;
                }
                TileList tiles = renderChunk.getTiles();
                tiles.getReadLock().lock();
                try {
                    for (TileEntityBlockChiseledTESR e : tiles) {
                        this.configureGLState(layer);
                        this.renderLogic(e, x, y, z, partialTicks, destroyStage, false);
                        this.unconfigureGLState();
                    }
                }
                finally {
                    tiles.getReadLock().unlock();
                }
                return;
            }
            renderCache = te.getCache();
        }
        EnumTESRRenderState state = renderCache.update(layer, 0);
        if (renderCache == null || state == EnumTESRRenderState.SKIP) {
            return;
        }
        BlockPos chunkOffset = renderChunk.chunkOffset();
        TileLayerRenderCache tlrc = renderCache.getLayer(layer);
        boolean isNew = tlrc.isNew();
        boolean hasSubmitted = false;
        if (tlrc.displayList == null || tlrc.rebuild) {
            int dynamicTess = ChisledBlockRenderChunkTESR.getMaxTessalators();
            if (pendingTess.get() < dynamicTess && tlrc.future == null && !tlrc.waiting || isNew) {
                ChunkCache cache = new ChunkCache(this.func_178459_a(), chunkOffset, chunkOffset.func_177982_a(16, 16, 16), 1);
                FutureTask<Tessellator> newFuture = new FutureTask<Tessellator>(new ChisledBlockBackgroundRender(cache, chunkOffset, renderCache.getTileList(), layer));
                try {
                    pool.submit(newFuture);
                    hasSubmitted = true;
                    if (tlrc.future != null) {
                        tlrc.future.cancel(true);
                    }
                    tlrc.rebuild = false;
                    tlrc.future = newFuture;
                    pendingTess.incrementAndGet();
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        if (tlrc.future != null && isNew && hasSubmitted) {
            try {
                Tessellator tess = tlrc.future.get(ChiselsAndBits.getConfig().minimizeLatancyMaxTime, TimeUnit.MILLISECONDS);
                tlrc.future = null;
                pendingTess.decrementAndGet();
                this.uploadDisplayList(new UploadTracker(renderCache, layer, tess));
                tlrc.waiting = false;
            }
            catch (InterruptedException e) {
                Log.logError("Failed to get TESR Future - A", e);
                tlrc.future = null;
            }
            catch (ExecutionException e) {
                Log.logError("Failed to get TESR Future - B", e);
                tlrc.future = null;
            }
            catch (TimeoutException e) {
                this.addFutureTracker(tlrc, renderCache, layer);
            }
        } else if (tlrc.future != null && hasSubmitted) {
            this.addFutureTracker(tlrc, renderCache, layer);
        }
        if ((dl = tlrc.displayList) != null && dl.shouldRender()) {
            if (!dl.validForUse()) {
                tlrc.displayList = null;
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-TileEntityRendererDispatcher.field_147554_b + (double)chunkOffset.func_177958_n()), (double)(-TileEntityRendererDispatcher.field_147555_c + (double)chunkOffset.func_177956_o()), (double)(-TileEntityRendererDispatcher.field_147552_d + (double)chunkOffset.func_177952_p()));
            this.configureGLState(layer);
            if (dl.render()) {
                this.markRendered(renderChunk.singleInstanceMode);
            }
            this.unconfigureGLState();
            GL11.glPopMatrix();
        }
    }

    public static int getMaxTessalators() {
        int dynamicTess = ChiselsAndBits.getConfig().dynamicMaxConcurrentTessalators;
        if (ChiselsAndBits.getConfig().lowMemoryMode) {
            dynamicTess = Math.min(2, dynamicTess);
        }
        return dynamicTess;
    }

    private void configureGLState(BlockRenderLayer layer) {
        ++this.isConfigured;
        if (this.isConfigured == 1) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)0.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147499_a(TextureMap.field_110575_b);
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (layer == BlockRenderLayer.TRANSLUCENT) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
            } else {
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179098_w();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
        }
    }

    private void unconfigureGLState() {
        --this.isConfigured;
        if (this.isConfigured > 0) {
            return;
        }
        GlStateManager.func_179117_G();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        RenderHelper.func_74519_b();
    }

    public void renderTileEntityFast(TileEntityBlockChiseledTESR te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        this.renderTileEntityInner(te, x, y, z, partialTicks, destroyStage, buffer);
    }

    public void func_192841_a(TileEntityBlockChiseledTESR te, double x, double y, double z, float partialTicks, int destroyStage, float partial) {
        if (destroyStage > 0) {
            this.renderTileEntityInner(te, x, y, z, partialTicks, destroyStage, null);
        }
    }

    static {
        TESR_Regions_rendered = 0;
        TESR_SI_Regions_rendered = 0;
        worldTrackers = new WeakHashMap();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(4);
                t.setName("C&B Dynamic Render Thread");
                return t;
            }
        };
        int processors = Runtime.getRuntime().availableProcessors();
        if (ChiselsAndBits.getConfig().lowMemoryMode) {
            processors = 1;
        }
        pool = new ThreadPoolExecutor(1, processors, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(64), threadFactory);
        pool.allowCoreThreadTimeOut(false);
    }

    private static class FutureTracker {
        final TileLayerRenderCache tlrc;
        final TileRenderCache renderCache;
        final BlockRenderLayer layer;
        final FutureTask<Tessellator> future;

        public FutureTracker(TileLayerRenderCache tlrc, TileRenderCache renderCache, BlockRenderLayer layer) {
            this.tlrc = tlrc;
            this.renderCache = renderCache;
            this.layer = layer;
            this.future = tlrc.future;
        }

        public void done() {
            pendingTess.decrementAndGet();
        }
    }

    private static class WorldTracker {
        private final LinkedList<FutureTracker> futureTrackers = new LinkedList();
        private final Queue<UploadTracker> uploaders = new ConcurrentLinkedQueue<UploadTracker>();
        private final Queue<Runnable> nextFrameTasks = new ConcurrentLinkedQueue<Runnable>();

        private WorldTracker() {
        }
    }
}

