/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio;

import com.mia.craftstudio.CSExceptions;
import com.mia.craftstudio.CSProject;
import com.mia.craftstudio.CraftStudioLib;
import com.mia.craftstudio.libgdx.Quaternion;
import com.mia.craftstudio.utils.ImageIOCS;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CSModel {
    private final byte asset_type;
    private final short format_version;
    private final short next_unused_id;
    private final short node_count;
    private final Map<Short, ModelNode> nodes = new LinkedHashMap<Short, ModelNode>();
    private final Set<ModelNode> topNodes = new HashSet<ModelNode>();
    private final int texture_size;
    private final byte[] texture_data;
    private final short animation_count;
    private final short[] animation_asset_id;
    private static final String sep = ".";
    private BufferedImage texture;
    private boolean hasTransparency = false;
    private ModelNode root;
    private final HashMap<String, ArrayList<Short>> asset_ids_for_name = new HashMap();
    private final HashMap<Short, ArrayList<Short>> animation_conflict_blacklist = new HashMap();

    public CSModel(ByteBuffer buffer) throws CSExceptions.TypeMismatchException, CSExceptions.UnsupportedVersionException, IOException {
        this.asset_type = buffer.get();
        if (this.asset_type != 0) {
            throw new CSExceptions.TypeMismatchException((byte)0, this.asset_type);
        }
        this.format_version = buffer.getShort();
        if (this.format_version != 5) {
            throw new CSExceptions.UnsupportedVersionException(this.format_version);
        }
        this.next_unused_id = buffer.getShort();
        this.node_count = buffer.getShort();
        for (int i = 0; i < this.node_count; ++i) {
            ModelNode node = new ModelNode(this, buffer);
            this.nodes.put(node.getNodeID(), node);
        }
        for (ModelNode node : this.nodes.values()) {
            node.parseAttributes();
        }
        this.texture_size = buffer.getInt();
        this.texture_data = new byte[this.texture_size];
        buffer.get(this.texture_data);
        this.animation_count = buffer.getShort();
        this.animation_asset_id = new short[this.animation_count];
        for (int i = 0; i < this.animation_count; ++i) {
            this.animation_asset_id[i] = buffer.getShort();
        }
        for (ModelNode node : this.nodes.values()) {
            if (node.getParentNodeID() == -1) {
                if (this.root == null && node.name.startsWith("RootNode")) {
                    this.root = node;
                }
                this.topNodes.add(node);
                continue;
            }
            ModelNode parent = this.nodes.get(node.getParentNodeID());
            parent.addChild(node);
            node.setParent(parent);
        }
        for (ModelNode node : this.nodes.values()) {
            node.genFullName();
        }
        this.texture = ImageIOCS.read(new ByteArrayInputStream(this.texture_data));
        if (this.texture == null) {
            this.texture = CraftStudioLib.getDefaultTexture();
        }
        WritableRaster alphaChannel = this.texture.getAlphaRaster();
        for (ModelNode node : this.nodes.values()) {
            node.checkTransparency(alphaChannel);
            this.hasTransparency = this.hasTransparency || node.hasAttribute(ModelNode.Attrb.TRANSPARENT);
        }
        for (ModelNode node : this.nodes.values()) {
            if (!this.asset_ids_for_name.containsKey(node.getName())) {
                this.asset_ids_for_name.put(node.getName(), new ArrayList());
            }
            this.asset_ids_for_name.get(node.getName()).add(node.getNodeID());
        }
        if (this.animation_count > 0) {
            for (Object animID : (Object)this.animation_asset_id) {
                this.animation_conflict_blacklist.put((short)animID, new ArrayList());
            }
        }
    }

    public BufferedImage getTexture() {
        return this.texture;
    }

    public byte[] getRawTexture() {
        return this.texture_data;
    }

    public Collection<ModelNode> getNodes() {
        return this.nodes.values();
    }

    public Collection<ModelNode> getTopNodes() {
        return this.topNodes;
    }

    public short getAnimationCount() {
        return this.animation_count;
    }

    public short[] getAnimationAssetIDS() {
        return this.animation_asset_id;
    }

    public boolean hasTransparency() {
        return this.hasTransparency;
    }

    public ModelNode getRootNode() {
        return this.root;
    }

    public void setupAnimationBlacklists(CSProject project) {
        if (this.animation_count < 2) {
            return;
        }
        for (short test_anim = 0; test_anim < this.animation_count; test_anim = (short)(test_anim + 1)) {
            for (short target_anim = 0; target_anim < this.animation_count; target_anim = (short)(target_anim + 1)) {
                Set<String> dupes = project.getAnimation(Integer.valueOf(test_anim)).getModelNamesAffected();
                dupes.retainAll(project.getAnimation(Integer.valueOf(target_anim)).getModelNamesAffected());
                if (dupes.isEmpty()) continue;
                this.animation_conflict_blacklist.get(test_anim).add(target_anim);
                this.animation_conflict_blacklist.get(target_anim).add(test_anim);
            }
        }
    }

    public static class ModelNode {
        private final short id;
        private final short parent_node_id;
        private final String name;
        private final float[] position = new float[3];
        private final float[] offset = new float[3];
        private final float[] scale = new float[3];
        private final Quaternion orientation;
        private final short[] size = new short[3];
        private final byte unwrap;
        private final Point[] quads = new Point[6];
        private final byte[] uvtransform = new byte[6];
        private final Set<ModelNode> children = new HashSet<ModelNode>();
        private ModelNode parent = null;
        private final CSModel csmodel;
        private EnumSet<Attrb> attributes = EnumSet.noneOf(Attrb.class);
        private boolean attributesParsed = false;
        private String fullName;

        public ModelNode(CSModel model, ByteBuffer buffer) {
            int i;
            this.csmodel = model;
            this.id = buffer.getShort();
            this.parent_node_id = buffer.getShort();
            byte[] tmpName = new byte[buffer.get()];
            buffer.get(tmpName);
            this.name = new String(tmpName);
            this.fullName = this.getCleanName();
            for (i = 0; i < 3; ++i) {
                this.position[i] = buffer.getFloat();
            }
            for (i = 0; i < 3; ++i) {
                this.offset[i] = buffer.getFloat();
            }
            for (i = 0; i < 3; ++i) {
                this.scale[i] = buffer.getFloat();
            }
            this.orientation = new Quaternion(buffer);
            for (i = 0; i < 3; ++i) {
                this.size[i] = buffer.getShort();
            }
            this.unwrap = buffer.get();
            for (i = 0; i < 6; ++i) {
                this.quads[i] = new Point(buffer);
            }
            for (i = 0; i < 6; ++i) {
                this.uvtransform[i] = buffer.get();
            }
        }

        private void parseAttributes() {
            if (this.attributesParsed) {
                return;
            }
            String s = this.name.contains("$") ? this.name.split("\\$")[1] : "";
            for (Attrb a : Attrb.values()) {
                boolean addAttrib = false;
                if (a.hasAttribute(s)) {
                    addAttrib = true;
                } else if (a.propagates() && this.parent_node_id != -1) {
                    ModelNode parentNode = (ModelNode)this.csmodel.nodes.get(this.parent_node_id);
                    parentNode.parseAttributes();
                    addAttrib = parentNode.hasAttribute(a);
                }
                if (!addAttrib) continue;
                this.attributes.add(a);
            }
            this.attributesParsed = true;
        }

        public boolean hasAttribute(Attrb a) {
            return this.attributes.contains((Object)a);
        }

        public Point getTextureOffset() {
            int x = Integer.MAX_VALUE;
            int y = Integer.MAX_VALUE;
            for (int i = 0; i < 6; ++i) {
                x = Math.min(x, this.quads[i].x);
                y = Math.min(y, this.quads[i].y);
            }
            return new Point(x, y);
        }

        public String getName() {
            return this.name;
        }

        public String getCleanName() {
            return this.name.split("\\$")[0];
        }

        public String getFullName() {
            return this.fullName;
        }

        public void genFullName() {
            this.fullName = this.getCleanName();
            ModelNode currNode = this;
            while (currNode.getParent() != null) {
                currNode = currNode.getParent();
                this.fullName = currNode.getCleanName() + CSModel.sep + this.fullName;
            }
        }

        public short[] getSize() {
            return this.size;
        }

        public float[] getSize(float scale) {
            return new float[]{(float)this.size[0] * scale, (float)this.size[1] * scale, (float)this.size[2] * scale};
        }

        public float[] getPosition() {
            return this.position;
        }

        public Quaternion getOrientation() {
            return this.orientation.cpy();
        }

        public short getParentNodeID() {
            return this.parent_node_id;
        }

        public short getNodeID() {
            return this.id;
        }

        public float[] getOffset() {
            return this.offset;
        }

        public float[] getScale() {
            return this.scale;
        }

        public Set<ModelNode> getChildren() {
            return this.children;
        }

        public ModelNode getParent() {
            return this.parent;
        }

        public void addChild(ModelNode child) {
            this.children.add(child);
        }

        public void setParent(ModelNode parent) {
            this.parent = parent;
        }

        public CSModel getModel() {
            return this.csmodel;
        }

        public BufferedImage getTexture() {
            return this.csmodel.getTexture();
        }

        public Point[] getQuads() {
            return this.quads;
        }

        public boolean isNull() {
            return this.size[0] == 0 && this.size[1] == 0 && this.size[2] == 0;
        }

        public byte[] getUVTransform() {
            return this.uvtransform;
        }

        public boolean checkTransparency(Raster alphaChannel) {
            if (alphaChannel == null) {
                return false;
            }
            int[][] values = new int[6][];
            try {
                values[0] = alphaChannel.getPixels(this.quads[0].x, this.quads[0].y, (int)this.size[0], (int)this.size[1], (int[])null);
                values[1] = alphaChannel.getPixels(this.quads[1].x, this.quads[1].y, (int)this.size[0], (int)this.size[1], (int[])null);
                values[2] = alphaChannel.getPixels(this.quads[2].x, this.quads[2].y, (int)this.size[0], (int)this.size[1], (int[])null);
                values[3] = alphaChannel.getPixels(this.quads[3].x, this.quads[3].y, (int)this.size[0], (int)this.size[2], (int[])null);
                values[4] = alphaChannel.getPixels(this.quads[4].x, this.quads[4].y, (int)this.size[2], (int)this.size[1], (int[])null);
                values[5] = alphaChannel.getPixels(this.quads[5].x, this.quads[5].y, (int)this.size[0], (int)this.size[2], (int[])null);
                int[][] nArrayArray = values;
                int n = nArrayArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] pixels;
                    for (int i2 : pixels = nArrayArray[i]) {
                        if (i2 == 0 || i2 == 255) continue;
                        this.attributes.add(Attrb.TRANSPARENT);
                        return true;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return false;
        }

        public String toString() {
            return String.format("CSMODEL %s | Position : [%.2f %.2f %.2f] | Size : [%d %d %d]", this.name, Float.valueOf(this.position[0]), Float.valueOf(this.position[1]), Float.valueOf(this.position[2]), this.size[0], this.size[1], this.size[2]);
        }

        public static enum Attrb {
            PASSABLE("p"),
            PASSABLEPROPAGATES("P", true),
            TRANSPARENT("2"),
            IGNOREBELOWYPLANE("y"),
            COLORPRIMARY("C"),
            COLORSECONDARY("c"),
            COLORACCENTPRIMARY("A"),
            COLORACCENTSECONDARY("a"),
            AMBIENTOCCLUSION("o");

            private final String controlChar;
            private final boolean propagates;

            private Attrb(String controlChar) {
                this.controlChar = controlChar;
                this.propagates = false;
            }

            private Attrb(String controlChar, boolean propagates) {
                this.controlChar = controlChar;
                this.propagates = propagates;
            }

            public boolean hasAttribute(String s) {
                return s.contains(this.controlChar);
            }

            public final boolean propagates() {
                return this.propagates;
            }
        }
    }

    public static class Point {
        public final int x;
        public final int y;

        public Point(ByteBuffer buffer) {
            this.x = buffer.getInt();
            this.y = buffer.getInt();
        }

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

